# bsbuffer
`import "github.com/SergeyFrolov/bsbuffer"`

* [Overview](#pkg-overview)
* [Imported Packages](#pkg-imports)
* [Index](#pkg-index)

## <a name="pkg-overview">Overview</a>

## <a name="pkg-imports">Imported Packages</a>

No packages beyond the Go standard library are imported.

## <a name="pkg-index">Index</a>
* [type BSBuffer](#BSBuffer)
  * [func NewBSBuffer() \*BSBuffer](#NewBSBuffer)
  * [func (b \*BSBuffer) Read(p []byte) (n int, err error)](#BSBuffer.Read)
  * [func (b \*BSBuffer) Unblock()](#BSBuffer.Unblock)
  * [func (b \*BSBuffer) Write(p []byte) (n int, err error)](#BSBuffer.Write)

#### <a name="pkg-files">Package files</a>
[bsbuffer.go](./bsbuffer.go) 

## <a name="BSBuffer">type</a> [BSBuffer](./bsbuffer.go#L17-L29)
``` go
type BSBuffer struct {
    sync.Mutex
    // contains filtered or unexported fields
}
```
BSBuffer:
B - Blocking - Read() calls are blocking.
S - Safe - Supports arbitrary amount of readers and writers.
Could be unblocked and turned into SBuffer.

### <a name="NewBSBuffer">func</a> [NewBSBuffer](./bsbuffer.go#L32)
``` go
func NewBSBuffer() *BSBuffer
```
Creates new BSBuffer

### <a name="BSBuffer.Read">func</a> (\*BSBuffer) [Read](./bsbuffer.go#L63)
``` go
func (b *BSBuffer) Read(p []byte) (n int, err error)
```
Reads data from the BSBuffer, blocking until a writer arrives or the BSBuffer is unblocked.
If the write end is closed with an error, that error is returned as err; otherwise err is EOF.
Supports multiple concurrent goroutines and p is valid forever.

### <a name="BSBuffer.Unblock">func</a> (\*BSBuffer) [Unblock](./bsbuffer.go#L108)
``` go
func (b *BSBuffer) Unblock()
```
Turns BSBuffer into SBuffer: Read() is no longer blocking, but still safe.
Unblock() is safe to call multiple times.

### <a name="BSBuffer.Write">func</a> (\*BSBuffer) [Write](./bsbuffer.go#L85)
``` go
func (b *BSBuffer) Write(p []byte) (n int, err error)
```
Non-blocking write appends the contents of p to the buffer, growing the buffer as needed.
The return value n is the length of p; err is always nil.
If the buffer becomes too large, Write will panic with ErrTooLarge.
Supports multiple concurrent goroutines and p is safe for reuse right away.

- - -
Generated by [godoc2ghmd](https://github.com/GandalfUK/godoc2ghmd)