// For documentation of the format, see README in this directory.
var browserTests = [
["foo[]bar",
    [["strikethrough",""]],
    "foo[]bar",
    [true],
    {"strikethrough":[false,false,"",false,true,""]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<p><span style=\"text-decoration:line-through\">[foo</span></p> <p><span style=\"text-decoration:line-through\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<p><strike>[foo</strike></p> <p><strike>bar]</strike></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
// The first <span> should be styled with text-decoration, then, it becomes a
// good container for the following text node and the other <span>.
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\"><span>foo</span> <span>bar</span></span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<strike><span>[foo</span> <span>bar]</span></strike>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
// Entire the content of the first <p> and the last <p> should be wrapped in
// new <span> elements, and in the middle <p>, the <span> element should be
// styled but the invisible text nodes should be ignored.
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<p><span style=\"text-decoration:line-through\">[foo</span></p><p> <span style=\"text-decoration:line-through\">bar</span> </p><p><span style=\"text-decoration:line-through\">baz</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<p><strike>[foo</strike></p><p> <strike><span>bar</span></strike> </p><p><strike>baz]</strike></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","true"],["strikethrough",""]],
    "<p><span style=\"text-decoration:line-through\">[foo</span></p><p><span style=\"text-decoration:line-through\"><br></span></p><p><span style=\"text-decoration:line-through\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","false"],["strikethrough",""]],
    "<p><strike>[foo</strike></p><p><strike><br></strike></p><p><strike>bar]</strike></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<b>foo[]bar</b>",
    [["strikethrough",""]],
    "<b>foo[]bar</b>",
    [true],
    {"strikethrough":[false,false,"",false,true,""]}],
["<i>foo[]bar</i>",
    [["strikethrough",""]],
    "<i>foo[]bar</i>",
    [true],
    {"strikethrough":[false,false,"",false,true,""]}],
["<span>foo</span>{}<span>bar</span>",
    [["strikethrough",""]],
    "<span>foo</span>{}<span>bar</span>",
    [true],
    {"strikethrough":[false,false,"",false,true,""]}],
["<span>foo[</span><span>]bar</span>",
    [["strikethrough",""]],
    "<span>foo[</span><span>]bar</span>",
    [true],
    {"strikethrough":[false,false,"",false,true,""]}],
["foo[bar]baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:line-through\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo[bar]baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<strike>[bar]</strike>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:line-through\">[bar</span><b><span style=\"text-decoration:line-through\">baz]</span>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<strike>[bar</strike><b><strike>baz]</strike>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:line-through\">[bar</span><i><span style=\"text-decoration:line-through\">baz]</span>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<strike>[bar</strike><i><strike>baz]</strike>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","true"],["strikethrough",""]],
    "{<p></p><p> </p><p><span style=\"text-decoration:line-through\">foo</span></p>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","false"],["strikethrough",""]],
    "{<p></p><p> </p><p><strike>foo</strike></p>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<table><tbody><tr><td>foo</td><td>b<span style=\"text-decoration:line-through\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<table><tbody><tr><td>foo</td><td>b<strike>[a]</strike>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<table><tbody><tr><td>foo</td>{<td><span style=\"text-decoration:line-through\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<table><tbody><tr><td>foo</td>{<td><strike>bar</strike></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<table><tbody><tr>{<td><span style=\"text-decoration:line-through\">foo</span></td><td><span style=\"text-decoration:line-through\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<table><tbody><tr>{<td><strike>foo</strike></td><td><strike>bar</strike></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<table><tbody>{<tr><td><span style=\"text-decoration:line-through\">foo</span></td><td><span style=\"text-decoration:line-through\">bar</span></td><td><span style=\"text-decoration:line-through\">baz</span></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<table><tbody>{<tr><td><strike>foo</strike></td><td><strike>bar</strike></td><td><strike>baz</strike></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<table>{<tbody><tr><td><span style=\"text-decoration:line-through\">foo</span></td><td><span style=\"text-decoration:line-through\">bar</span></td><td><span style=\"text-decoration:line-through\">baz</span></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<table>{<tbody><tr><td><strike>foo</strike></td><td><strike>bar</strike></td><td><strike>baz</strike></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","true"],["strikethrough",""]],
    "{<table><tbody><tr><td><span style=\"text-decoration:line-through\">foo</span></td><td><span style=\"text-decoration:line-through\">bar</span></td><td><span style=\"text-decoration:line-through\">baz</span></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","false"],["strikethrough",""]],
    "{<table><tbody><tr><td><strike>foo</strike></td><td><strike>bar</strike></td><td><strike>baz</strike></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
// <u> is just representing underline style. Therefore, browsers should not
// keep it. Instead, it should be replaced with new <span> and set its
// text-decoration to line-through (requested style) and underline (default
// style of <u>).
["foo<u>[bar]</u>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:underline line-through\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<u>[bar]</u>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<u><strike>[bar]</strike></u>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
// The <span> which is a  container of the range has text-decoration style.
// Therefore, it should be updated rather than creating new element.
["foo<span style=\"text-decoration: underline\">[bar]</span>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:underline line-through\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<span style=\"text-decoration: underline\">[bar]</span>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<strike><span style=\"text-decoration:underline\">[bar]</span></strike>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[bar]baz</u>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<u>foo<span style=\"text-decoration:line-through\">[bar]</span>baz</u>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[bar]baz</u>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<u>foo<strike>[bar]</strike>baz</u>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[b<span style=\"color:blue\">ar]ba</span>z</u>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<u>foo<span style=\"text-decoration:line-through\">[b</span><span style=\"color:rgb(0, 0, 255)\"><span style=\"text-decoration:line-through\">ar]</span>ba</span>z</u>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[b<span style=\"color:blue\">ar]ba</span>z</u>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<u>foo<strike>[b</strike><span style=\"color:rgb(0, 0, 255)\"><strike>ar]</strike>ba</span>z</u>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</u>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<u>foo<span style=\"text-decoration:line-through\">[b</span><span style=\"color:rgb(0, 0, 255)\" id=\"foo\"><span style=\"text-decoration:line-through\">ar]</span>ba</span>z</u>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</u>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<u>foo<strike>[b</strike><span style=\"color:rgb(0, 0, 255)\" id=\"foo\"><strike>ar]</strike>ba</span>z</u>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[b<span style=\"font-size:3em\">ar]ba</span>z</u>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<u>foo<span style=\"text-decoration:line-through\">[b</span><span style=\"font-size:3em\"><span style=\"text-decoration:line-through\">ar]</span>ba</span>z</u>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[b<span style=\"font-size:3em\">ar]ba</span>z</u>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<u>foo<strike>[b</strike><span style=\"font-size:3em\"><strike>ar]</strike>ba</span>z</u>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[b<i>ar]ba</i>z</u>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<u>foo<span style=\"text-decoration:line-through\">[b</span><i><span style=\"text-decoration:line-through\">ar]</span>ba</i>z</u>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<u>foo[b<i>ar]ba</i>z</u>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<u>foo<strike>[b</strike><i><strike>ar]</strike>ba</i>z</u>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<p style=\"text-decoration: underline\">foo[bar]baz</p>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<p style=\"text-decoration:underline\">foo<span style=\"text-decoration:line-through\">[bar]</span>baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<p style=\"text-decoration: underline\">foo[bar]baz</p>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<p style=\"text-decoration:underline\">foo<strike>[bar]</strike>baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<span style=\"text-decoration: line-through\">[bar]</span>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<span style=\"text-decoration: line-through\">[bar]</span>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
// Should not replace existing <s> with <strike>/<span> when removing the style
// partially.
["<s>foo[bar]baz</s>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<s>foo</s>[bar]<s>baz</s>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[bar]baz</s>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>foo</s>[bar]<s>baz</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[b<span style=\"color:blue\">ar]ba</span>z</s>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<s>foo</s>b<span style=\"color:rgb(0, 0, 255)\">ar<span style=\"text-decoration-line:line-through\">ba</span></span><s>z</s>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[b<span style=\"color:blue\">ar]ba</span>z</s>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>foo</s>b<span style=\"color:rgb(0, 0, 255)\">ar<strike>ba</strike></span><s>z</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</s>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<s>foo</s>b<span style=\"color:rgb(0, 0, 255)\" id=\"foo\">ar<span style=\"text-decoration-line:line-through\">ba</span></span><s>z</s>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</s>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>foo</s>b<span style=\"color:rgb(0, 0, 255)\" id=\"foo\">ar<strike>ba</strike></span><s>z</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[b<span style=\"font-size:3em\">ar]ba</span>z</s>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<s>foo</s>b<span style=\"font-size:3em\">ar<span style=\"text-decoration-line:line-through\">ba</span></span><s>z</s>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[b<span style=\"font-size:3em\">ar]ba</span>z</s>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>foo</s>b<span style=\"font-size:3em\">ar<strike>ba</strike></span><s>z</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[b<i>ar]ba</i>z</s>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<s>foo</s>b<i>ar<span style=\"text-decoration-line:line-through\">ba</span></i><s>z</s>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>foo[b<i>ar]ba</i>z</s>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>foo</s>b<i>ar<strike>ba</strike></i><s>z</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<strike>[bar]</strike>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<strike>[bar]</strike>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[bar]baz</strike>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\">foo</span>[bar]<span style=\"text-decoration:line-through\">baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[bar]baz</strike>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<strike>foo</strike>[bar]<strike>baz</strike>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[b<span style=\"color:blue\">ar]ba</span>z</strike>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\">foo</span>[b<span style=\"color:rgb(0, 0, 255)\">ar]<span style=\"text-decoration:line-through\">ba</span></span><span style=\"text-decoration:line-through\">z</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[b<span style=\"color:blue\">ar]ba</span>z</strike>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<strike>foo</strike>[b<span style=\"color:rgb(0, 0, 255)\">ar]<strike>ba</strike></span><strike>z</strike>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</strike>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\">foo</span>[b<span style=\"color:rgb(0, 0, 255)\" id=\"foo\">ar]<span style=\"text-decoration:line-through\">ba</span></span><span style=\"text-decoration:line-through\">z</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</strike>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<strike>foo</strike>[b<span style=\"color:rgb(0, 0, 255)\" id=\"foo\">ar]<strike>ba</strike></span><strike>z</strike>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[b<span style=\"font-size:3em\">ar]ba</span>z</strike>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\">foo</span>[b<span style=\"font-size:3em\">ar]<span style=\"text-decoration:line-through\">ba</span></span><span style=\"text-decoration:line-through\">z</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[b<span style=\"font-size:3em\">ar]ba</span>z</strike>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<strike>foo</strike>[b<span style=\"font-size:3em\">ar]<strike>ba</strike></span><strike>z</strike>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[b<i>ar]ba</i>z</strike>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<span style=\"text-decoration:line-through\">foo</span>[b<i>ar]<span style=\"text-decoration:line-through\">ba</span></i><span style=\"text-decoration:line-through\">z</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>foo[b<i>ar]ba</i>z</strike>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<strike>foo</strike>[b<i>ar]<strike>ba</strike></i><strike>z</strike>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
// Should set text-decoration of <ins> because it has underline style by
// default and it is not only representing it, thus, replacing it with <span>
// changes the meaning.
["foo<ins>[bar]</ins>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<ins style=\"text-decoration:underline line-through\">[bar]</ins>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<ins>[bar]</ins>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<ins><strike>[bar]</strike></ins>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[bar]baz</ins>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<ins>foo<span style=\"text-decoration:line-through\">[bar]</span>baz</ins>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[bar]baz</ins>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<ins>foo<strike>[bar]</strike>baz</ins>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[b<span style=\"color:blue\">ar]ba</span>z</ins>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<ins>foo<span style=\"text-decoration:line-through\">[b</span><span style=\"color:rgb(0, 0, 255)\"><span style=\"text-decoration:line-through\">ar]</span>ba</span>z</ins>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[b<span style=\"color:blue\">ar]ba</span>z</ins>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<ins>foo<strike>[b</strike><span style=\"color:rgb(0, 0, 255)\"><strike>ar]</strike>ba</span>z</ins>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</ins>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<ins>foo<span style=\"text-decoration:line-through\">[b</span><span style=\"color:rgb(0, 0, 255)\" id=\"foo\"><span style=\"text-decoration:line-through\">ar]</span>ba</span>z</ins>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</ins>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<ins>foo<strike>[b</strike><span style=\"color:rgb(0, 0, 255)\" id=\"foo\"><strike>ar]</strike>ba</span>z</ins>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[b<span style=\"font-size:3em\">ar]ba</span>z</ins>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<ins>foo<span style=\"text-decoration:line-through\">[b</span><span style=\"font-size:3em\"><span style=\"text-decoration:line-through\">ar]</span>ba</span>z</ins>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[b<span style=\"font-size:3em\">ar]ba</span>z</ins>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<ins>foo<strike>[b</strike><span style=\"font-size:3em\"><strike>ar]</strike>ba</span>z</ins>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[b<i>ar]ba</i>z</ins>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<ins>foo<span style=\"text-decoration:line-through\">[b</span><i><span style=\"text-decoration:line-through\">ar]</span>ba</i>z</ins>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<ins>foo[b<i>ar]ba</i>z</ins>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<ins>foo<strike>[b</strike><i><strike>ar]</strike>ba</i>z</ins>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<del>[bar]</del>baz",
    [["strikethrough",""]],
    "foo<del>[bar]</del>baz",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["<del>foo[bar]baz</del>",
    [["strikethrough",""]],
    "<del>foo[bar]baz</del>",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["<del>foo[b<span style=\"color:blue\">ar]ba</span>z</del>",
    [["strikethrough",""]],
    "<del>foo[b<span style=\"color:rgb(0, 0, 255)\">ar]ba</span>z</del>",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["<del>foo[b<span style=\"color:blue\" id=foo>ar]ba</span>z</del>",
    [["strikethrough",""]],
    "<del>foo[b<span style=\"color:rgb(0, 0, 255)\" id=\"foo\">ar]ba</span>z</del>",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["<del>foo[b<span style=\"font-size:3em\">ar]ba</span>z</del>",
    [["strikethrough",""]],
    "<del>foo[b<span style=\"font-size:3em\">ar]ba</span>z</del>",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["<del>foo[b<i>ar]ba</i>z</del>",
    [["strikethrough",""]],
    "<del>foo[b<i>ar]ba</i>z</del>",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["foo<span style=\"text-decoration: underline line-through\">[bar]</span>baz",
    [["strikethrough",""]],
    "foo<span style=\"text-decoration:underline\">[bar]</span>baz",
    [true],
    {"strikethrough":[false,true,"",false,false,""]}],
["foo<span style=\"text-decoration: underline line-through\">b[a]r</span>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:underline\"><span style=\"text-decoration:line-through\">b</span>[a]<span style=\"text-decoration:line-through\">r</span></span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<span style=\"text-decoration: underline line-through\">b[a]r</span>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<span style=\"text-decoration:underline\"><strike>b</strike>[a]<strike>r</strike></span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
// <s> should be replaced with <strike> or <span> element.
["foo<s style=\"text-decoration: underline\">[bar]</s>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration-line:underline line-through\">bar</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<s style=\"text-decoration: underline\">[bar]</s>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<u><strike>bar</strike></u>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<s style=\"text-decoration: underline\">b[a]r</s>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<s style=\"text-decoration:underline\">b</s><span style=\"text-decoration-line:underline line-through\">a</span><s style=\"text-decoration:underline\">r</s>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<s style=\"text-decoration: underline\">b[a]r</s>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<s style=\"text-decoration:underline\">b</s><u><strike>a</strike></u><s style=\"text-decoration:underline\">r</s>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<u style=\"text-decoration: line-through\">[bar]</u>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<u style=\"text-decoration: line-through\">[bar]</u>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<u style=\"text-decoration: line-through\">b[a]r</u>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:line-through\">b</span>[a]<span style=\"text-decoration:line-through\">r</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<u style=\"text-decoration: line-through\">b[a]r</u>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<strike>b</strike>[a]<strike>r</strike>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<s style=\"text-decoration: overline\">[bar]</s>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration-line:overline line-through\">bar</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<s style=\"text-decoration: overline\">[bar]</s>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<span style=\"text-decoration-line:overline\"><strike>bar</strike></span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<s style=\"text-decoration: overline\">b[a]r</s>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<s style=\"text-decoration:overline\">b</s><span style=\"text-decoration-line:overline line-through\">a</span><s style=\"text-decoration:overline\">r</s>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<s style=\"text-decoration: overline\">b[a]r</s>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<s style=\"text-decoration:overline\">b</s><span style=\"text-decoration-line:overline\"><strike>a</strike></span><s style=\"text-decoration:overline\">r</s>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
// Should replace <u> with new <span> and set its `text-decoration` to
// line-though (for applying the requested style) and overline (which was
// specified to the <u>).  Note that underline was removed by the
// text-decoration setting. Therefore, it should not appear.
["foo<u style=\"text-decoration: overline\">[bar]</u>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span style=\"text-decoration:overline line-through\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<u style=\"text-decoration: overline\">[bar]</u>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<strike><u style=\"text-decoration:overline\">[bar]</u></strike>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<u style=\"text-decoration: overline\">b[a]r</u>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<u style=\"text-decoration:overline\">b<span style=\"text-decoration:line-through\">[a]</span>r</u>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<u style=\"text-decoration: overline\">b[a]r</u>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<u style=\"text-decoration:overline\">b<strike>[a]</strike>r</u>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["<p style=\"text-decoration: line-through\">foo[bar]baz</p>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<p><span style=\"text-decoration:line-through\">foo</span>[bar]<span style=\"text-decoration:line-through\">baz</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<p style=\"text-decoration: line-through\">foo[bar]baz</p>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<p><strike>foo</strike>[bar]<strike>baz</strike></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<p style=\"text-decoration: overline\">foo[bar]baz</p>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<p style=\"text-decoration:overline\">foo<span style=\"text-decoration:line-through\">[bar]</span>baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["<p style=\"text-decoration: overline\">foo[bar]baz</p>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<p style=\"text-decoration:overline\">foo<strike>[bar]</strike>baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<span class=\"underline\">[bar]</span>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span class=\"underline\" style=\"text-decoration:line-through\">bar</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<span class=\"underline\">[bar]</span>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<span class=\"underline\"><strike>[bar]</strike></span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<span class=\"underline\">b[a]r</span>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<span class=\"underline\">b<span style=\"text-decoration:line-through\">[a]</span>r</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<span class=\"underline\">b[a]r</span>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<span class=\"underline\">b<strike>[a]</strike>r</span>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,false,"",false,true,""]}],
["foo<span class=\"line-through\">[bar]</span>baz",
    [["strikethrough",""]],
    "foo<span class=\"line-through\">[bar]</span>baz",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["foo<span class=\"line-through\">b[a]r</span>baz",
    [["strikethrough",""]],
    "foo<span class=\"line-through\">b[a]r</span>baz",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["foo<span class=\"underline-and-line-through\">[bar]</span>baz",
    [["strikethrough",""]],
    "foo<span class=\"underline-and-line-through\">[bar]</span>baz",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
["foo<span class=\"underline-and-line-through\">b[a]r</span>baz",
    [["strikethrough",""]],
    "foo<span class=\"underline-and-line-through\">b[a]r</span>baz",
    [true],
    {"strikethrough":[false,true,"",false,true,""]}],
// Should wrap in new <strike> only when it's not wrapped in <s>
["fo[o<s>b]ar</s>baz",
    [["strikethrough",""]],
    "fo<strike>o</strike><s>bar</s>baz",
    [true],
    {"strikethrough":[true,false,"",false,true,""]}],
["foo<s>ba[r</s>b]az",
    [["strikethrough",""]],
    "foo<s>ba</s>rbaz",
    [true],
    {"strikethrough":[true,false,"",false,true,""]}],
["fo[o<s>bar</s>b]az",
    [["stylewithcss","true"],["strikethrough",""]],
    "fo<span style=\"text-decoration-line:line-through\">obarb</span>az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[true,false,"",false,true,""]}],
["fo[o<s>bar</s>b]az",
    [["stylewithcss","false"],["strikethrough",""]],
    "fo<strike>obarb</strike>az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[true,false,"",false,true,""]}],
["foo[<s>b]ar</s>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo[b]<s>ar</s>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo[<s>b]ar</s>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo[b]<s>ar</s>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<s>ba[r</s>]baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo<s>ba</s>[r]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<s>ba[r</s>]baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo<s>ba</s>[r]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["foo[<s>bar</s>]baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo[<s>bar</s>]baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<s>[bar]</s>baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo<s>[bar]</s>baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo[bar]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["foo{<s>bar</s>}baz",
    [["stylewithcss","true"],["strikethrough",""]],
    "foo{bar}baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["foo{<s>bar</s>}baz",
    [["stylewithcss","false"],["strikethrough",""]],
    "foo{bar}baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["fo[o<span style=text-decoration:line-through>b]ar</span>baz",
    [["strikethrough",""]],
    "fo<strike>o</strike><s>bar</s>baz",
    [true],
    {"strikethrough":[true,false,"",false,true,""]}],
["<strike>fo[o</strike><s>b]ar</s>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<strike>fo</strike>[ob]<s>ar</s>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",false,false,""]}],
["<strike>fo[o</strike><s>b]ar</s>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<strike>fo</strike>[ob]<s>ar</s>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",false,false,""]}],
["<s>fo[o</s><del>b]ar</del>",
    [["stylewithcss","true"],["strikethrough",""]],
    "<s>fo</s>[o<del>b]ar</del>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"strikethrough":[false,true,"",true,false,""]}],
["<s>fo[o</s><del>b]ar</del>",
    [["stylewithcss","false"],["strikethrough",""]],
    "<s>fo</s>[o<del>b]ar</del>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"strikethrough":[false,true,"",true,false,""]}],


// Tests to remove only strikethrough from existing text-decoration
["abc<span style=\"text-decoration:line-through overline underline\">[def]</span>ghi",
    [["stylewithcss","true"],["strikethrough",""]],
    ["abc<span style=\"text-decoration:underline overline\">[def]</span>ghi",
     "abc<span style=\"text-decoration-line:underline overline\">[def]</span>ghi"],
    [true,true],
    {}],

// blink, text-decoration-color and text-decoration-style values should be
// dropped.  This rule is odd because executing "underline" command causes
// the data loss, but for now, the compatibility between browsers is more
// important.  Once you want/need to change the behavior of a browser, you
// should file a spec issue first.
// And these tests allows the difference between text-decoration vs.
// text-decoration-line because these tests want to check the data loss.
["abc<span style=\"text-decoration:blink overline underline\">[def]</span>ghi",
    [["stylewithcss","true"],["strikethrough",""]],
    ["abc<span style=\"text-decoration:underline overline line-through\">[def]</span>ghi",
     "abc<span style=\"text-decoration-line:underline overline line-through\">[def]</span>ghi"],
    [true,true],
    {}],
["abc<span style=\"text-decoration:underline blue dotted\">[def]</span>ghi",
    [["stylewithcss","true"],["strikethrough",""]],
    ["abc<span style=\"text-decoration:underline line-through\">[def]</span>ghi",
     "abc<span style=\"text-decoration-line:underline line-through\">[def]</span>ghi"],
    [true,true],
    {}],
["abc<span style=\"text-decoration:blink line-through underline overline\">[def]</span>ghi",
    [["stylewithcss","true"],["strikethrough",""]],
    ["abc<span style=\"text-decoration:underline overline\">[def]</span>ghi",
     "abc<span style=\"text-decoration-line:underline overline\">[def]</span>ghi"],
    [true,true],
    {}],
["abc<span style=\"text-decoration:underline line-through blue dotted\">[def]</span>ghi",
    [["stylewithcss","true"],["strikethrough",""]],
    ["abc<span style=\"text-decoration:underline\">[def]</span>ghi",
     "abc<span style=\"text-decoration-line:underline\">[def]</span>ghi"],
    [true,true],
    {}],
]
