// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("UNUSED_PARAMETER")

package mozilla.appservices.remotetabs
import mozilla.appservices.sync15.DeviceType

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }









public interface RemoteCommandStoreInterface {
    
    /**
     * Add a new command, after which it will be pending. Returns false if the command is already active.
     */
    fun `addRemoteCommand`(`deviceId`: kotlin.String, `command`: RemoteCommand): kotlin.Boolean
    
    /**
     * Add a new command with an explicit timestamp. Primarily used by tests.
     */
    fun `addRemoteCommandAt`(`deviceId`: kotlin.String, `command`: RemoteCommand, `when`: Timestamp): kotlin.Boolean
    
    /**
     * Return all unsent commands. This is for the code sending the commands, result is sorted by time_requested.
     */
    fun `getUnsentCommands`(): List<PendingCommand>
    
    /**
     * Removes the remote command. Typically used to implement "undo" but may also be used by the queue
     * processor when it gives up trying to send a command.
     */
    fun `removeRemoteCommand`(`deviceId`: kotlin.String, `command`: RemoteCommand): kotlin.Boolean
    
    /**
     * Flag a command as sent.
     */
    fun `setPendingCommandSent`(`command`: PendingCommand): kotlin.Boolean
    
    companion object
}

open class RemoteCommandStore (
): AutoCloseable, Disposable, RemoteCommandStoreInterface
{

    
    /**
     * Add a new command, after which it will be pending. Returns false if the command is already active.
     */
    @Throws(TabsApiException::class)override fun `addRemoteCommand`(`deviceId`: kotlin.String, `command`: RemoteCommand): kotlin.Boolean {
            return  false
    }

    
    /**
     * Add a new command with an explicit timestamp. Primarily used by tests.
     */
    @Throws(TabsApiException::class)override fun `addRemoteCommandAt`(`deviceId`: kotlin.String, `command`: RemoteCommand, `when`: Timestamp): kotlin.Boolean {
            return  false
    }

    
    /**
     * Return all unsent commands. This is for the code sending the commands, result is sorted by time_requested.
     */
    @Throws(TabsApiException::class)override fun `getUnsentCommands`(): List<PendingCommand> {
            return  emptyList()
    }

    
    /**
     * Removes the remote command. Typically used to implement "undo" but may also be used by the queue
     * processor when it gives up trying to send a command.
     */
    @Throws(TabsApiException::class)override fun `removeRemoteCommand`(`deviceId`: kotlin.String, `command`: RemoteCommand): kotlin.Boolean {
            return  false
    }

    
    /**
     * Flag a command as sent.
     */
    @Throws(TabsApiException::class)override fun `setPendingCommandSent`(`command`: PendingCommand): kotlin.Boolean {
            return  false
    }

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



/**
 * Note the canonical docs for this are in https://searchfox.org/mozilla-central/source/services/interfaces/mozIBridgedSyncEngine.idl
 * It's only actually used in desktop, but it's fine to expose this everywhere.
 * NOTE: all timestamps here are milliseconds.
 */
public interface TabsBridgedEngineInterface {
    
    fun `apply`(): List<kotlin.String>
    
    fun `ensureCurrentSyncId`(`newSyncId`: kotlin.String): kotlin.String
    
    fun `lastSync`(): kotlin.Long
    
    fun `prepareForSync`(`clientData`: kotlin.String)
    
    fun `reset`()
    
    fun `resetSyncId`(): kotlin.String
    
    fun `setLastSync`(`lastSync`: kotlin.Long)
    
    fun `setUploaded`(`newTimestamp`: kotlin.Long, `uploadedIds`: List<TabsGuid>)
    
    fun `storeIncoming`(`incomingEnvelopesAsJson`: List<kotlin.String>)
    
    fun `syncFinished`()
    
    fun `syncId`(): kotlin.String?
    
    fun `syncStarted`()
    
    fun `wipe`()
    
    companion object
}

/**
 * Note the canonical docs for this are in https://searchfox.org/mozilla-central/source/services/interfaces/mozIBridgedSyncEngine.idl
 * It's only actually used in desktop, but it's fine to expose this everywhere.
 * NOTE: all timestamps here are milliseconds.
 */
open class TabsBridgedEngine (
): AutoCloseable, Disposable, TabsBridgedEngineInterface
{

    
    @Throws(TabsApiException::class)override fun `apply`(): List<kotlin.String> {
            return  emptyList()
    }

    
    @Throws(TabsApiException::class)override fun `ensureCurrentSyncId`(`newSyncId`: kotlin.String): kotlin.String {
            return  ""
    }

    
    @Throws(TabsApiException::class)override fun `lastSync`(): kotlin.Long {
            return  0L
    }

    
    @Throws(TabsApiException::class)override fun `prepareForSync`(`clientData`: kotlin.String)
        {}

    
    @Throws(TabsApiException::class)override fun `reset`()
        {}

    
    @Throws(TabsApiException::class)override fun `resetSyncId`(): kotlin.String {
            return  ""
    }

    
    @Throws(TabsApiException::class)override fun `setLastSync`(`lastSync`: kotlin.Long)
        {}

    
    @Throws(TabsApiException::class)override fun `setUploaded`(`newTimestamp`: kotlin.Long, `uploadedIds`: List<TabsGuid>)
        {}

    
    @Throws(TabsApiException::class)override fun `storeIncoming`(`incomingEnvelopesAsJson`: List<kotlin.String>)
        {}

    
    @Throws(TabsApiException::class)override fun `syncFinished`()
        {}

    
    @Throws(TabsApiException::class)override fun `syncId`(): kotlin.String? {
            return  null
    }

    
    @Throws(TabsApiException::class)override fun `syncStarted`()
        {}

    
    @Throws(TabsApiException::class)override fun `wipe`()
        {}

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



public interface TabsStoreInterface {
    
    fun `bridgedEngine`(): TabsBridgedEngine
    
    fun `closeConnection`()
    
    fun `getAll`(): List<ClientRemoteTabs>
    
    fun `newRemoteCommandStore`(): RemoteCommandStore
    
    fun `registerWithSyncManager`()
    
    fun `setLocalTabs`(`remoteTabs`: List<RemoteTabRecord>)
    
    companion object
}

open class TabsStore (private val `path`: kotlin.String = ""
): AutoCloseable, Disposable, TabsStoreInterface
{

    override fun `bridgedEngine`(): TabsBridgedEngine {
            return  TabsBridgedEngine()
    }

    override fun `closeConnection`()
        {}

    override fun `getAll`(): List<ClientRemoteTabs> {
            return  emptyList()
    }

    override fun `newRemoteCommandStore`(): RemoteCommandStore {
            return  RemoteCommandStore()
    }

    override fun `registerWithSyncManager`()
        {}

    override fun `setLocalTabs`(`remoteTabs`: List<RemoteTabRecord>)
        {}

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



data class ClientRemoteTabs (
    var `clientId`: kotlin.String = ""
    , 
    var `clientName`: kotlin.String = ""
    , 
    var `deviceType`: DeviceType = DeviceType.__NOOP
    , 
    /**
     * Number of ms since the unix epoch (as reported by the server's clock)
     */
    var `lastModified`: kotlin.Long = 0L
    , 
    var `remoteTabs`: List<RemoteTabRecord> = emptyList()
    
) {
    
    companion object
}



/**
 * Represents a "pending" command.
 */
data class PendingCommand (
    var `deviceId`: kotlin.String = ""
    , 
    var `command`: RemoteCommand = RemoteCommand.__NOOP
    , 
    var `timeRequested`: Timestamp = 0L
    , 
    var `timeSent`: Timestamp? = null
    
) {
    
    companion object
}



data class RemoteTabRecord (
    var `title`: kotlin.String = ""
    , 
    var `urlHistory`: List<kotlin.String> = emptyList()
    , 
    var `icon`: kotlin.String? = null
    , 
    /**
     * Number of ms since the unix epoch (as reported by the client's clock)
     */
    var `lastUsed`: kotlin.Long = 0L
    , 
    var `inactive`: kotlin.Boolean = false
    
) {
    
    companion object
}



/**
 * A command which should be sent to a remote device.
 */
sealed class RemoteCommand {
    
    data class CloseTab(
        val `url`: kotlin.String = "") : RemoteCommand() {
        companion object
    }
    
    object __NOOP : RemoteCommand()

    
    companion object
}







sealed class TabsApiException: kotlin.Exception() {
    
    class SyncException(
        
        val `reason`: kotlin.String = ""
        ) : TabsApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    class SqlException(
        
        val `reason`: kotlin.String = ""
        ) : TabsApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    class UnexpectedTabsException(
        
        val `reason`: kotlin.String = ""
        ) : TabsApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    

    
}

















/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 * It's also what we have an external type that references a custom type.
 */
public typealias TabsGuid = kotlin.String



/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 * It's also what we have an external type that references a custom type.
 */
public typealias Timestamp = kotlin.Long


