// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("UNUSED_PARAMETER")

package mozilla.appservices.push

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }











/**
 * Object representing the PushManager used to manage subscriptions
 *
 * The `PushManager` object is the main interface provided by this crate
 * it allow consumers to manage push subscriptions. It exposes methods that
 * interact with the [`autopush server`](https:///autopush.readthedocs.io/en/latest/)
 * and persists state representing subscriptions.
 */
public interface PushManagerInterface {
    
    /**
     * Decrypts a raw push message.
     *
     * This accepts the content of a Push Message (from websocket or via Native Push systems).
     * # Arguments:
     *   - `payload`: The Push payload as received by the client from Push.
     *
     * # Returns
     * Decrypted message body
     *
     * # Errors
     * Returns an error in the following cases:
     *   - The PushManager does not contain a valid UAID
     *   - There are no records associated with the UAID the [`PushManager`] contains
     *   - An error occurred while decrypting the message
     *   - An error occurred accessing the PushManager's persisted storage
     */
    fun `decrypt`(`payload`: Map<kotlin.String, kotlin.String>): DecryptResponse
    
    /**
     * Retrieves an existing push subscription
     *
     * # Arguments
     *   - `scope` - Site scope string
     *
     * # Returns
     * A Subscription response that includes the following:
     *   - A URL that can be used to deliver push messages
     *   - A cryptographic key that can be used to encrypt messages
     *     that would then be decrypted using the [`PushManager::decrypt`] function
     *
     * # Errors
     * Returns an error in the following cases:
     *   - PushManager was unable to access its persisted storage
     *   - An error occurred generating or deserializing the cryptographic keys
     */
    fun `getSubscription`(`scope`: kotlin.String): SubscriptionResponse?
    
    /**
     * Subscribes to a new channel and gets the Subscription Info block
     *
     * # Arguments
     *   - `scope` - Site scope string
     *   - `server_key` - optional VAPID public key to "lock" subscriptions (defaults to "" for no key)
     *
     * # Returns
     * A Subscription response that includes the following:
     *   - A URL that can be used to deliver push messages
     *   - A cryptographic key that can be used to encrypt messages
     *     that would then be decrypted using the [`PushManager::decrypt`] function
     *
     * # Errors
     * Returns an error in the following cases:
     *   - PushManager was unable to access its persisted storage
     *   - An error occurred sending a subscription request to the autopush server
     *   - An error occurred generating or deserializing the cryptographic keys
     */
    fun `subscribe`(`scope`: kotlin.String, `appServerSey`: kotlin.String? = null): SubscriptionResponse
    
    /**
     * Unsubscribe from given scope, ending that subscription for the user.
     *
     * # Arguments
     *   - `scope` - The scope for the channel to remove
     *
     * # Returns
     * Returns a boolean. Boolean is False if the subscription was already
     * terminated in the past.
     *
     * # Errors
     * Returns an error in the following cases:
     *   - An error occurred sending an unsubscribe request to the autopush server
     *   - An error occurred accessing the PushManager's persisted storage
     */
    fun `unsubscribe`(`scope`: kotlin.String): kotlin.Boolean
    
    /**
     * Unsubscribe all channels for the user
     *
     * # Errors
     * Returns an error in the following cases:
     *   - The PushManager does not contain a valid UAID
     *   - An error occurred sending an unsubscribe request to the autopush server
     *   - An error occurred accessing the PushManager's persisted storage
     */
    fun `unsubscribeAll`()
    
    /**
     * Updates the Native OS push registration ID.
     *
     * # Arguments:
     *   - `new_token` - the new Native OS push registration ID
     *
     * # Errors
     * Return an error in the following cases:
     *   - The PushManager does not contain a valid UAID
     *   - An error occurred sending an update request to the autopush server
     *   - An error occurred accessing the PushManager's persisted storage
     */
    fun `update`(`registrationToken`: kotlin.String)
    
    /**
     * Verifies the connection state
     *
     * **NOTE**: This does not resubscribe to any channels
     * it only returns the list of channels that the client should
     * re-subscribe to.
     *
     * # Returns
     * Returns a list of [`PushSubscriptionChanged`]
     * indicating the channels the consumer the client should re-subscribe
     * to. If the list is empty, the client's connection was verified
     * successfully, and the client does not need to resubscribe
     *
     * # Errors
     * Return an error in the following cases:
     *   - The PushManager does not contain a valid UAID
     *   - An error occurred sending an channel list retrieval request to the autopush server
     *   - An error occurred accessing the PushManager's persisted storage
     */
    fun `verifyConnection`(`forceVerify`: kotlin.Boolean = false): List<PushSubscriptionChanged>
    
    companion object
}

/**
 * Object representing the PushManager used to manage subscriptions
 *
 * The `PushManager` object is the main interface provided by this crate
 * it allow consumers to manage push subscriptions. It exposes methods that
 * interact with the [`autopush server`](https:///autopush.readthedocs.io/en/latest/)
 * and persists state representing subscriptions.
 */
open class PushManager (private val `config`: PushConfiguration = PushConfiguration()
): AutoCloseable, Disposable, PushManagerInterface
{

    
    /**
     * Decrypts a raw push message.
     *
     * This accepts the content of a Push Message (from websocket or via Native Push systems).
     * # Arguments:
     *   - `payload`: The Push payload as received by the client from Push.
     *
     * # Returns
     * Decrypted message body
     *
     * # Errors
     * Returns an error in the following cases:
     *   - The PushManager does not contain a valid UAID
     *   - There are no records associated with the UAID the [`PushManager`] contains
     *   - An error occurred while decrypting the message
     *   - An error occurred accessing the PushManager's persisted storage
     */
    @Throws(PushApiException::class)override fun `decrypt`(`payload`: Map<kotlin.String, kotlin.String>): DecryptResponse {
            return  DecryptResponse()
    }

    
    /**
     * Retrieves an existing push subscription
     *
     * # Arguments
     *   - `scope` - Site scope string
     *
     * # Returns
     * A Subscription response that includes the following:
     *   - A URL that can be used to deliver push messages
     *   - A cryptographic key that can be used to encrypt messages
     *     that would then be decrypted using the [`PushManager::decrypt`] function
     *
     * # Errors
     * Returns an error in the following cases:
     *   - PushManager was unable to access its persisted storage
     *   - An error occurred generating or deserializing the cryptographic keys
     */
    @Throws(PushApiException::class)override fun `getSubscription`(`scope`: kotlin.String): SubscriptionResponse? {
            return  null
    }

    
    /**
     * Subscribes to a new channel and gets the Subscription Info block
     *
     * # Arguments
     *   - `scope` - Site scope string
     *   - `server_key` - optional VAPID public key to "lock" subscriptions (defaults to "" for no key)
     *
     * # Returns
     * A Subscription response that includes the following:
     *   - A URL that can be used to deliver push messages
     *   - A cryptographic key that can be used to encrypt messages
     *     that would then be decrypted using the [`PushManager::decrypt`] function
     *
     * # Errors
     * Returns an error in the following cases:
     *   - PushManager was unable to access its persisted storage
     *   - An error occurred sending a subscription request to the autopush server
     *   - An error occurred generating or deserializing the cryptographic keys
     */
    @Throws(PushApiException::class)override fun `subscribe`(`scope`: kotlin.String, `appServerSey`: kotlin.String?): SubscriptionResponse {
            return  SubscriptionResponse()
    }

    
    /**
     * Unsubscribe from given scope, ending that subscription for the user.
     *
     * # Arguments
     *   - `scope` - The scope for the channel to remove
     *
     * # Returns
     * Returns a boolean. Boolean is False if the subscription was already
     * terminated in the past.
     *
     * # Errors
     * Returns an error in the following cases:
     *   - An error occurred sending an unsubscribe request to the autopush server
     *   - An error occurred accessing the PushManager's persisted storage
     */
    @Throws(PushApiException::class)override fun `unsubscribe`(`scope`: kotlin.String): kotlin.Boolean {
            return  false
    }

    
    /**
     * Unsubscribe all channels for the user
     *
     * # Errors
     * Returns an error in the following cases:
     *   - The PushManager does not contain a valid UAID
     *   - An error occurred sending an unsubscribe request to the autopush server
     *   - An error occurred accessing the PushManager's persisted storage
     */
    @Throws(PushApiException::class)override fun `unsubscribeAll`()
        {}

    
    /**
     * Updates the Native OS push registration ID.
     *
     * # Arguments:
     *   - `new_token` - the new Native OS push registration ID
     *
     * # Errors
     * Return an error in the following cases:
     *   - The PushManager does not contain a valid UAID
     *   - An error occurred sending an update request to the autopush server
     *   - An error occurred accessing the PushManager's persisted storage
     */
    @Throws(PushApiException::class)override fun `update`(`registrationToken`: kotlin.String)
        {}

    
    /**
     * Verifies the connection state
     *
     * **NOTE**: This does not resubscribe to any channels
     * it only returns the list of channels that the client should
     * re-subscribe to.
     *
     * # Returns
     * Returns a list of [`PushSubscriptionChanged`]
     * indicating the channels the consumer the client should re-subscribe
     * to. If the list is empty, the client's connection was verified
     * successfully, and the client does not need to resubscribe
     *
     * # Errors
     * Return an error in the following cases:
     *   - The PushManager does not contain a valid UAID
     *   - An error occurred sending an channel list retrieval request to the autopush server
     *   - An error occurred accessing the PushManager's persisted storage
     */
    @Throws(PushApiException::class)override fun `verifyConnection`(`forceVerify`: kotlin.Boolean): List<PushSubscriptionChanged> {
            return  emptyList()
    }

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



data class DecryptResponse (
    var `result`: List<kotlin.Byte> = emptyList()
    , 
    var `scope`: kotlin.String = ""
    
) {
    
    companion object
}



/**
 * Key Information that can be used to encrypt payloads
 */
data class KeyInfo (
    var `auth`: kotlin.String = ""
    , 
    var `p256dh`: kotlin.String = ""
    
) {
    
    companion object
}



data class PushConfiguration (
    var `serverHost`: kotlin.String = ""
    , 
    var `httpProtocol`: PushHttpProtocol = PushHttpProtocol.__NOOP
    , 
    var `bridgeType`: BridgeType = BridgeType.__NOOP
    , 
    var `senderId`: kotlin.String = ""
    , 
    var `databasePath`: kotlin.String = ""
    , 
    var `verifyConnectionRateLimiter`: kotlin.ULong? = null
    
) {
    
    companion object
}



/**
 * An dictionary describing the push subscription that changed, the caller
 * will receive a list of [`PushSubscriptionChanged`] when calling
 * [`PushManager::verify_connection`], one entry for each channel that the
 * caller should resubscribe to
 */
data class PushSubscriptionChanged (
    var `channelId`: kotlin.String = ""
    , 
    var `scope`: kotlin.String = ""
    
) {
    
    companion object
}



/**
 * Subscription Information, the endpoint to send push messages to and
 * the key information that can be used to encrypt payloads
 */
data class SubscriptionInfo (
    var `endpoint`: kotlin.String = ""
    , 
    var `keys`: KeyInfo = KeyInfo()
    
) {
    
    companion object
}



/**
 * The subscription response object returned from [`PushManager::subscribe`]
 */
data class SubscriptionResponse (
    var `channelId`: kotlin.String = ""
    , 
    var `subscriptionInfo`: SubscriptionInfo = SubscriptionInfo()
    
) {
    
    companion object
}



/**
 * The types of supported native bridges.
 *
 * FCM = Google Android Firebase Cloud Messaging
 * ADM = Amazon Device Messaging for FireTV
 * APNS = Apple Push Notification System for iOS
 *
 * Please contact services back-end for any additional bridge protocols.

 */

enum class BridgeType {
    
    FCM,
    ADM,
    APNS,
    __NOOP;
    companion object
}








/**
 * The main Error returned from the Push component, each
 * variant describes a different error
 */
sealed class PushApiException(message: String = ""): kotlin.Exception(message) {
        
        class UaidNotRecognizedException(message: String = "") : PushApiException(message)
        
        class RecordNotFoundException(message: String = "") : PushApiException(message)
        
        class InternalException(message: String = "") : PushApiException(message)
        
}



/**
 * Supported protocols for push
 * "Https" is default, and "Http" is only
 *  supported  for tests
 */

enum class PushHttpProtocol {
    
    HTTPS,
    HTTP,
    __NOOP;
    companion object
}
















