// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("UNUSED_PARAMETER")

package org.mozilla.experiments.nimbus.internal
import mozilla.appservices.remotesettings.RemoteSettingsConfig
import org.json.JSONObject

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }













public interface NimbusClientInterface {
    
    /**
     * Advances what the event store thinks is now.
     * This, and `record_past_event` are useful for testing.
     * `by_seconds` must be positive.
     */
    fun `advanceEventTime`(`bySeconds`: kotlin.Long)
    
    /**
     * Apply the updated experiments from the last fetch.
     * After calling this, the list of active experiments might change
     * (there might be new experiments, or old experiments might have expired).
     */
    fun `applyPendingExperiments`(): List<EnrollmentChangeEvent>
    
    fun `clearEvents`()
    
    /**
     * This provides a unified String interpolation library which exposes the application context.
     * It's first use is in the messaging helper, to add extra parameters to URLs.
     */
    fun `createStringHelper`(`additionalContext`: JsonObject? = null): NimbusStringHelper
    
    /**
     * This provides low level access to the targeting machinery for other uses by the application (e.g. messages)
     * Additional parameters can be added via the optional JSON object. This allows for many JEXL expressions
     * to be run across the same context.
     */
    fun `createTargetingHelper`(`additionalContext`: JsonObject? = null): NimbusTargetingHelper
    
    fun `dumpStateToLog`()
    
    /**
     * Fetches the list of experiments from the server. This does not affect the list
     * of active experiments or experiment enrolment.
     * Fetched experiments are not applied until `apply_pending_updates()` is called.
     */
    fun `fetchExperiments`()
    
    /**
     * Returns a list of experiments this user is enrolled in.
     */
    fun `getActiveExperiments`(): List<EnrolledExperiment>
    
    /**
     * Returns a list of experiments for this `app_name`, as specified in the `AppContext`.
     * It is not intended to be used to be used for user facing applications.
     */
    fun `getAvailableExperiments`(): List<AvailableExperiment>
    
    /**
     * Returns the branch allocated for a given slug or id.
     */
    fun `getExperimentBranch`(`id`: kotlin.String): kotlin.String?
    
    /**
     * Returns a list of experiment branches for a given experiment ID.
     */
    fun `getExperimentBranches`(`experimentSlug`: kotlin.String): List<ExperimentBranch>
    
    fun `getFeatureConfigVariables`(`featureId`: kotlin.String): kotlin.String?
    
    /**
     * Getter and setter for user's participation in all experiments.
     * Possible values are:
     * * `true`: the user will not enroll in new experiments, and opt out of all existing ones.
     * * `false`: experiments proceed as usual.
     */
    fun `getGlobalUserParticipation`(): kotlin.Boolean
    
    /**
     * Initializes the database and caches enough information so that the
     * non-blocking API functions (eg, `get_experiment_branch()`) can
     * return accurate results rather than throwing a "not initialized" error.
     * It's not strictly necessary to call this function - any function that
     * wants to use the database will implicitly initialize too - this exists
     * so that the consuming application can have confidence the non-blocking
     * functions will return data instead of returning an error, and will do
     * the minimum amount of work to achieve that.
     */
    fun `initialize`()
    
    fun `isFetchEnabled`(): kotlin.Boolean
    
    /**
     * Opt in to a specific branch on a specific experiment. Useful for
     * developers to test their app's interaction with the experiment.
     */
    fun `optInWithBranch`(`experimentSlug`: kotlin.String, `branch`: kotlin.String): List<EnrollmentChangeEvent>
    
    /**
     * Opt out of a specific experiment.
     */
    fun `optOut`(`experimentSlug`: kotlin.String): List<EnrollmentChangeEvent>
    
    /**
     * Records an event for the purposes of behavioral targeting.
     * This function is used to record and persist data used for the behavioral
     * targeting such as "core-active" user targeting.
     */
    fun `recordEvent`(`eventId`: kotlin.String, `count`: kotlin.Long = 1L)
    
    /**
     * Records a Glean event that this feature has been exposed.
     * If the feature is not involved in an experiment, then the event is suppressed.
     * If the feature is only involved in a rollout, then the event is suppressed.
     * If the feature is involved in an experiment, then record the experiment slug
     * and branch.
     * If the feature is involved in an experiment and a rollout, then record only the
     * experiment slug and branch.
     * If the slug is specified, then use this as the experiment, and use it to look up
     * the branch. This is useful for coenrolling features.
     */
    fun `recordFeatureExposure`(`featureId`: kotlin.String, `slug`: kotlin.String?)
    
    /**
     * Records a Glean event that this feature configuration is malformed.
     * Accepts a part_id to give the experiment owner or feature implementer
     * clues where to look.
     * The Glean event will always fire, but the content of that event will
     * vary depending on whether then feature is part of an experiment or rollout
     * or not.
     */
    fun `recordMalformedFeatureConfig`(`featureId`: kotlin.String, `partId`: kotlin.String)
    
    /**
     * Records an event as if it were in the past.
     * This, and `advance_event_time` are useful for testing.
     * `seconds_ago` must be positive.
     */
    fun `recordPastEvent`(`eventId`: kotlin.String, `secondsAgo`: kotlin.Long, `count`: kotlin.Long = 1L)
    
    /**
     * These are test-only functions and should never be exposed to production
     * users, as they mess with the "statistical requirements" of the SDK.
     * Reset the enrollments and experiments in the database to an empty state.
     */
    fun `resetEnrollments`()
    
    /**
     * Reset internal state in response to application-level telemetry reset.
     *
     * Consumers should call this method when the user resets the telemetry state of the
     * consuming application, such as by opting out of submitting telemetry. It resets the
     * internal state of the Nimbus client to create a clean break between data collected
     * before and after the reset, including:
     *
     *    * clearing any unique identifiers used internally, so they will reset to
     *      new random values on next use.
     *    * accepting new randomization units, based on application-level ids that
     *      may have also changed.
     *    * disqualifying this client out of any active experiments, to avoid submitting
     *      misleading incomplete data.

     */
    fun `resetTelemetryIdentifiers`(): List<EnrollmentChangeEvent>
    
    /**
     * A convenience method for apps to set the experiments from a local source
     * for either testing, or before the first fetch has finished.
     *
     * Experiments set with this method are not applied until `apply_pending_updates()` is called.
     */
    fun `setExperimentsLocally`(`experimentsJson`: kotlin.String)
    
    /**
     * Toggles the enablement of the fetch. If `false`, then calling `fetch_experiments`
     * returns immediately, having not done any fetching from remote settings.
     * This is only useful for QA, and should not be used in production: use
     * `set_global_user_participation` instead.
     */
    fun `setFetchEnabled`(`flag`: kotlin.Boolean)
    
    fun `setGlobalUserParticipation`(`optIn`: kotlin.Boolean): List<EnrollmentChangeEvent>
    
    companion object
}

open class NimbusClient (private val `appCtx`: AppContext = AppContext(), private val `recordedContext`: RecordedContext? = null, private val `coenrollingFeatureIds`: List<kotlin.String> = emptyList(), private val `dbpath`: kotlin.String = "", private val `remoteSettingsConfig`: RemoteSettingsConfig? = null, private val `metricsHandler`: MetricsHandler = MetricsHandlerImpl()
): AutoCloseable, Disposable, NimbusClientInterface
{

    
    /**
     * Advances what the event store thinks is now.
     * This, and `record_past_event` are useful for testing.
     * `by_seconds` must be positive.
     */
    @Throws(NimbusException::class)override fun `advanceEventTime`(`bySeconds`: kotlin.Long)
        {}

    
    /**
     * Apply the updated experiments from the last fetch.
     * After calling this, the list of active experiments might change
     * (there might be new experiments, or old experiments might have expired).
     */
    @Throws(NimbusException::class)override fun `applyPendingExperiments`(): List<EnrollmentChangeEvent> {
            return  emptyList()
    }

    
    @Throws(NimbusException::class)override fun `clearEvents`()
        {}

    
    /**
     * This provides a unified String interpolation library which exposes the application context.
     * It's first use is in the messaging helper, to add extra parameters to URLs.
     */
    @Throws(NimbusException::class)override fun `createStringHelper`(`additionalContext`: JsonObject?): NimbusStringHelper {
            return  NimbusStringHelper()
    }

    
    /**
     * This provides low level access to the targeting machinery for other uses by the application (e.g. messages)
     * Additional parameters can be added via the optional JSON object. This allows for many JEXL expressions
     * to be run across the same context.
     */
    @Throws(NimbusException::class)override fun `createTargetingHelper`(`additionalContext`: JsonObject?): NimbusTargetingHelper {
            return  NimbusTargetingHelper()
    }

    
    @Throws(NimbusException::class)override fun `dumpStateToLog`()
        {}

    
    /**
     * Fetches the list of experiments from the server. This does not affect the list
     * of active experiments or experiment enrolment.
     * Fetched experiments are not applied until `apply_pending_updates()` is called.
     */
    @Throws(NimbusException::class)override fun `fetchExperiments`()
        {}

    
    /**
     * Returns a list of experiments this user is enrolled in.
     */
    @Throws(NimbusException::class)override fun `getActiveExperiments`(): List<EnrolledExperiment> {
            return  emptyList()
    }

    
    /**
     * Returns a list of experiments for this `app_name`, as specified in the `AppContext`.
     * It is not intended to be used to be used for user facing applications.
     */
    @Throws(NimbusException::class)override fun `getAvailableExperiments`(): List<AvailableExperiment> {
            return  emptyList()
    }

    
    /**
     * Returns the branch allocated for a given slug or id.
     */
    @Throws(NimbusException::class)override fun `getExperimentBranch`(`id`: kotlin.String): kotlin.String? {
            return  null
    }

    
    /**
     * Returns a list of experiment branches for a given experiment ID.
     */
    @Throws(NimbusException::class)override fun `getExperimentBranches`(`experimentSlug`: kotlin.String): List<ExperimentBranch> {
            return  emptyList()
    }

    
    @Throws(NimbusException::class)override fun `getFeatureConfigVariables`(`featureId`: kotlin.String): kotlin.String? {
            return  null
    }

    
    /**
     * Getter and setter for user's participation in all experiments.
     * Possible values are:
     * * `true`: the user will not enroll in new experiments, and opt out of all existing ones.
     * * `false`: experiments proceed as usual.
     */
    @Throws(NimbusException::class)override fun `getGlobalUserParticipation`(): kotlin.Boolean {
            return  false
    }

    
    /**
     * Initializes the database and caches enough information so that the
     * non-blocking API functions (eg, `get_experiment_branch()`) can
     * return accurate results rather than throwing a "not initialized" error.
     * It's not strictly necessary to call this function - any function that
     * wants to use the database will implicitly initialize too - this exists
     * so that the consuming application can have confidence the non-blocking
     * functions will return data instead of returning an error, and will do
     * the minimum amount of work to achieve that.
     */
    @Throws(NimbusException::class)override fun `initialize`()
        {}

    
    @Throws(NimbusException::class)override fun `isFetchEnabled`(): kotlin.Boolean {
            return  false
    }

    
    /**
     * Opt in to a specific branch on a specific experiment. Useful for
     * developers to test their app's interaction with the experiment.
     */
    @Throws(NimbusException::class)override fun `optInWithBranch`(`experimentSlug`: kotlin.String, `branch`: kotlin.String): List<EnrollmentChangeEvent> {
            return  emptyList()
    }

    
    /**
     * Opt out of a specific experiment.
     */
    @Throws(NimbusException::class)override fun `optOut`(`experimentSlug`: kotlin.String): List<EnrollmentChangeEvent> {
            return  emptyList()
    }

    
    /**
     * Records an event for the purposes of behavioral targeting.
     * This function is used to record and persist data used for the behavioral
     * targeting such as "core-active" user targeting.
     */
    @Throws(NimbusException::class)override fun `recordEvent`(`eventId`: kotlin.String, `count`: kotlin.Long)
        {}

    
    /**
     * Records a Glean event that this feature has been exposed.
     * If the feature is not involved in an experiment, then the event is suppressed.
     * If the feature is only involved in a rollout, then the event is suppressed.
     * If the feature is involved in an experiment, then record the experiment slug
     * and branch.
     * If the feature is involved in an experiment and a rollout, then record only the
     * experiment slug and branch.
     * If the slug is specified, then use this as the experiment, and use it to look up
     * the branch. This is useful for coenrolling features.
     */override fun `recordFeatureExposure`(`featureId`: kotlin.String, `slug`: kotlin.String?)
        {}

    
    /**
     * Records a Glean event that this feature configuration is malformed.
     * Accepts a part_id to give the experiment owner or feature implementer
     * clues where to look.
     * The Glean event will always fire, but the content of that event will
     * vary depending on whether then feature is part of an experiment or rollout
     * or not.
     */override fun `recordMalformedFeatureConfig`(`featureId`: kotlin.String, `partId`: kotlin.String)
        {}

    
    /**
     * Records an event as if it were in the past.
     * This, and `advance_event_time` are useful for testing.
     * `seconds_ago` must be positive.
     */
    @Throws(NimbusException::class)override fun `recordPastEvent`(`eventId`: kotlin.String, `secondsAgo`: kotlin.Long, `count`: kotlin.Long)
        {}

    
    /**
     * These are test-only functions and should never be exposed to production
     * users, as they mess with the "statistical requirements" of the SDK.
     * Reset the enrollments and experiments in the database to an empty state.
     */
    @Throws(NimbusException::class)override fun `resetEnrollments`()
        {}

    
    /**
     * Reset internal state in response to application-level telemetry reset.
     *
     * Consumers should call this method when the user resets the telemetry state of the
     * consuming application, such as by opting out of submitting telemetry. It resets the
     * internal state of the Nimbus client to create a clean break between data collected
     * before and after the reset, including:
     *
     *    * clearing any unique identifiers used internally, so they will reset to
     *      new random values on next use.
     *    * accepting new randomization units, based on application-level ids that
     *      may have also changed.
     *    * disqualifying this client out of any active experiments, to avoid submitting
     *      misleading incomplete data.

     */
    @Throws(NimbusException::class)override fun `resetTelemetryIdentifiers`(): List<EnrollmentChangeEvent> {
            return  emptyList()
    }

    
    /**
     * A convenience method for apps to set the experiments from a local source
     * for either testing, or before the first fetch has finished.
     *
     * Experiments set with this method are not applied until `apply_pending_updates()` is called.
     */
    @Throws(NimbusException::class)override fun `setExperimentsLocally`(`experimentsJson`: kotlin.String)
        {}

    
    /**
     * Toggles the enablement of the fetch. If `false`, then calling `fetch_experiments`
     * returns immediately, having not done any fetching from remote settings.
     * This is only useful for QA, and should not be used in production: use
     * `set_global_user_participation` instead.
     */
    @Throws(NimbusException::class)override fun `setFetchEnabled`(`flag`: kotlin.Boolean)
        {}

    
    @Throws(NimbusException::class)override fun `setGlobalUserParticipation`(`optIn`: kotlin.Boolean): List<EnrollmentChangeEvent> {
            return  emptyList()
    }

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



public interface NimbusStringHelperInterface {
    
    /**
     * Generates an optional UUID to be passed into the `string_format` method.
     * If the return is not null, then it should be recorded with Glean as a UuidMetricType.
     */
    fun `getUuid`(`template`: kotlin.String): kotlin.String?
    
    /**
     * Take the given template and find patterns that match the regular expression `{\w+}`.
     * Any matches are used as keys into the application context, the `additional_context` or the special case `uuid`.
     */
    fun `stringFormat`(`template`: kotlin.String, `uuid`: kotlin.String? = null): kotlin.String
    
    companion object
}

open class NimbusStringHelper (
): AutoCloseable, Disposable, NimbusStringHelperInterface
{

    
    /**
     * Generates an optional UUID to be passed into the `string_format` method.
     * If the return is not null, then it should be recorded with Glean as a UuidMetricType.
     */override fun `getUuid`(`template`: kotlin.String): kotlin.String? {
            return  null
    }

    
    /**
     * Take the given template and find patterns that match the regular expression `{\w+}`.
     * Any matches are used as keys into the application context, the `additional_context` or the special case `uuid`.
     */override fun `stringFormat`(`template`: kotlin.String, `uuid`: kotlin.String?): kotlin.String {
            return  ""
    }

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



public interface NimbusTargetingHelperInterface {
    
    /**
     * Execute the given jexl expression and evaluate against the existing targeting parameters and context passed to
     * the helper at construction.
     */
    fun `evalJexl`(`expression`: kotlin.String): kotlin.Boolean
    
    companion object
}

open class NimbusTargetingHelper (
): AutoCloseable, Disposable, NimbusTargetingHelperInterface
{

    
    /**
     * Execute the given jexl expression and evaluate against the existing targeting parameters and context passed to
     * the helper at construction.
     */
    @Throws(NimbusException::class)override fun `evalJexl`(`expression`: kotlin.String): kotlin.Boolean {
            return  false
    }

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



public interface RecordedContext {
    
    fun `getEventQueries`(): Map<kotlin.String, kotlin.String>
    
    fun `record`()
    
    fun `setEventQueryValues`(`eventQueryValues`: Map<kotlin.String, kotlin.Double>)
    
    fun `toJson`(): JsonObject
    
    companion object
}

open class RecordedContextImpl (
): AutoCloseable, Disposable, RecordedContext
{

    override fun `getEventQueries`(): Map<kotlin.String, kotlin.String> {
            return  emptyMap()
    }

    override fun `record`()
        {}

    override fun `setEventQueryValues`(`eventQueryValues`: Map<kotlin.String, kotlin.Double>)
        {}

    override fun `toJson`(): JsonObject {
            return  JSONObject("")
    }

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



data class AppContext (
    var `appName`: kotlin.String = ""
    , 
    var `appId`: kotlin.String = ""
    , 
    var `channel`: kotlin.String = ""
    , 
    var `appVersion`: kotlin.String? = null
    , 
    var `appBuild`: kotlin.String? = null
    , 
    var `architecture`: kotlin.String? = null
    , 
    var `deviceManufacturer`: kotlin.String? = null
    , 
    var `deviceModel`: kotlin.String? = null
    , 
    var `locale`: kotlin.String? = null
    , 
    var `os`: kotlin.String? = null
    , 
    var `osVersion`: kotlin.String? = null
    , 
    var `androidSdkVersion`: kotlin.String? = null
    , 
    var `debugTag`: kotlin.String? = null
    , 
    var `installationDate`: kotlin.Long? = null
    , 
    var `homeDirectory`: kotlin.String? = null
    , 
    var `customTargetingAttributes`: JsonObject? = null
    
) {
    
    companion object
}



data class AvailableExperiment (
    var `slug`: kotlin.String = ""
    , 
    var `userFacingName`: kotlin.String = ""
    , 
    var `userFacingDescription`: kotlin.String = ""
    , 
    var `branches`: List<ExperimentBranch> = emptyList()
    , 
    var `referenceBranch`: kotlin.String? = null
    
) {
    
    companion object
}



data class CalculatedAttributes (
    var `daysSinceInstall`: kotlin.Int? = null
    , 
    var `daysSinceUpdate`: kotlin.Int? = null
    , 
    var `language`: kotlin.String? = null
    , 
    var `region`: kotlin.String? = null
    
) {
    
    companion object
}



data class EnrolledExperiment (
    var `featureIds`: List<kotlin.String> = emptyList()
    , 
    var `slug`: kotlin.String = ""
    , 
    var `userFacingName`: kotlin.String = ""
    , 
    var `userFacingDescription`: kotlin.String = ""
    , 
    var `branchSlug`: kotlin.String = ""
    
) {
    
    companion object
}



data class EnrollmentChangeEvent (
    var `experimentSlug`: kotlin.String = ""
    , 
    var `branchSlug`: kotlin.String = ""
    , 
    var `reason`: kotlin.String? = null
    , 
    var `change`: EnrollmentChangeEventType = EnrollmentChangeEventType.__NOOP
    
) {
    
    companion object
}



data class EnrollmentStatusExtraDef (
    var `branch`: kotlin.String? = null
    , 
    var `conflictSlug`: kotlin.String? = null
    , 
    var `errorString`: kotlin.String? = null
    , 
    var `reason`: kotlin.String? = null
    , 
    var `slug`: kotlin.String? = null
    , 
    var `status`: kotlin.String? = null
    
) {
    
    companion object
}



data class ExperimentBranch (
    var `slug`: kotlin.String = ""
    , 
    var `ratio`: kotlin.Int = 0
    
) {
    
    companion object
}



data class FeatureExposureExtraDef (
    var `branch`: kotlin.String? = null
    , 
    var `slug`: kotlin.String = ""
    , 
    var `featureId`: kotlin.String = ""
    
) {
    
    companion object
}



data class MalformedFeatureConfigExtraDef (
    var `branch`: kotlin.String? = null
    , 
    var `slug`: kotlin.String? = null
    , 
    var `featureId`: kotlin.String = ""
    , 
    var `part`: kotlin.String = ""
    
) {
    
    companion object
}




enum class EnrollmentChangeEventType {
    
    ENROLLMENT,
    ENROLL_FAILED,
    DISQUALIFICATION,
    UNENROLLMENT,
    UNENROLL_FAILED,
    __NOOP;
    companion object
}








sealed class NimbusException(message: String = ""): kotlin.Exception(message) {
        
        class InvalidPersistedData(message: String = "") : NimbusException(message)
        
        class RkvException(message: String = "") : NimbusException(message)
        
        class IoException(message: String = "") : NimbusException(message)
        
        class JsonException(message: String = "") : NimbusException(message)
        
        class EvaluationException(message: String = "") : NimbusException(message)
        
        class InvalidExpression(message: String = "") : NimbusException(message)
        
        class InvalidFraction(message: String = "") : NimbusException(message)
        
        class TryFromSliceException(message: String = "") : NimbusException(message)
        
        class EmptyRatiosException(message: String = "") : NimbusException(message)
        
        class OutOfBoundsException(message: String = "") : NimbusException(message)
        
        class UrlParsingException(message: String = "") : NimbusException(message)
        
        class UuidException(message: String = "") : NimbusException(message)
        
        class InvalidExperimentFormat(message: String = "") : NimbusException(message)
        
        class InvalidPath(message: String = "") : NimbusException(message)
        
        class InternalException(message: String = "") : NimbusException(message)
        
        class NoSuchExperiment(message: String = "") : NimbusException(message)
        
        class NoSuchBranch(message: String = "") : NimbusException(message)
        
        class DatabaseNotReady(message: String = "") : NimbusException(message)
        
        class VersionParsingException(message: String = "") : NimbusException(message)
        
        class BehaviorException(message: String = "") : NimbusException(message)
        
        class TryFromIntException(message: String = "") : NimbusException(message)
        
        class ParseIntException(message: String = "") : NimbusException(message)
        
        class TransformParameterException(message: String = "") : NimbusException(message)
        
        class ClientException(message: String = "") : NimbusException(message)
        
        class UniFfiCallbackException(message: String = "") : NimbusException(message)
        
        class RegexException(message: String = "") : NimbusException(message)
        
}





public interface MetricsHandler {
    
    fun `recordEnrollmentStatuses`(`enrollmentStatusExtras`: List<EnrollmentStatusExtraDef>)
    
    /**
     * Feature activation is the pre-cursor to feature exposure: it is defined as the first time
     * the feature configuration is asked for.
     */
    fun `recordFeatureActivation`(`event`: FeatureExposureExtraDef)
    
    fun `recordFeatureExposure`(`event`: FeatureExposureExtraDef)
    
    fun `recordMalformedFeatureConfig`(`event`: MalformedFeatureConfigExtraDef)
    
    companion object
}


/**
 * The ffiConverter which transforms the Callbacks in to handles to pass to Rust.
 *
 * @suppress
 */
open class MetricsHandlerImpl(): MetricsHandler {
    override fun `recordEnrollmentStatuses`(`enrollmentStatusExtras`: List<EnrollmentStatusExtraDef>)
        {}

    
    /**
     * Feature activation is the pre-cursor to feature exposure: it is defined as the first time
     * the feature configuration is asked for.
     */override fun `recordFeatureActivation`(`event`: FeatureExposureExtraDef)
        {}

    override fun `recordFeatureExposure`(`event`: FeatureExposureExtraDef)
        {}

    override fun `recordMalformedFeatureConfig`(`event`: MalformedFeatureConfigExtraDef)
        {}

    

    companion object
}

































/**
 * Typealias from the type name used in the UDL file to the custom type.  This
 * is needed because the UDL type name is used in function/method signatures.
 * It's also what we have an external type that references a custom type.
 */
public typealias JsonObject = JSONObject


        /**

         */
    @Throws(NimbusException::class) fun `getCalculatedAttributes`(`installationDate`: kotlin.Long?, `dbPath`: kotlin.String, `locale`: kotlin.String): CalculatedAttributes {
            return  CalculatedAttributes()
    }

        /**
         * A test utility used to validate event queries against the jexl evaluator.
         *
         * This method should only be used in tests.
         */
    @Throws(NimbusException::class) fun `validateEventQueries`(`recordedContext`: RecordedContext)
        {}


