// -*- mode: kotlin -*-

/*
 * AUTOGENERATED BY glean_parser v17.1.0. DO NOT EDIT. DO NOT COMMIT.
 */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
/* ktlint-disable no-blank-line-before-rbrace */
@file:Suppress("PackageNaming", "MaxLineLength")
package org.mozilla.experiments.nimbus.GleanMetrics

import mozilla.telemetry.glean.private.CommonMetricData // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.EventExtras // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.HistogramType // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.Lifetime // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.MemoryUnit // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.NoExtras // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.NoReasonCodes // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.ObjectSerialize // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.ReasonCode // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.TimeUnit // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.EventMetricType // ktlint-disable import-ordering

internal object NimbusEvents {
    @Suppress("ClassNaming", "EnumNaming")
    data class ActivationExtra(
        val branch: String? = null,
        val experiment: String? = null,
        val featureId: String? = null
    ) : EventExtras {
        override fun toExtraRecord(): Map<String, String> {
            val map = mutableMapOf<String, String>()

            this.branch?.let {
                map.put("branch", it.toString())
            }
            this.experiment?.let {
                map.put("experiment", it.toString())
            }
            this.featureId?.let {
                map.put("feature_id", it.toString())
            }
            return map
        }
    }
    @Suppress("ClassNaming", "EnumNaming")
    data class DisqualificationExtra(
        val branch: String? = null,
        val experiment: String? = null
    ) : EventExtras {
        override fun toExtraRecord(): Map<String, String> {
            val map = mutableMapOf<String, String>()

            this.branch?.let {
                map.put("branch", it.toString())
            }
            this.experiment?.let {
                map.put("experiment", it.toString())
            }
            return map
        }
    }
    @Suppress("ClassNaming", "EnumNaming")
    data class EnrollFailedExtra(
        val branch: String? = null,
        val experiment: String? = null,
        val reason: String? = null
    ) : EventExtras {
        override fun toExtraRecord(): Map<String, String> {
            val map = mutableMapOf<String, String>()

            this.branch?.let {
                map.put("branch", it.toString())
            }
            this.experiment?.let {
                map.put("experiment", it.toString())
            }
            this.reason?.let {
                map.put("reason", it.toString())
            }
            return map
        }
    }
    @Suppress("ClassNaming", "EnumNaming")
    data class EnrollmentExtra(
        val branch: String? = null,
        val experiment: String? = null,
        val experimentType: String? = null
    ) : EventExtras {
        override fun toExtraRecord(): Map<String, String> {
            val map = mutableMapOf<String, String>()

            this.branch?.let {
                map.put("branch", it.toString())
            }
            this.experiment?.let {
                map.put("experiment", it.toString())
            }
            this.experimentType?.let {
                map.put("experiment_type", it.toString())
            }
            return map
        }
    }
    @Suppress("ClassNaming", "EnumNaming")
    data class EnrollmentStatusExtra(
        val branch: String? = null,
        val conflictSlug: String? = null,
        val errorString: String? = null,
        val reason: String? = null,
        val slug: String? = null,
        val status: String? = null
    ) : EventExtras {
        override fun toExtraRecord(): Map<String, String> {
            val map = mutableMapOf<String, String>()

            this.branch?.let {
                map.put("branch", it.toString())
            }
            this.conflictSlug?.let {
                map.put("conflict_slug", it.toString())
            }
            this.errorString?.let {
                map.put("error_string", it.toString())
            }
            this.reason?.let {
                map.put("reason", it.toString())
            }
            this.slug?.let {
                map.put("slug", it.toString())
            }
            this.status?.let {
                map.put("status", it.toString())
            }
            return map
        }
    }
    @Suppress("ClassNaming", "EnumNaming")
    data class ExposureExtra(
        val branch: String? = null,
        val experiment: String? = null,
        val featureId: String? = null
    ) : EventExtras {
        override fun toExtraRecord(): Map<String, String> {
            val map = mutableMapOf<String, String>()

            this.branch?.let {
                map.put("branch", it.toString())
            }
            this.experiment?.let {
                map.put("experiment", it.toString())
            }
            this.featureId?.let {
                map.put("feature_id", it.toString())
            }
            return map
        }
    }
    @Suppress("ClassNaming", "EnumNaming")
    data class MalformedFeatureExtra(
        val branch: String? = null,
        val experiment: String? = null,
        val featureId: String? = null,
        val partId: String? = null
    ) : EventExtras {
        override fun toExtraRecord(): Map<String, String> {
            val map = mutableMapOf<String, String>()

            this.branch?.let {
                map.put("branch", it.toString())
            }
            this.experiment?.let {
                map.put("experiment", it.toString())
            }
            this.featureId?.let {
                map.put("feature_id", it.toString())
            }
            this.partId?.let {
                map.put("part_id", it.toString())
            }
            return map
        }
    }
    @Suppress("ClassNaming", "EnumNaming")
    data class UnenrollFailedExtra(
        val experiment: String? = null,
        val reason: String? = null
    ) : EventExtras {
        override fun toExtraRecord(): Map<String, String> {
            val map = mutableMapOf<String, String>()

            this.experiment?.let {
                map.put("experiment", it.toString())
            }
            this.reason?.let {
                map.put("reason", it.toString())
            }
            return map
        }
    }
    @Suppress("ClassNaming", "EnumNaming")
    data class UnenrollmentExtra(
        val branch: String? = null,
        val experiment: String? = null,
        val reason: String? = null
    ) : EventExtras {
        override fun toExtraRecord(): Map<String, String> {
            val map = mutableMapOf<String, String>()

            this.branch?.let {
                map.put("branch", it.toString())
            }
            this.experiment?.let {
                map.put("experiment", it.toString())
            }
            this.reason?.let {
                map.put("reason", it.toString())
            }
            return map
        }
    }
    /**
     * Recorded when a feature is configured with an experimental configuration for
     * the first time in this session.
     */
    @get:JvmName("activation")
    val activation: EventMetricType<ActivationExtra> by lazy { // generated from nimbus_events.activation
        EventMetricType<ActivationExtra>(
            CommonMetricData(
                category = "nimbus_events",
                name = "activation",
                sendInPings = listOf("events"),
                lifetime = Lifetime.PING,
                disabled = true
            ), allowedExtraKeys = listOf("branch", "experiment", "feature_id"))
    }
    /**
     * Recorded when a user becomes ineligible to continue receiving the treatment for
     * an enrolled experiment, for reasons such as the user opting out of the
     * experiment or no longer matching targeting for the experiment.
     */
    @get:JvmName("disqualification")
    val disqualification: EventMetricType<DisqualificationExtra> by lazy { // generated from nimbus_events.disqualification
        EventMetricType<DisqualificationExtra>(
            CommonMetricData(
                category = "nimbus_events",
                name = "disqualification",
                sendInPings = listOf("events"),
                lifetime = Lifetime.PING,
                disabled = false
            ), allowedExtraKeys = listOf("branch", "experiment"))
    }
    /**
     * Recorded when an enrollment fails, including the reason for the failure.
     */
    @get:JvmName("enrollFailed")
    val enrollFailed: EventMetricType<EnrollFailedExtra> by lazy { // generated from nimbus_events.enroll_failed
        EventMetricType<EnrollFailedExtra>(
            CommonMetricData(
                category = "nimbus_events",
                name = "enroll_failed",
                sendInPings = listOf("background-update", "events"),
                lifetime = Lifetime.PING,
                disabled = false
            ), allowedExtraKeys = listOf("branch", "experiment", "reason"))
    }
    /**
     * Recorded when a user has met the conditions and is first bucketed into an
     * experiment (i.e. targeting matched and they were randomized into a bucket and
     * branch of the experiment). Expected a maximum of once per experiment per user.
     */
    @get:JvmName("enrollment")
    val enrollment: EventMetricType<EnrollmentExtra> by lazy { // generated from nimbus_events.enrollment
        EventMetricType<EnrollmentExtra>(
            CommonMetricData(
                category = "nimbus_events",
                name = "enrollment",
                sendInPings = listOf("events"),
                lifetime = Lifetime.PING,
                disabled = false
            ), allowedExtraKeys = listOf("branch", "experiment", "experiment_type"))
    }
    /**
     * Recorded for each enrollment status each time the SDK completes application of
     * pending experiments.
     */
    @get:JvmName("enrollmentStatus")
    val enrollmentStatus: EventMetricType<EnrollmentStatusExtra> by lazy { // generated from nimbus_events.enrollment_status
        EventMetricType<EnrollmentStatusExtra>(
            CommonMetricData(
                category = "nimbus_events",
                name = "enrollment_status",
                sendInPings = listOf("events"),
                lifetime = Lifetime.PING,
                disabled = false
            ), allowedExtraKeys = listOf("branch", "conflict_slug", "error_string", "reason", "slug", "status"))
    }
    /**
     * Recorded when a user actually observes an experimental treatment, or would have
     * observed an experimental treatment if they had been in a branch that would have
     * shown one.
     */
    @get:JvmName("exposure")
    val exposure: EventMetricType<ExposureExtra> by lazy { // generated from nimbus_events.exposure
        EventMetricType<ExposureExtra>(
            CommonMetricData(
                category = "nimbus_events",
                name = "exposure",
                sendInPings = listOf("events"),
                lifetime = Lifetime.PING,
                disabled = false
            ), allowedExtraKeys = listOf("branch", "experiment", "feature_id"))
    }
    /**
     * An event sent when Nimbus finishes launching.
     */
    @get:JvmName("isReady")
    val isReady: EventMetricType<NoExtras> by lazy { // generated from nimbus_events.is_ready
        EventMetricType<NoExtras>(
            CommonMetricData(
                category = "nimbus_events",
                name = "is_ready",
                sendInPings = listOf("events"),
                lifetime = Lifetime.PING,
                disabled = false
            ), allowedExtraKeys = listOf())
    }
    /**
     * Recorded when feature code detects a problem with some part of the feature
     * configuration.
     */
    @get:JvmName("malformedFeature")
    val malformedFeature: EventMetricType<MalformedFeatureExtra> by lazy { // generated from nimbus_events.malformed_feature
        EventMetricType<MalformedFeatureExtra>(
            CommonMetricData(
                category = "nimbus_events",
                name = "malformed_feature",
                sendInPings = listOf("events"),
                lifetime = Lifetime.PING,
                disabled = false
            ), allowedExtraKeys = listOf("branch", "experiment", "feature_id", "part_id"))
    }
    /**
     * Recorded when an unenrollment fails, including the reason for the failure.
     */
    @get:JvmName("unenrollFailed")
    val unenrollFailed: EventMetricType<UnenrollFailedExtra> by lazy { // generated from nimbus_events.unenroll_failed
        EventMetricType<UnenrollFailedExtra>(
            CommonMetricData(
                category = "nimbus_events",
                name = "unenroll_failed",
                sendInPings = listOf("background-update", "events"),
                lifetime = Lifetime.PING,
                disabled = false
            ), allowedExtraKeys = listOf("experiment", "reason"))
    }
    /**
     * Recorded when either telemetry is disabled, or the experiment has run for its
     * designed duration (i.e. it is no longer present in the Nimbus Remote Settings
     * collection)
     */
    @get:JvmName("unenrollment")
    val unenrollment: EventMetricType<UnenrollmentExtra> by lazy { // generated from nimbus_events.unenrollment
        EventMetricType<UnenrollmentExtra>(
            CommonMetricData(
                category = "nimbus_events",
                name = "unenrollment",
                sendInPings = listOf("events"),
                lifetime = Lifetime.PING,
                disabled = false
            ), allowedExtraKeys = listOf("branch", "experiment", "reason"))
    }
}
