// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("UNUSED_PARAMETER")

package mozilla.appservices.remotesettings
import org.json.JSONObject

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }











public interface RemoteSettingsInterface {
    
    /**
     * Download an attachment with the provided id to the provided path.
     */
    fun `downloadAttachmentToPath`(`attachmentId`: kotlin.String, `path`: kotlin.String)
    
    /**
     * Fetch all records for the configuration this client was initialized with.
     */
    fun `getRecords`(): RemoteSettingsResponse
    
    /**
     * Fetch all records added to the server since the provided timestamp,
     * using the configuration this client was initialized with.
     */
    fun `getRecordsSince`(`timestamp`: kotlin.ULong): RemoteSettingsResponse
    
    companion object
}

open class RemoteSettings (private val `remoteSettingsConfig`: RemoteSettingsConfig = RemoteSettingsConfig()
): AutoCloseable, Disposable, RemoteSettingsInterface
{

    
    /**
     * Download an attachment with the provided id to the provided path.
     */
    @Throws(RemoteSettingsException::class)override fun `downloadAttachmentToPath`(`attachmentId`: kotlin.String, `path`: kotlin.String)
        {}

    
    /**
     * Fetch all records for the configuration this client was initialized with.
     */
    @Throws(RemoteSettingsException::class)override fun `getRecords`(): RemoteSettingsResponse {
            return  RemoteSettingsResponse()
    }

    
    /**
     * Fetch all records added to the server since the provided timestamp,
     * using the configuration this client was initialized with.
     */
    @Throws(RemoteSettingsException::class)override fun `getRecordsSince`(`timestamp`: kotlin.ULong): RemoteSettingsResponse {
            return  RemoteSettingsResponse()
    }

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



/**
 * Client for a single Remote Settings collection
 *
 * Use [RemoteSettingsService::make_client] to create these.
 */
public interface RemoteSettingsClientInterface {
    
    /**
     * Collection this client is for
     */
    fun `collectionName`(): kotlin.String
    
    /**
     * Get attachment data for a remote settings record
     *
     * Attachments are large binary blobs used for data that doesn't fit in a normal record.  They
     * are handled differently than other record data:
     *
     * - Attachments are not downloaded in [RemoteSettingsService::sync]
     * - This method will make network requests if the attachment is not cached
     * - This method will throw if there is a network or other error when fetching the
     * attachment data.
     */
    fun `getAttachment`(`record`: RemoteSettingsRecord): kotlin.ByteArray
    
    /**
     * Get the current set of records.
     *
     * This method normally fetches records from the last sync.  This means that it returns fast
     * and does not make any network requests.
     *
     * If records have not yet been synced it will return None.  Use `sync_if_empty = true` to
     * change this behavior and perform a network request in this case.  That this is probably a
     * bad idea if you want to fetch the setting in application startup or when building the UI.
     *
     * None will also be returned on disk IO errors or other unexpected errors.  The reason for
     * this is that there is not much an application can do in this situation other than fall back
     * to the same default handling as if records have not been synced.
     *
     * Application-services schedules regular dumps of the server data for specific collections.
     * For these collections, `get_records` will never return None.  If you would like to add your
     * collection to this list, please reach out to the DISCO team.
     */
    fun `getRecords`(`syncIfEmpty`: kotlin.Boolean = false): List<RemoteSettingsRecord>?
    
    /**
     * Get the current set of records as a map of record_id -> record.
     *
     * See [Self::get_records] for an explanation of when this makes network requests, error
     * handling, and how the `sync_if_empty` param works.
     */
    fun `getRecordsMap`(`syncIfEmpty`: kotlin.Boolean = false): Map<kotlin.String, RemoteSettingsRecord>?
    
    /**
     * Shutdown the client, releasing the SQLite connection used to cache records.
     */
    fun `shutdown`()
    
    fun `sync`()
    
    companion object
}

/**
 * Client for a single Remote Settings collection
 *
 * Use [RemoteSettingsService::make_client] to create these.
 */
open class RemoteSettingsClient (
): AutoCloseable, Disposable, RemoteSettingsClientInterface
{

    
    /**
     * Collection this client is for
     */override fun `collectionName`(): kotlin.String {
            return  ""
    }

    
    /**
     * Get attachment data for a remote settings record
     *
     * Attachments are large binary blobs used for data that doesn't fit in a normal record.  They
     * are handled differently than other record data:
     *
     * - Attachments are not downloaded in [RemoteSettingsService::sync]
     * - This method will make network requests if the attachment is not cached
     * - This method will throw if there is a network or other error when fetching the
     * attachment data.
     */
    @Throws(RemoteSettingsException::class)override fun `getAttachment`(`record`: RemoteSettingsRecord): kotlin.ByteArray {
            return  byteArrayOf()
    }

    
    /**
     * Get the current set of records.
     *
     * This method normally fetches records from the last sync.  This means that it returns fast
     * and does not make any network requests.
     *
     * If records have not yet been synced it will return None.  Use `sync_if_empty = true` to
     * change this behavior and perform a network request in this case.  That this is probably a
     * bad idea if you want to fetch the setting in application startup or when building the UI.
     *
     * None will also be returned on disk IO errors or other unexpected errors.  The reason for
     * this is that there is not much an application can do in this situation other than fall back
     * to the same default handling as if records have not been synced.
     *
     * Application-services schedules regular dumps of the server data for specific collections.
     * For these collections, `get_records` will never return None.  If you would like to add your
     * collection to this list, please reach out to the DISCO team.
     */override fun `getRecords`(`syncIfEmpty`: kotlin.Boolean): List<RemoteSettingsRecord>? {
            return  null
    }

    
    /**
     * Get the current set of records as a map of record_id -> record.
     *
     * See [Self::get_records] for an explanation of when this makes network requests, error
     * handling, and how the `sync_if_empty` param works.
     */override fun `getRecordsMap`(`syncIfEmpty`: kotlin.Boolean): Map<kotlin.String, RemoteSettingsRecord>? {
            return  null
    }

    
    /**
     * Shutdown the client, releasing the SQLite connection used to cache records.
     */override fun `shutdown`()
        {}

    
    @Throws(RemoteSettingsException::class)override fun `sync`()
        {}

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



/**
 * Application-level Remote Settings manager.
 *
 * This handles application-level operations, like syncing all the collections, and acts as a
 * factory for creating clients.
 */
public interface RemoteSettingsServiceInterface {
    
    /**
     * Create a new Remote Settings client
     *
     * This method performs no IO or network requests and is safe to run in a main thread that can't be blocked.
     */
    fun `makeClient`(`collectionName`: kotlin.String): RemoteSettingsClient
    
    /**
     * Sync collections for all active clients
     */
    fun `sync`(): List<kotlin.String>
    
    /**
     * Update the remote settings config
     *
     * This will cause all current and future clients to use new config and will delete any stored
     * records causing the clients to return new results from the new config.
     *
     * Only intended for QA/debugging.  Swapping the remote settings server in the middle of
     * execution can cause weird effects.
     */
    fun `updateConfig`(`config`: RemoteSettingsConfig2)
    
    companion object
}

/**
 * Application-level Remote Settings manager.
 *
 * This handles application-level operations, like syncing all the collections, and acts as a
 * factory for creating clients.
 */
open class RemoteSettingsService (private val `storageDir`: kotlin.String = "", private val `config`: RemoteSettingsConfig2 = RemoteSettingsConfig2()
): AutoCloseable, Disposable, RemoteSettingsServiceInterface
{

    
    /**
     * Create a new Remote Settings client
     *
     * This method performs no IO or network requests and is safe to run in a main thread that can't be blocked.
     */override fun `makeClient`(`collectionName`: kotlin.String): RemoteSettingsClient {
            return  RemoteSettingsClient()
    }

    
    /**
     * Sync collections for all active clients
     */
    @Throws(RemoteSettingsException::class)override fun `sync`(): List<kotlin.String> {
            return  emptyList()
    }

    
    /**
     * Update the remote settings config
     *
     * This will cause all current and future clients to use new config and will delete any stored
     * records causing the clients to return new results from the new config.
     *
     * Only intended for QA/debugging.  Swapping the remote settings server in the middle of
     * execution can cause weird effects.
     */
    @Throws(RemoteSettingsException::class)override fun `updateConfig`(`config`: RemoteSettingsConfig2)
        {}

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



/**
 * Attachment metadata that can be optionally attached to a [Record]. The [location] should
 * included in calls to [Client::get_attachment].
 */
data class Attachment (
    var `filename`: kotlin.String = ""
    , 
    var `mimetype`: kotlin.String = ""
    , 
    var `location`: kotlin.String = ""
    , 
    var `hash`: kotlin.String = ""
    , 
    var `size`: kotlin.ULong = 0uL
    
) {
    
    companion object
}



/**
 * Custom configuration for the client.
 * Currently includes the following:
 * - `server`: The Remote Settings server to use. If not specified, defaults to the production server (`RemoteSettingsServer::Prod`).
 * - `server_url`: An optional custom Remote Settings server URL. Deprecated; please use `server` instead.
 * - `bucket_name`: The optional name of the bucket containing the collection on the server. If not specified, the standard bucket will be used.
 * - `collection_name`: The name of the collection for the settings server.
 */
data class RemoteSettingsConfig (
    var `collectionName`: kotlin.String = ""
    , 
    var `bucketName`: kotlin.String? = null
    , 
    var `serverUrl`: kotlin.String? = null
    , 
    var `server`: RemoteSettingsServer? = null
    
) {
    
    companion object
}



/**
 * Remote settings configuration
 *
 * This is the version used in the new API, hence the `2` at the end.  The plan is to move
 * consumers to the new API, remove the RemoteSettingsConfig struct, then remove the `2` from this
 * name.
 */
data class RemoteSettingsConfig2 (
    /**
     * The Remote Settings server to use. Defaults to [RemoteSettingsServer::Prod],
     */
    var `server`: RemoteSettingsServer? = null
    , 
    /**
     * Bucket name to use, defaults to "main".  Use "main-preview" for a preview bucket
     */
    var `bucketName`: kotlin.String? = null
    , 
    /**
     * App context to use for JEXL filtering (when the `jexl` feature is present).
     */
    var `appContext`: RemoteSettingsContext? = null
    
) {
    
    companion object
}



/**
 * Remote settings context object
 *
 * This is used to filter the records returned. We always fetch all `records` from the
 * remote-settings storage. Some records could have a `filter_expression`.  If this is passed in
 * and the record has a `filter_expression`, then only returns where the expression is true will
 * be returned.
 *
 * See https://remote-settings.readthedocs.io/en/latest/target-filters.html for details.
 */
data class RemoteSettingsContext (
    /**
     * The delivery channel of the application (e.g "nightly")
     */
    var `channel`: kotlin.String? = null
    , 
    /**
     * User visible version string (e.g. "1.0.3")
     */
    var `appVersion`: kotlin.String? = null
    , 
    /**
     * String containing the XUL application app_id
     */
    var `appId`: kotlin.String? = null
    , 
    /**
     * The locale of the application during initialization (e.g. "es-ES")
     */
    var `locale`: kotlin.String? = null
    , 
    /**
     * The name of the operating system (e.g. "Android", "iOS", "Darwin", "WINNT")
     */
    var `os`: kotlin.String? = null
    , 
    /**
     * The user-visible version of the operating system (e.g. "1.2.3")
     */
    var `osVersion`: kotlin.String? = null
    , 
    /**
     * Form-factor of the device ("phone", "tablet", or "desktop")
     */
    var `formFactor`: kotlin.String? = null
    , 
    /**
     * Country of the user.
     *
     * This is usually populated in one of two ways:
     * - The second component of the locale
     * - By using a geolocation service, which determines country via the user's IP.
     * Firefox apps usually have a module that integrates with these services,
     * for example `Region` on Desktop and `RegionMiddleware` on Android.
     */
    var `country`: kotlin.String? = null
    , 
    /**
     * Extra attributes to add to the env for JEXL filtering.
     *
     * Use this for prototyping / testing new features.  In the long-term, new fields should be
     * added to the official list and supported by both the Rust and Gecko clients.
     */
    var `customTargettingAttributes`: Map<kotlin.String, kotlin.String>? = null
    
) {
    
    companion object
}



/**
 * A parsed Remote Settings record. Records can contain arbitrary fields, so clients
 * are required to further extract expected values from the [fields] member.
 */
data class RemoteSettingsRecord (
    var `id`: kotlin.String = ""
    , 
    var `lastModified`: kotlin.ULong = 0uL
    , 
    /**
     * Tombstone flag (see https://remote-settings.readthedocs.io/en/latest/client-specifications.html#local-state)
     */
    var `deleted`: kotlin.Boolean = false
    , 
    var `attachment`: Attachment? = null
    , 
    var `fields`: RsJsonObject = JSONObject("")
    
) {
    
    companion object
}



/**
 * Data structure representing the top-level response from the Remote Settings.
 * [last_modified] will be extracted from the etag header of the response.
 */
data class RemoteSettingsResponse (
    var `records`: List<RemoteSettingsRecord> = emptyList()
    , 
    var `lastModified`: kotlin.ULong = 0uL
    
) {
    
    companion object
}





/**
 * Public error class, this is what we return to consumers
 */
sealed class RemoteSettingsException: kotlin.Exception() {
    
    /**
     * Network error while making a remote settings request
     */
    class Network(
        
        val `reason`: kotlin.String = ""
        ) : RemoteSettingsException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    /**
     * The server has asked the client to backoff.
     */
    class Backoff(
        
        val `seconds`: kotlin.ULong = 0uL
        ) : RemoteSettingsException() {
        override val message
            get() = "seconds=${ `seconds` }"
    }
    
    class Other(
        
        val `reason`: kotlin.String = ""
        ) : RemoteSettingsException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    

    
}



/**
 * The Remote Settings server that the client should use.
 */
sealed class RemoteSettingsServer {
    
    object Prod : RemoteSettingsServer()
    
    
    object Stage : RemoteSettingsServer()
    
    
    object Dev : RemoteSettingsServer()
    
    
    data class Custom(
        val `url`: kotlin.String = "") : RemoteSettingsServer() {
        companion object
    }
    
    object __NOOP : RemoteSettingsServer()

    
    companion object
}





























/**
 * Typealias from the type name used in the UDL file to the custom type.  This
 * is needed because the UDL type name is used in function/method signatures.
 * It's also what we have an external type that references a custom type.
 */
public typealias RsJsonObject = JSONObject


