// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("UNUSED_PARAMETER")

package mozilla.appservices.fxaclient
import mozilla.appservices.sync15.DeviceType

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }









/**
 * Object representing the signed-in state of an application.
 *
 * The `FirefoxAccount` object is the main interface provided by this crate.
 * It represents the signed-in state of an application that may be connected to
 * user's Firefox Account, and provides methods for inspecting the state of the
 * account and accessing other services on behalf of the user.

 */
public interface FirefoxAccountInterface {
    
    /**
     * Create a new OAuth authorization code using the stored session token.
     *
     * When a signed-in application receives an incoming device pairing request, it can
     * use this method to grant the request and generate a corresponding OAuth authorization
     * code. This code would then be passed back to the connecting device over the
     * pairing channel (a process which is not currently supported by any code in this
     * component).
     *
     * # Arguments
     *
     *    - `params` - the OAuth parameters from the incoming authorization request

     */
    fun `authorizeCodeUsingSessionToken`(`params`: AuthorizationParameters): kotlin.String
    
    /**
     * Initiate a web-based OAuth sign-in flow.
     *
     * This method initializes some internal state and then returns a URL at which the
     * user may perform a web-based authorization flow to connect the application to
     * their account. The application should direct the user to the provided URL.
     *
     * When the resulting OAuth flow redirects back to the configured `redirect_uri`,
     * the query parameters should be extracting from the URL and passed to the
     * [`complete_oauth_flow`](FirefoxAccount::complete_oauth_flow) method to finalize
     * the signin.
     *
     * # Arguments
     *
     *   - `scopes` - list of OAuth scopes to request.
     *       - The requested scopes will determine what account-related data
     *         the application is able to access.
     *   - `entrypoint` - metrics identifier for UX entrypoint.
     *       - This parameter is used for metrics purposes, to identify the
     *         UX entrypoint from which the user triggered the signin request.
     *         For example, the application toolbar, on the onboarding flow.
     *   - `metrics` - optionally, additional metrics tracking parameters.
     *       - These will be included as query parameters in the resulting URL.

     */
    fun `beginOauthFlow`(`scopes`: List<kotlin.String>, `entrypoint`: kotlin.String): kotlin.String
    
    /**
     * Initiate a device-pairing sign-in flow.
     *
     * Once the user has scanned a pairing QR code, pass the scanned value to this
     * method. It will return a URL to which the application should redirect the user
     * in order to continue the sign-in flow.
     *
     * When the resulting flow redirects back to the configured `redirect_uri`,
     * the resulting OAuth parameters should be extracting from the URL and passed
     * to [`complete_oauth_flow`](FirefoxAccount::complete_oauth_flow) to finalize
     * the signin.
     *
     * # Arguments
     *
     *   - `pairing_url` - the URL scanned from a QR code on another device.
     *   - `scopes` - list of OAuth scopes to request.
     *       - The requested scopes will determine what account-related data
     *         the application is able to access.
     *   - `entrypoint` - metrics identifier for UX entrypoint.
     *       - This parameter is used for metrics purposes, to identify the
     *         UX entrypoint from which the user triggered the signin request.
     *         For example, the application toolbar, on the onboarding flow.
     *   - `metrics` - optionally, additional metrics tracking parameters.
     *       - These will be included as query parameters in the resulting URL.

     */
    fun `beginPairingFlow`(`pairingUrl`: kotlin.String, `scopes`: List<kotlin.String>, `entrypoint`: kotlin.String): kotlin.String
    
    /**
     * Check authorization status for this application.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications may call this method to check with the FxA server about the status
     * of their authentication tokens. It returns an [`AuthorizationInfo`] struct
     * with details about whether the tokens are still active.

     */
    fun `checkAuthorizationStatus`(): AuthorizationInfo
    
    /**
     * Clear the access token cache in response to an auth failure.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that receive an authentication error when trying to use an access token,
     * should call this method before creating a new token and retrying the failed operation.
     * It ensures that the expired token is removed and a fresh one generated.

     */
    fun `clearAccessTokenCache`()
    
    /**
     * Clear any custom display name used for this application instance.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method clears the name of the current application's device record, causing other
     * applications or the user's account management pages to have to fill in some sort of
     * default name when displaying this device.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    fun `clearDeviceName`()
    
    /**
     * Use device commands to close one or more tabs on another device.
     *
     * **💾 This method alters the persisted account state.**
     *
     * If a device on the account has registered the [`CloseTabs`](DeviceCapability::CloseTabs)
     * capability, this method can be used to close its tabs.
     */
    fun `closeTabs`(`targetDeviceId`: kotlin.String, `urls`: List<kotlin.String>): CloseTabsResult
    
    /**
     * Complete an OAuth flow.
     *
     * **💾 This method alters the persisted account state.**
     *
     * At the conclusion of an OAuth flow, the user will be redirect to the
     * application's registered `redirect_uri`. It should extract the `code`
     * and `state` parameters from the resulting URL and pass them to this
     * method in order to complete the sign-in.
     *
     * # Arguments
     *
     *   - `code` - the OAuth authorization code obtained from the redirect URI.
     *   - `state` - the OAuth state parameter obtained from the redirect URI.

     */
    fun `completeOauthFlow`(`code`: kotlin.String, `state`: kotlin.String)
    
    /**
     * Disconnect from the user's account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method destroys any tokens held by the client, effectively disconnecting
     * from the user's account. Applications should call this when the user opts to
     * sign out.
     *
     * The persisted account state after calling this method will contain only the
     * user's last-seen profile information, if any. This may be useful in helping
     * the user to reconnnect to their account. If reconnecting to the same account
     * is not desired then the application should discard the persisted account state.

     */
    fun `disconnect`()
    
    /**
     * Ensure that the device record has a specific set of capabilities.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method checks that the currently-registered device record is advertising the
     * given set of capabilities in the FxA "device commands" ecosystem. If not, then it
     * updates the device record to do so.
     *
     * Applications should call this method on each startup as a way to ensure that their
     * expected set of capabilities is being accurately reflected on the FxA server, and
     * to handle the rollout of new capabilities over time.
     *
     * # Arguments
     *
     *    - `supported_capabilities` - the set of [capabilities](DeviceCapability) to register
     *       for this device in the "device commands" ecosystem.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    fun `ensureCapabilities`(`supportedCapabilities`: List<DeviceCapability>): LocalDevice
    
    /**
     * Collect and return telemetry about incoming and outgoing device commands.
     *
     * Applications that have registered one or more [`DeviceCapability`]s
     * should also arrange to submit "sync ping" telemetry. Calling this method will
     * return a JSON string of telemetry data that can be incorporated into that ping.
     *
     * Sorry, this is not particularly carefully documented because it is intended
     * as a stop-gap until we get native Glean support. If you know how to submit
     * a sync ping, you'll know what to do with the contents of the JSON string.

     */
    fun `gatherTelemetry`(): kotlin.String
    
    /**
     * Get a short-lived OAuth access token for the user's account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that need to access resources on behalf of the user must obtain an
     * `access_token` in order to do so. For example, an access token is required when
     * fetching the user's profile data, or when accessing their data stored in Firefox Sync.
     *
     * This method will obtain and return an access token bearing the requested scopes, either
     * from a local cache of previously-issued tokens, or by creating a new one from the server.
     *
     * # Arguments
     *
     *    - `scope` - the OAuth scope to be granted by the token.
     *        - This must be one of the scopes requested during the signin flow.
     *        - Only a single scope is supported; for multiple scopes request multiple tokens.
     *    - `ttl` - optionally, the time for which the token should be valid, in seconds.
     *
     * # Notes
     *
     *    - If the application receives an authorization error when trying to use the resulting
     *      token, it should call [`clear_access_token_cache`](FirefoxAccount::clear_access_token_cache)
     *      before requesting a fresh token.

     */
    fun `getAccessToken`(`scope`: kotlin.String, `ttl`: kotlin.Long? = null): AccessTokenInfo
    
    /**
     * Get the list of all client applications attached to the user's account.
     *
     * This method returns a list of [`AttachedClient`] structs representing all the applications
     * connected to the user's account. This includes applications that are registered as a device
     * as well as server-side services that the user has connected.
     *
     * This information is really only useful for targeted messaging or marketing purposes,
     * e.g. if the application wants to advertize a related product, but first wants to check
     * whether the user is already using that product.
     *
     * # Notes
     *
     *    - Attached client metadata is only visible to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    fun `getAttachedClients`(): List<AttachedClient>
    
    /**
     * Get the high-level authentication state of the client
     *
     * Deprecated: Use get_state() instead
     */
    fun `getAuthState`(): FxaRustAuthState
    
    /**
     * Get a URL which shows a "successfully connceted!" message.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications can use this method after a successful signin, to redirect the
     * user to a success message displayed in web content rather than having to
     * implement their own native success UI.

     */
    fun `getConnectionSuccessUrl`(): kotlin.String
    
    /**
     * Get the device id registered for this application.
     *
     * # Notes
     *
     *    - If the application has not registered a device record, this method will
     *      throw an [`Other`](FxaError::Other) error.
     *        - (Yeah...sorry. This should be changed to do something better.)
     *    - Device metadata is only visible to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    fun `getCurrentDeviceId`(): kotlin.String
    
    /**
     * Get the list of devices registered on the user's account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method returns a list of [`Device`] structs representing all the devices
     * currently attached to the user's account (including the current device).
     * The application might use this information to e.g. display a list of appropriate
     * send-tab targets.
     *
     * # Arguments
     *
     *    - `ignore_cache` - if true, always hit the server for fresh profile information.
     *
     * # Notes
     *
     *    - Device metadata is only visible to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    fun `getDevices`(`ignoreCache`: kotlin.Boolean): List<Device>
    
    /**
     * Get a URL at which the user can manage their account and profile data.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications should link the user out to this URL from an appropriate place
     * in their signed-in settings UI.
     *
     * # Arguments
     *
     *   - `entrypoint` - metrics identifier for UX entrypoint.
     *       - This parameter is used for metrics purposes, to identify the
     *         UX entrypoint from which the user followed the link.

     */
    fun `getManageAccountUrl`(`entrypoint`: kotlin.String): kotlin.String
    
    /**
     * Get a URL at which the user can manage the devices connected to their account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications should link the user out to this URL from an appropriate place
     * in their signed-in settings UI. For example, "Manage your devices..." may be
     * a useful link to place somewhere near the device list in the send-tab UI.
     *
     * # Arguments
     *
     *   - `entrypoint` - metrics identifier for UX entrypoint.
     *       - This parameter is used for metrics purposes, to identify the
     *         UX entrypoint from which the user followed the link.

     */
    fun `getManageDevicesUrl`(`entrypoint`: kotlin.String): kotlin.String
    
    /**
     * Get the URL at which to begin a device-pairing signin flow.
     *
     * If the user wants to sign in using device pairing, call this method and then
     * direct them to visit the resulting URL on an already-signed-in device. Doing
     * so will trigger the other device to show a QR code to be scanned, and the result
     * from said QR code can be passed to [`begin_pairing_flow`](FirefoxAccount::begin_pairing_flow).

     */
    fun `getPairingAuthorityUrl`(): kotlin.String
    
    /**
     * Get profile information for the signed-in user, if any.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method fetches a [`Profile`] struct with information about the currently-signed-in
     * user, either by using locally-cached profile information or by fetching fresh data from
     * the server.
     *
     * # Arguments
     *
     *    - `ignore_cache` - if true, always hit the server for fresh profile information.
     *
     * # Notes
     *
     *    - Profile information is only available to applications that have been
     *      granted the `profile` scope.
     *    - There is currently no API for fetching cached profile information without
     *      potentially hitting the server.
     *    - If there is no signed-in user, this method will throw an
     *      [`Authentication`](FxaError::Authentication) error.

     */
    fun `getProfile`(`ignoreCache`: kotlin.Boolean): Profile
    
    /**
     * Get the session token for the user's account, if one is available.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that function as a web browser may need to hold on to a session token
     * on behalf of Firefox Accounts web content. This method exists so that they can retrieve
     * it an pass it back to said web content when required.
     *
     * # Notes
     *
     *    - Please do not attempt to use the resulting token to directly make calls to the
     *      Firefox Accounts servers! All account management functionality should be performed
     *      in web content.
     *    - A session token is only available to applications that have requested the
     *      `https:///identity.mozilla.com/tokens/session` scope.

     */
    fun `getSessionToken`(): kotlin.String
    
    /**
     * Get the current state
     */
    fun `getState`(): FxaState
    
    /**
     * Get the URL at which to access the user's sync data.
     *
     * **💾 This method alters the persisted account state.**

     */
    fun `getTokenServerEndpointUrl`(): kotlin.String
    
    /**
     * Process and respond to a server-delivered account update message
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications should call this method whenever they receive a push notification from the Firefox Accounts server.
     * Such messages typically indicate a noteworthy change of state on the user's account, such as an update to their profile information
     * or the disconnection of a client. The [`FirefoxAccount`] struct will update its internal state
     * accordingly and return an individual [`AccountEvent`] struct describing the event, which the application
     * may use for further processing.
     *
     * It's important to note if the event is [`AccountEvent::CommandReceived`], the caller should call
     * [`FirefoxAccount::poll_device_commands`]

     */
    fun `handlePushMessage`(`payload`: kotlin.String): AccountEvent
    
    /**
     * Update the stored session token for the user's account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that function as a web browser may need to hold on to a session token
     * on behalf of Firefox Accounts web content. This method exists so that said web content
     * signals that it has generated a new session token, the stored value can be updated
     * to match.
     *
     * # Arguments
     *
     *    - `session_token` - the new session token value provided from web content.

     */
    fun `handleSessionTokenChange`(`sessionToken`: kotlin.String)
    
    /**
     * Create a new device record for this application.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method registered a device record for the application, providing basic metadata for
     * the device along with a list of supported [Device Capabilities](DeviceCapability) for
     * participating in the "device commands" ecosystem.
     *
     * Applications should call this method soon after a successful sign-in, to ensure
     * they they appear correctly in the user's account-management pages and when discovered
     * by other devices connected to the account.
     *
     * # Arguments
     *
     *    - `name` - human-readable display name to use for this application
     *    - `device_type` - the [type](DeviceType) of device the application is installed on
     *    - `supported_capabilities` - the set of [capabilities](DeviceCapability) to register
     *       for this device in the "device commands" ecosystem.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    fun `initializeDevice`(`name`: kotlin.String, `deviceType`: DeviceType, `supportedCapabilities`: List<DeviceCapability>): LocalDevice
    
    /**
     * Update the state based on authentication issues.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Call this if you know there's an authentication / authorization issue that requires the
     * user to re-authenticated.  It transitions the user to the [FxaRustAuthState.AuthIssues] state.
     */
    fun `onAuthIssues`()
    
    /**
     * Poll the server for any pending device commands.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that have registered one or more [`DeviceCapability`]s with the server can use
     * this method to check whether other devices on the account have sent them any commands.
     * It will return a list of [`IncomingDeviceCommand`] structs for the application to process.
     *
     * # Notes
     *
     *    - Device commands are typically delivered via push message and the [`CommandReceived`](
     *      AccountEvent::CommandReceived) event. Polling should only be used as a backup delivery
     *      mechanism, f the application has reason to believe that push messages may have been missed.
     *    - Device commands functionality is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    fun `pollDeviceCommands`(): List<IncomingDeviceCommand>
    
    /**
     * Process an event (login, logout, etc).
     *
     * On success, update the current state and return it.
     * On error, the current state will remain the same.
     */
    fun `processEvent`(`event`: FxaEvent): FxaState
    
    /**
     * Use device commands to send a single tab to another device.
     *
     * **💾 This method alters the persisted account state.**
     *
     * If a device on the account has registered the [`SendTab`](DeviceCapability::SendTab)
     * capability, this method can be used to send it a tab.
     *
     * # Notes
     *
     *    - If the given device id does not existing or is not capable of receiving tabs,
     *      this method will throw an [`Other`](FxaError::Other) error.
     *        - (Yeah...sorry. This should be changed to do something better.)
     *    - It is not currently possible to send a full [`SendTabPayload`] to another device,
     *      but that's purely an API limitation that should go away in future.
     *    - Device commands functionality is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    fun `sendSingleTab`(`targetDeviceId`: kotlin.String, `title`: kotlin.String, `url`: kotlin.String)
    
    /**
     * Update the display name used for this application instance.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method modifies the name of the current application's device record, as seen by
     * other applications and in the user's account management pages.
     *
     * # Arguments
     *
     *    - `display_name` - the new name for the current device.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    fun `setDeviceName`(`displayName`: kotlin.String): LocalDevice
    
    /**
     * Set or update a push subscription endpoint for this device.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method registers the given webpush subscription with the FxA server, requesting
     * that is send notifications in the event of any significant changes to the user's
     * account. When the application receives a push message at the registered subscription
     * endpoint, it should decrypt the payload and pass it to the [`handle_push_message`](
     * FirefoxAccount::handle_push_message) method for processing.
     *
     * # Arguments
     *
     *    - `subscription` - the [`DevicePushSubscription`] details to register with the server.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    fun `setPushSubscription`(`subscription`: DevicePushSubscription): LocalDevice
    
    /**
     * Sets the users information based on the web content's login information
     * This is intended to only be used by user agents (eg: Firefox) to set the users
     * session token and tie it to the refresh token that will be issued at the end of the
     * oauth flow.
     */
    fun `setUserData`(`userData`: UserData)
    
    /**
     * Used by the application to test auth token issues
     */
    fun `simulateNetworkError`()
    
    /**
     * Used by the application to test auth token issues
     */
    fun `simulatePermanentAuthTokenIssue`()
    
    /**
     * Used by the application to test auth token issues
     */
    fun `simulateTemporaryAuthTokenIssue`()
    
    /**
     * Save current state to a JSON string.
     *
     * This method serializes the current account state into a JSON string, which
     * the application can use to persist the user's signed-in state across restarts.
     * The application should call this method and update its persisted state after
     * any potentially-state-changing operation.
     *
     * **⚠️ Warning:** the serialized state may contain encryption keys and access
     * tokens that let anyone holding them access the user's data in Firefox Sync
     * and/or other FxA services. Applications should take care to store the resulting
     * data in a secure fashion, as appropriate for their target platform.

     */
    fun `toJson`(): kotlin.String
    
    companion object
}

/**
 * Object representing the signed-in state of an application.
 *
 * The `FirefoxAccount` object is the main interface provided by this crate.
 * It represents the signed-in state of an application that may be connected to
 * user's Firefox Account, and provides methods for inspecting the state of the
 * account and accessing other services on behalf of the user.

 */
open class FirefoxAccount (private val `config`: FxaConfig = FxaConfig()
): AutoCloseable, Disposable, FirefoxAccountInterface
{

    
    /**
     * Create a new OAuth authorization code using the stored session token.
     *
     * When a signed-in application receives an incoming device pairing request, it can
     * use this method to grant the request and generate a corresponding OAuth authorization
     * code. This code would then be passed back to the connecting device over the
     * pairing channel (a process which is not currently supported by any code in this
     * component).
     *
     * # Arguments
     *
     *    - `params` - the OAuth parameters from the incoming authorization request

     */
    @Throws(FxaException::class)override fun `authorizeCodeUsingSessionToken`(`params`: AuthorizationParameters): kotlin.String {
            return  ""
    }

    
    /**
     * Initiate a web-based OAuth sign-in flow.
     *
     * This method initializes some internal state and then returns a URL at which the
     * user may perform a web-based authorization flow to connect the application to
     * their account. The application should direct the user to the provided URL.
     *
     * When the resulting OAuth flow redirects back to the configured `redirect_uri`,
     * the query parameters should be extracting from the URL and passed to the
     * [`complete_oauth_flow`](FirefoxAccount::complete_oauth_flow) method to finalize
     * the signin.
     *
     * # Arguments
     *
     *   - `scopes` - list of OAuth scopes to request.
     *       - The requested scopes will determine what account-related data
     *         the application is able to access.
     *   - `entrypoint` - metrics identifier for UX entrypoint.
     *       - This parameter is used for metrics purposes, to identify the
     *         UX entrypoint from which the user triggered the signin request.
     *         For example, the application toolbar, on the onboarding flow.
     *   - `metrics` - optionally, additional metrics tracking parameters.
     *       - These will be included as query parameters in the resulting URL.

     */
    @Throws(FxaException::class)override fun `beginOauthFlow`(`scopes`: List<kotlin.String>, `entrypoint`: kotlin.String): kotlin.String {
            return  ""
    }

    
    /**
     * Initiate a device-pairing sign-in flow.
     *
     * Once the user has scanned a pairing QR code, pass the scanned value to this
     * method. It will return a URL to which the application should redirect the user
     * in order to continue the sign-in flow.
     *
     * When the resulting flow redirects back to the configured `redirect_uri`,
     * the resulting OAuth parameters should be extracting from the URL and passed
     * to [`complete_oauth_flow`](FirefoxAccount::complete_oauth_flow) to finalize
     * the signin.
     *
     * # Arguments
     *
     *   - `pairing_url` - the URL scanned from a QR code on another device.
     *   - `scopes` - list of OAuth scopes to request.
     *       - The requested scopes will determine what account-related data
     *         the application is able to access.
     *   - `entrypoint` - metrics identifier for UX entrypoint.
     *       - This parameter is used for metrics purposes, to identify the
     *         UX entrypoint from which the user triggered the signin request.
     *         For example, the application toolbar, on the onboarding flow.
     *   - `metrics` - optionally, additional metrics tracking parameters.
     *       - These will be included as query parameters in the resulting URL.

     */
    @Throws(FxaException::class)override fun `beginPairingFlow`(`pairingUrl`: kotlin.String, `scopes`: List<kotlin.String>, `entrypoint`: kotlin.String): kotlin.String {
            return  ""
    }

    
    /**
     * Check authorization status for this application.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications may call this method to check with the FxA server about the status
     * of their authentication tokens. It returns an [`AuthorizationInfo`] struct
     * with details about whether the tokens are still active.

     */
    @Throws(FxaException::class)override fun `checkAuthorizationStatus`(): AuthorizationInfo {
            return  AuthorizationInfo()
    }

    
    /**
     * Clear the access token cache in response to an auth failure.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that receive an authentication error when trying to use an access token,
     * should call this method before creating a new token and retrying the failed operation.
     * It ensures that the expired token is removed and a fresh one generated.

     */override fun `clearAccessTokenCache`()
        {}

    
    /**
     * Clear any custom display name used for this application instance.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method clears the name of the current application's device record, causing other
     * applications or the user's account management pages to have to fill in some sort of
     * default name when displaying this device.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    @Throws(FxaException::class)override fun `clearDeviceName`()
        {}

    
    /**
     * Use device commands to close one or more tabs on another device.
     *
     * **💾 This method alters the persisted account state.**
     *
     * If a device on the account has registered the [`CloseTabs`](DeviceCapability::CloseTabs)
     * capability, this method can be used to close its tabs.
     */
    @Throws(FxaException::class)override fun `closeTabs`(`targetDeviceId`: kotlin.String, `urls`: List<kotlin.String>): CloseTabsResult {
            return  CloseTabsResult.__NOOP
    }

    
    /**
     * Complete an OAuth flow.
     *
     * **💾 This method alters the persisted account state.**
     *
     * At the conclusion of an OAuth flow, the user will be redirect to the
     * application's registered `redirect_uri`. It should extract the `code`
     * and `state` parameters from the resulting URL and pass them to this
     * method in order to complete the sign-in.
     *
     * # Arguments
     *
     *   - `code` - the OAuth authorization code obtained from the redirect URI.
     *   - `state` - the OAuth state parameter obtained from the redirect URI.

     */
    @Throws(FxaException::class)override fun `completeOauthFlow`(`code`: kotlin.String, `state`: kotlin.String)
        {}

    
    /**
     * Disconnect from the user's account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method destroys any tokens held by the client, effectively disconnecting
     * from the user's account. Applications should call this when the user opts to
     * sign out.
     *
     * The persisted account state after calling this method will contain only the
     * user's last-seen profile information, if any. This may be useful in helping
     * the user to reconnnect to their account. If reconnecting to the same account
     * is not desired then the application should discard the persisted account state.

     */override fun `disconnect`()
        {}

    
    /**
     * Ensure that the device record has a specific set of capabilities.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method checks that the currently-registered device record is advertising the
     * given set of capabilities in the FxA "device commands" ecosystem. If not, then it
     * updates the device record to do so.
     *
     * Applications should call this method on each startup as a way to ensure that their
     * expected set of capabilities is being accurately reflected on the FxA server, and
     * to handle the rollout of new capabilities over time.
     *
     * # Arguments
     *
     *    - `supported_capabilities` - the set of [capabilities](DeviceCapability) to register
     *       for this device in the "device commands" ecosystem.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    @Throws(FxaException::class)override fun `ensureCapabilities`(`supportedCapabilities`: List<DeviceCapability>): LocalDevice {
            return  LocalDevice()
    }

    
    /**
     * Collect and return telemetry about incoming and outgoing device commands.
     *
     * Applications that have registered one or more [`DeviceCapability`]s
     * should also arrange to submit "sync ping" telemetry. Calling this method will
     * return a JSON string of telemetry data that can be incorporated into that ping.
     *
     * Sorry, this is not particularly carefully documented because it is intended
     * as a stop-gap until we get native Glean support. If you know how to submit
     * a sync ping, you'll know what to do with the contents of the JSON string.

     */
    @Throws(FxaException::class)override fun `gatherTelemetry`(): kotlin.String {
            return  ""
    }

    
    /**
     * Get a short-lived OAuth access token for the user's account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that need to access resources on behalf of the user must obtain an
     * `access_token` in order to do so. For example, an access token is required when
     * fetching the user's profile data, or when accessing their data stored in Firefox Sync.
     *
     * This method will obtain and return an access token bearing the requested scopes, either
     * from a local cache of previously-issued tokens, or by creating a new one from the server.
     *
     * # Arguments
     *
     *    - `scope` - the OAuth scope to be granted by the token.
     *        - This must be one of the scopes requested during the signin flow.
     *        - Only a single scope is supported; for multiple scopes request multiple tokens.
     *    - `ttl` - optionally, the time for which the token should be valid, in seconds.
     *
     * # Notes
     *
     *    - If the application receives an authorization error when trying to use the resulting
     *      token, it should call [`clear_access_token_cache`](FirefoxAccount::clear_access_token_cache)
     *      before requesting a fresh token.

     */
    @Throws(FxaException::class)override fun `getAccessToken`(`scope`: kotlin.String, `ttl`: kotlin.Long?): AccessTokenInfo {
            return  AccessTokenInfo()
    }

    
    /**
     * Get the list of all client applications attached to the user's account.
     *
     * This method returns a list of [`AttachedClient`] structs representing all the applications
     * connected to the user's account. This includes applications that are registered as a device
     * as well as server-side services that the user has connected.
     *
     * This information is really only useful for targeted messaging or marketing purposes,
     * e.g. if the application wants to advertize a related product, but first wants to check
     * whether the user is already using that product.
     *
     * # Notes
     *
     *    - Attached client metadata is only visible to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    @Throws(FxaException::class)override fun `getAttachedClients`(): List<AttachedClient> {
            return  emptyList()
    }

    
    /**
     * Get the high-level authentication state of the client
     *
     * Deprecated: Use get_state() instead
     */override fun `getAuthState`(): FxaRustAuthState {
            return  FxaRustAuthState.__NOOP
    }

    
    /**
     * Get a URL which shows a "successfully connceted!" message.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications can use this method after a successful signin, to redirect the
     * user to a success message displayed in web content rather than having to
     * implement their own native success UI.

     */
    @Throws(FxaException::class)override fun `getConnectionSuccessUrl`(): kotlin.String {
            return  ""
    }

    
    /**
     * Get the device id registered for this application.
     *
     * # Notes
     *
     *    - If the application has not registered a device record, this method will
     *      throw an [`Other`](FxaError::Other) error.
     *        - (Yeah...sorry. This should be changed to do something better.)
     *    - Device metadata is only visible to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    @Throws(FxaException::class)override fun `getCurrentDeviceId`(): kotlin.String {
            return  ""
    }

    
    /**
     * Get the list of devices registered on the user's account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method returns a list of [`Device`] structs representing all the devices
     * currently attached to the user's account (including the current device).
     * The application might use this information to e.g. display a list of appropriate
     * send-tab targets.
     *
     * # Arguments
     *
     *    - `ignore_cache` - if true, always hit the server for fresh profile information.
     *
     * # Notes
     *
     *    - Device metadata is only visible to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    @Throws(FxaException::class)override fun `getDevices`(`ignoreCache`: kotlin.Boolean): List<Device> {
            return  emptyList()
    }

    
    /**
     * Get a URL at which the user can manage their account and profile data.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications should link the user out to this URL from an appropriate place
     * in their signed-in settings UI.
     *
     * # Arguments
     *
     *   - `entrypoint` - metrics identifier for UX entrypoint.
     *       - This parameter is used for metrics purposes, to identify the
     *         UX entrypoint from which the user followed the link.

     */
    @Throws(FxaException::class)override fun `getManageAccountUrl`(`entrypoint`: kotlin.String): kotlin.String {
            return  ""
    }

    
    /**
     * Get a URL at which the user can manage the devices connected to their account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications should link the user out to this URL from an appropriate place
     * in their signed-in settings UI. For example, "Manage your devices..." may be
     * a useful link to place somewhere near the device list in the send-tab UI.
     *
     * # Arguments
     *
     *   - `entrypoint` - metrics identifier for UX entrypoint.
     *       - This parameter is used for metrics purposes, to identify the
     *         UX entrypoint from which the user followed the link.

     */
    @Throws(FxaException::class)override fun `getManageDevicesUrl`(`entrypoint`: kotlin.String): kotlin.String {
            return  ""
    }

    
    /**
     * Get the URL at which to begin a device-pairing signin flow.
     *
     * If the user wants to sign in using device pairing, call this method and then
     * direct them to visit the resulting URL on an already-signed-in device. Doing
     * so will trigger the other device to show a QR code to be scanned, and the result
     * from said QR code can be passed to [`begin_pairing_flow`](FirefoxAccount::begin_pairing_flow).

     */
    @Throws(FxaException::class)override fun `getPairingAuthorityUrl`(): kotlin.String {
            return  ""
    }

    
    /**
     * Get profile information for the signed-in user, if any.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method fetches a [`Profile`] struct with information about the currently-signed-in
     * user, either by using locally-cached profile information or by fetching fresh data from
     * the server.
     *
     * # Arguments
     *
     *    - `ignore_cache` - if true, always hit the server for fresh profile information.
     *
     * # Notes
     *
     *    - Profile information is only available to applications that have been
     *      granted the `profile` scope.
     *    - There is currently no API for fetching cached profile information without
     *      potentially hitting the server.
     *    - If there is no signed-in user, this method will throw an
     *      [`Authentication`](FxaError::Authentication) error.

     */
    @Throws(FxaException::class)override fun `getProfile`(`ignoreCache`: kotlin.Boolean): Profile {
            return  Profile()
    }

    
    /**
     * Get the session token for the user's account, if one is available.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that function as a web browser may need to hold on to a session token
     * on behalf of Firefox Accounts web content. This method exists so that they can retrieve
     * it an pass it back to said web content when required.
     *
     * # Notes
     *
     *    - Please do not attempt to use the resulting token to directly make calls to the
     *      Firefox Accounts servers! All account management functionality should be performed
     *      in web content.
     *    - A session token is only available to applications that have requested the
     *      `https:///identity.mozilla.com/tokens/session` scope.

     */
    @Throws(FxaException::class)override fun `getSessionToken`(): kotlin.String {
            return  ""
    }

    
    /**
     * Get the current state
     */override fun `getState`(): FxaState {
            return  FxaState.__NOOP
    }

    
    /**
     * Get the URL at which to access the user's sync data.
     *
     * **💾 This method alters the persisted account state.**

     */
    @Throws(FxaException::class)override fun `getTokenServerEndpointUrl`(): kotlin.String {
            return  ""
    }

    
    /**
     * Process and respond to a server-delivered account update message
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications should call this method whenever they receive a push notification from the Firefox Accounts server.
     * Such messages typically indicate a noteworthy change of state on the user's account, such as an update to their profile information
     * or the disconnection of a client. The [`FirefoxAccount`] struct will update its internal state
     * accordingly and return an individual [`AccountEvent`] struct describing the event, which the application
     * may use for further processing.
     *
     * It's important to note if the event is [`AccountEvent::CommandReceived`], the caller should call
     * [`FirefoxAccount::poll_device_commands`]

     */
    @Throws(FxaException::class)override fun `handlePushMessage`(`payload`: kotlin.String): AccountEvent {
            return  AccountEvent.__NOOP
    }

    
    /**
     * Update the stored session token for the user's account.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that function as a web browser may need to hold on to a session token
     * on behalf of Firefox Accounts web content. This method exists so that said web content
     * signals that it has generated a new session token, the stored value can be updated
     * to match.
     *
     * # Arguments
     *
     *    - `session_token` - the new session token value provided from web content.

     */
    @Throws(FxaException::class)override fun `handleSessionTokenChange`(`sessionToken`: kotlin.String)
        {}

    
    /**
     * Create a new device record for this application.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method registered a device record for the application, providing basic metadata for
     * the device along with a list of supported [Device Capabilities](DeviceCapability) for
     * participating in the "device commands" ecosystem.
     *
     * Applications should call this method soon after a successful sign-in, to ensure
     * they they appear correctly in the user's account-management pages and when discovered
     * by other devices connected to the account.
     *
     * # Arguments
     *
     *    - `name` - human-readable display name to use for this application
     *    - `device_type` - the [type](DeviceType) of device the application is installed on
     *    - `supported_capabilities` - the set of [capabilities](DeviceCapability) to register
     *       for this device in the "device commands" ecosystem.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    @Throws(FxaException::class)override fun `initializeDevice`(`name`: kotlin.String, `deviceType`: DeviceType, `supportedCapabilities`: List<DeviceCapability>): LocalDevice {
            return  LocalDevice()
    }

    
    /**
     * Update the state based on authentication issues.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Call this if you know there's an authentication / authorization issue that requires the
     * user to re-authenticated.  It transitions the user to the [FxaRustAuthState.AuthIssues] state.
     */override fun `onAuthIssues`()
        {}

    
    /**
     * Poll the server for any pending device commands.
     *
     * **💾 This method alters the persisted account state.**
     *
     * Applications that have registered one or more [`DeviceCapability`]s with the server can use
     * this method to check whether other devices on the account have sent them any commands.
     * It will return a list of [`IncomingDeviceCommand`] structs for the application to process.
     *
     * # Notes
     *
     *    - Device commands are typically delivered via push message and the [`CommandReceived`](
     *      AccountEvent::CommandReceived) event. Polling should only be used as a backup delivery
     *      mechanism, f the application has reason to believe that push messages may have been missed.
     *    - Device commands functionality is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    @Throws(FxaException::class)override fun `pollDeviceCommands`(): List<IncomingDeviceCommand> {
            return  emptyList()
    }

    
    /**
     * Process an event (login, logout, etc).
     *
     * On success, update the current state and return it.
     * On error, the current state will remain the same.
     */
    @Throws(FxaException::class)override fun `processEvent`(`event`: FxaEvent): FxaState {
            return  FxaState.__NOOP
    }

    
    /**
     * Use device commands to send a single tab to another device.
     *
     * **💾 This method alters the persisted account state.**
     *
     * If a device on the account has registered the [`SendTab`](DeviceCapability::SendTab)
     * capability, this method can be used to send it a tab.
     *
     * # Notes
     *
     *    - If the given device id does not existing or is not capable of receiving tabs,
     *      this method will throw an [`Other`](FxaError::Other) error.
     *        - (Yeah...sorry. This should be changed to do something better.)
     *    - It is not currently possible to send a full [`SendTabPayload`] to another device,
     *      but that's purely an API limitation that should go away in future.
     *    - Device commands functionality is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    @Throws(FxaException::class)override fun `sendSingleTab`(`targetDeviceId`: kotlin.String, `title`: kotlin.String, `url`: kotlin.String)
        {}

    
    /**
     * Update the display name used for this application instance.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method modifies the name of the current application's device record, as seen by
     * other applications and in the user's account management pages.
     *
     * # Arguments
     *
     *    - `display_name` - the new name for the current device.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    @Throws(FxaException::class)override fun `setDeviceName`(`displayName`: kotlin.String): LocalDevice {
            return  LocalDevice()
    }

    
    /**
     * Set or update a push subscription endpoint for this device.
     *
     * **💾 This method alters the persisted account state.**
     *
     * This method registers the given webpush subscription with the FxA server, requesting
     * that is send notifications in the event of any significant changes to the user's
     * account. When the application receives a push message at the registered subscription
     * endpoint, it should decrypt the payload and pass it to the [`handle_push_message`](
     * FirefoxAccount::handle_push_message) method for processing.
     *
     * # Arguments
     *
     *    - `subscription` - the [`DevicePushSubscription`] details to register with the server.
     *
     * # Notes
     *
     *    - Device registration is only available to applications that have been
     *      granted the `https:///identity.mozilla.com/apps/oldsync` scope.

     */
    @Throws(FxaException::class)override fun `setPushSubscription`(`subscription`: DevicePushSubscription): LocalDevice {
            return  LocalDevice()
    }

    
    /**
     * Sets the users information based on the web content's login information
     * This is intended to only be used by user agents (eg: Firefox) to set the users
     * session token and tie it to the refresh token that will be issued at the end of the
     * oauth flow.
     */override fun `setUserData`(`userData`: UserData)
        {}

    
    /**
     * Used by the application to test auth token issues
     */override fun `simulateNetworkError`()
        {}

    
    /**
     * Used by the application to test auth token issues
     */override fun `simulatePermanentAuthTokenIssue`()
        {}

    
    /**
     * Used by the application to test auth token issues
     */override fun `simulateTemporaryAuthTokenIssue`()
        {}

    
    /**
     * Save current state to a JSON string.
     *
     * This method serializes the current account state into a JSON string, which
     * the application can use to persist the user's signed-in state across restarts.
     * The application should call this method and update its persisted state after
     * any potentially-state-changing operation.
     *
     * **⚠️ Warning:** the serialized state may contain encryption keys and access
     * tokens that let anyone holding them access the user's data in Firefox Sync
     * and/or other FxA services. Applications should take care to store the resulting
     * data in a secure fashion, as appropriate for their target platform.

     */
    @Throws(FxaException::class)override fun `toJson`(): kotlin.String {
            return  ""
    }

    

    override fun close() {}
    override fun destroy() {}

    
    companion object {
        
    /**
     * Restore a [`FirefoxAccount`] instance from serialized state.
     *
     * Given a JSON string previously obtained from [`FirefoxAccount::to_json`], this
     * method will deserialize it and return a live [`FirefoxAccount`] instance.
     *
     * **⚠️ Warning:** since the serialized state contains access tokens, you should
     * not call `from_json` multiple times on the same data. This would result
     * in multiple live objects sharing the same access tokens and is likely to
     * produce unexpected behaviour.

     */
    @Throws(FxaException::class) fun `fromJson`(`data`: kotlin.String): FirefoxAccount {
            return  FirefoxAccount()
    }

        
    }
    
}



/**
 * Machinery for dry-run testing of FxaAuthStateMachine
 *
 * Remove this once we've migrated the firefox-android and firefox-ios code to using FxaAuthStateMachine
 * https:///bugzilla.mozilla.org/show_bug.cgi?id=1867793
 */
public interface FxaStateMachineCheckerInterface {
    
    fun `checkInternalState`(`state`: FxaStateCheckerState)
    
    fun `checkPublicState`(`state`: FxaState)
    
    fun `handleInternalEvent`(`event`: FxaStateCheckerEvent)
    
    fun `handlePublicEvent`(`event`: FxaEvent)
    
    companion object
}

/**
 * Machinery for dry-run testing of FxaAuthStateMachine
 *
 * Remove this once we've migrated the firefox-android and firefox-ios code to using FxaAuthStateMachine
 * https:///bugzilla.mozilla.org/show_bug.cgi?id=1867793
 */
open class FxaStateMachineChecker (
): AutoCloseable, Disposable, FxaStateMachineCheckerInterface
{

    override fun `checkInternalState`(`state`: FxaStateCheckerState)
        {}

    override fun `checkPublicState`(`state`: FxaState)
        {}

    override fun `handleInternalEvent`(`event`: FxaStateCheckerEvent)
        {}

    override fun `handlePublicEvent`(`event`: FxaEvent)
        {}

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



/**
 * An OAuth access token, with its associated keys and metadata.
 *
 * This struct represents an FxA OAuth access token, which can be used to access a resource
 * or service on behalf of the user. For example, accessing the user's data in Firefox Sync
 * an access token for the scope `https:///identity.mozilla.com/apps/sync` along with the
 * associated encryption key.

 */
data class AccessTokenInfo (
    /**
     * The scope of access granted by token.
     */
    var `scope`: kotlin.String = ""
    , 
    /**
     * The access token itself.
     *
     * This is the value that should be included in the `Authorization` header when
     * accessing an OAuth protected resource on behalf of the user.
     */
    var `token`: kotlin.String = ""
    , 
    /**
     * The client-side encryption key associated with this scope.
     *
     * **⚠️ Warning:** the value of this field should never be revealed outside of the
     * application. For example, it should never to sent to a server or logged in a log file.
     */
    var `key`: ScopedKey? = null
    , 
    /**
     * The expiry time of the token, in seconds.
     *
     * This is the timestamp at which the token is set to expire, in seconds since
     * unix epoch. Note that it is a signed integer, for compatibility with languages
     * that do not have an unsigned integer type.
     *
     * This timestamp is for guidance only. Access tokens are not guaranteed to remain
     * value for any particular lengthof time, and consumers should be prepared to handle
     * auth failures even if the token has not yet expired.
     */
    var `expiresAt`: kotlin.Long = 0L
    
) {
    
    companion object
}



/**
 * A client connected to the user's account.
 *
 * This struct provides metadata about a client connected to the user's account.
 * Unlike the [`Device`] struct, "clients" encompasses both client-side and server-side
 * applications - basically anything where the user is able to sign in with their
 * Firefox Account.
 *
 *
 * This data would typically be used for targeted messaging purposes, catering the
 * contents of the message to what other applications the user has on their account.

 */
data class AttachedClient (
    var `clientId`: kotlin.String? = null
    , 
    var `deviceId`: kotlin.String? = null
    , 
    var `deviceType`: DeviceType = DeviceType.__NOOP
    , 
    var `isCurrentSession`: kotlin.Boolean = false
    , 
    var `name`: kotlin.String? = null
    , 
    var `createdTime`: kotlin.Long? = null
    , 
    var `lastAccessTime`: kotlin.Long? = null
    , 
    var `scope`: List<kotlin.String>? = null
    
) {
    
    companion object
}



/**
 * Information about the authorization state of the application.
 *
 * This struct represents metadata about whether the application is currently
 * connected to the user's account.

 */
data class AuthorizationInfo (
    var `active`: kotlin.Boolean = false
    
) {
    
    companion object
}



/**
 * Parameters provided in an incoming OAuth request.
 *
 * This struct represents parameters obtained from an incoming OAuth request - that is,
 * the values that an OAuth client would append to the authorization URL when initiating
 * an OAuth sign-in flow.

 */
data class AuthorizationParameters (
    var `clientId`: kotlin.String = ""
    , 
    var `scope`: List<kotlin.String> = emptyList()
    , 
    var `state`: kotlin.String = ""
    , 
    var `accessType`: kotlin.String = ""
    , 
    var `codeChallenge`: kotlin.String? = null
    , 
    var `codeChallengeMethod`: kotlin.String? = null
    , 
    var `keysJwk`: kotlin.String? = null
    
) {
    
    companion object
}



/**
 * The payload sent when invoking a "close tabs" command.

 */
data class CloseTabsPayload (
    /**
     * The URLs of the tabs to close.
     */
    var `urls`: List<kotlin.String> = emptyList()
    
) {
    
    companion object
}



/**
 * A device connected to the user's account.
 *
 * This struct provides metadata about a device connected to the user's account.
 * This data would typically be used to display e.g. the list of candidate devices
 * in a "send tab" menu.

 */
data class Device (
    var `id`: kotlin.String = ""
    , 
    var `displayName`: kotlin.String = ""
    , 
    var `deviceType`: DeviceType = DeviceType.__NOOP
    , 
    var `capabilities`: List<DeviceCapability> = emptyList()
    , 
    var `pushSubscription`: DevicePushSubscription? = null
    , 
    var `pushEndpointExpired`: kotlin.Boolean = false
    , 
    var `isCurrentDevice`: kotlin.Boolean = false
    , 
    var `lastAccessTime`: kotlin.Long? = null
    
) {
    
    companion object
}



/**
 * Device configuration
 */
data class DeviceConfig (
    var `name`: kotlin.String = ""
    , 
    var `deviceType`: DeviceType = DeviceType.__NOOP
    , 
    var `capabilities`: List<DeviceCapability> = emptyList()
    
) {
    
    companion object
}



/**
 * Details of a web-push subscription endpoint.
 *
 * This struct encapsulates the details of a web-push subscription endpoint,
 * including all the information necessary to send a notification to its owner.
 * Devices attached to the user's account may register one of these in order
 * to receive timely updates about account-related events.
 *
 * Managing a web-push subscription is outside of the scope of this component.

 */
data class DevicePushSubscription (
    var `endpoint`: kotlin.String = ""
    , 
    var `publicKey`: kotlin.String = ""
    , 
    var `authKey`: kotlin.String = ""
    
) {
    
    companion object
}



data class FxaConfig (
    /**
     * FxaServer to connect with
     */
    var `server`: FxaServer = FxaServer.__NOOP
    , 
    /**
     * Registered OAuth client id of the application.
     */
    var `clientId`: kotlin.String = ""
    , 
    /**
     * `redirect_uri` - the registered OAuth redirect URI of the application.
     */
    var `redirectUri`: kotlin.String = ""
    , 
    /**
     * URL for the user's Sync Tokenserver. This can be used to support users who self-host their
     * sync data. If `None` then it will default to the Mozilla-hosted Sync server.
     */
    var `tokenServerUrlOverride`: kotlin.String? = null
    
) {
    
    companion object
}



/**
 * Local device that's connecting to FxA
 *
 * This is returned by the device update methods and represents the server's view of the local
 * device.
 */
data class LocalDevice (
    var `id`: kotlin.String = ""
    , 
    var `displayName`: kotlin.String = ""
    , 
    var `deviceType`: DeviceType = DeviceType.__NOOP
    , 
    var `capabilities`: List<DeviceCapability> = emptyList()
    , 
    var `pushSubscription`: DevicePushSubscription? = null
    , 
    var `pushEndpointExpired`: kotlin.Boolean = false
    
) {
    
    companion object
}



/**
 * Information about the user that controls a Firefox Account.
 *
 * This struct represents details about the user themselves, and would typically be
 * used to customize account-related UI in the browser so that it is personalize
 * for the current user.

 */
data class Profile (
    /**
     * The user's account uid
     *
     * This is an opaque immutable unique identifier for their account.
     */
    var `uid`: kotlin.String = ""
    , 
    /**
     * The user's current primary email address.
     *
     * Note that unlike the `uid` field, the email address may change over time.
     */
    var `email`: kotlin.String = ""
    , 
    /**
     * The user's preferred textual display name.
     */
    var `displayName`: kotlin.String? = null
    , 
    /**
     * The URL of a profile picture representing the user.
     *
     * All accounts have a corresponding profile picture. If the user has not
     * provided one then a default image is used.
     */
    var `avatar`: kotlin.String = ""
    , 
    /**
     * Whether the `avatar` URL represents the default avatar image.
     */
    var `isDefaultAvatar`: kotlin.Boolean = false
    
) {
    
    companion object
}



/**
 * A cryptographic key associated with an OAuth scope.
 *
 * Some OAuth scopes have a corresponding client-side encryption key that is required
 * in order to access protected data. This struct represents such key material in a
 * format compatible with the common "JWK" standard.

 */
data class ScopedKey (
    /**
     * The type of key.
     *
     * In practice for FxA, this will always be string string "oct" (short for "octal")
     * to represent a raw symmetric key.
     */
    var `kty`: kotlin.String = ""
    , 
    /**
     * The OAuth scope with which this key is associated.
     */
    var `scope`: kotlin.String = ""
    , 
    /**
     * The key material, as base64-url-encoded bytes.
     *
     * **⚠️ Warning:** the value of this field should never be revealed outside of the
     * application. For example, it should never to sent to a server or logged in a log file.
     */
    var `k`: kotlin.String = ""
    , 
    /**
     * An opaque unique identifier for this key.
     *
     * Unlike the `k` field, this value is not secret and may be revealed to the server.
     */
    var `kid`: kotlin.String = ""
    
) {
    
    companion object
}



/**
 * The payload sent when invoking a "send tab" command.

 */
data class SendTabPayload (
    /**
     * The navigation history of the sent tab.
     *
     * The last item in this list represents the page to be displayed,
     * while earlier items may be included in the navigation history
     * as a convenience to the user.
     */
    var `entries`: List<TabHistoryEntry> = emptyList()
    , 
    /**
     * A unique identifier to be included in send-tab metrics.
     *
     * The application should treat this as opaque.
     */
    var `flowId`: kotlin.String = ""
    , 
    /**
     * A unique identifier to be included in send-tab metrics.
     *
     * The application should treat this as opaque.
     */
    var `streamId`: kotlin.String = ""
    
) {
    
    companion object
}



/**
 * An individual entry in the navigation history of a sent tab.

 */
data class TabHistoryEntry (
    var `title`: kotlin.String = ""
    , 
    var `url`: kotlin.String = ""
    
) {
    
    companion object
}



data class UserData (
    var `sessionToken`: kotlin.String = ""
    , 
    var `uid`: kotlin.String = ""
    , 
    var `email`: kotlin.String = ""
    , 
    var `verified`: kotlin.Boolean = false
    
) {
    
    companion object
}



/**
 * An event that happened on the user's account.
 *
 * If the application has registered a [`DevicePushSubscription`] as part of its
 * device record, then the Firefox Accounts server can send push notifications
 * about important events that happen on the user's account. This enum represents
 * the different kinds of event that can occur.

 */
sealed class AccountEvent {
    
    /**
     * Sent when another device has invoked a command for this device to execute.
     *
     * When receiving this event, the application should inspect the contained
     * command and react appropriately.
     */
    data class CommandReceived(
        val `command`: IncomingDeviceCommand = IncomingDeviceCommand.__NOOP) : AccountEvent() {
        companion object
    }
    
    /**
     * Sent when the user has modified their account profile information.
     *
     * When receiving this event, the application should request fresh profile
     * information by calling [`get_profile`](FirefoxAccount::get_profile) with
     * `ignore_cache` set to true, and update any profile information displayed
     * in its UI.

     */
    object ProfileUpdated : AccountEvent()
    
    
    /**
     * Sent when when there has been a change in authorization status.
     *
     * When receiving this event, the application should check whether it is
     * still connected to the user's account by calling [`check_authorization_status`](
     * FirefoxAccount::check_authorization_status), and updating its UI as appropriate.

     */
    object AccountAuthStateChanged : AccountEvent()
    
    
    /**
     * Sent when the user deletes their Firefox Account.
     *
     * When receiving this event, the application should act as though the user had
     * signed out, discarding any persisted account state.
     */
    object AccountDestroyed : AccountEvent()
    
    
    /**
     * Sent when a new device connects to the user's account.
     *
     * When receiving this event, the application may use it to trigger an update
     * of any UI that shows the list of connected devices. It may also show the
     * user an informational notice about the new device, as a security measure.
     */
    data class DeviceConnected(
        val `deviceName`: kotlin.String = "") : AccountEvent() {
        companion object
    }
    
    /**
     * Sent when a device disconnects from the user's account.
     *
     * When receiving this event, the application may use it to trigger an update
     * of any UI that shows the list of connected devices.
     */
    data class DeviceDisconnected(
        val `deviceId`: kotlin.String = "", 
        val `isLocalDevice`: kotlin.Boolean = false) : AccountEvent() {
        companion object
    }
    
    /**
     * An unknown event, most likely an event the client doesn't support yet.
     *
     * When receiving this event, the application should gracefully ignore it.
     */
    object Unknown : AccountEvent()
    
    
    object __NOOP : AccountEvent()

    
    companion object
}





/**
 * The result of invoking a "close tabs" command.
 *
 * If [`FirefoxAccount::close_tabs`] is called with more URLs than can fit
 * into a single command payload, the URLs will be chunked and sent in
 * multiple commands.
 *
 * Chunking breaks the atomicity of a "close tabs" command, but
 * reduces the number of these commands that FxA sends to other devices.
 * This is critical for platforms like iOS, where every command triggers a
 * push message that must show a user-visible notification.
 */
sealed class CloseTabsResult {
    
    /**
     * All URLs passed to [`FirefoxAccount::close_tabs`] were chunked and sent
     * in one or more device commands.
     */
    object Ok : CloseTabsResult()
    
    
    /**
     * One or more URLs passed to [`FirefoxAccount::close_tabs`] couldn't be sent
     * in a device command. The caller can assume that:
     *
     * 1. Any URL in the returned list of `urls` was not sent, and
     *    should be retried.
     * 2. All other URLs that were passed to [`FirefoxAccount::close_tabs`], and
     *    that are _not_ in the list of `urls`, were chunked and sent.
     */
    data class TabsNotClosed(
        val `urls`: List<kotlin.String> = emptyList()) : CloseTabsResult() {
        companion object
    }
    
    object __NOOP : CloseTabsResult()

    
    companion object
}





/**
 * A "capability" offered by a device.
 *
 * In the FxA ecosystem, connected devices may advertize their ability to respond
 * to various "commands" that can be invoked by other devices. The details of
 * executing these commands are encapsulated as part of the FxA Client component,
 * so consumers simply need to select which ones they want to support, and can
 * use the variants of this enum to do so.

 */

enum class DeviceCapability {
    
    SEND_TAB,
    CLOSE_TABS,
    __NOOP;
    companion object
}








/**
 * Generic error type thrown by many [`FirefoxAccount`] operations.
 *
 * Precise details of the error are hidden from consumers, mostly due to limitations of
 * how we expose this API to other languages. The type of the error indicates how the
 * calling code should respond.

 */
sealed class FxaException(message: String = ""): kotlin.Exception(message) {
        
    /**
     * Thrown when there was a problem with the authentication status of the account,
     * such as an expired token. The application should [check its authorization status](
     * FirefoxAccount::check_authorization_status) to see whether it has been disconnected,
     * or retry the operation with a freshly-generated token.
     */
        class Authentication(message: String = "") : FxaException(message)
        
    /**
     * Thrown if an operation fails due to network access problems.
     * The application may retry at a later time once connectivity is restored.
     */
        class Network(message: String = "") : FxaException(message)
        
    /**
     * Thrown if the application attempts to complete an OAuth flow when no OAuth flow has been initiated for that state.
     * This may indicate a user who navigated directly to the OAuth `redirect_uri` for the application.
     */
        class NoExistingAuthFlow(message: String = "") : FxaException(message)
        
    /**
     * Thrown if the application attempts to complete an OAuth flow, but the state
     * tokens returned from the Firefox Account server do not match with the ones
     * expected by the client.
     * This may indicate a stale OAuth flow, or potentially an attempted hijacking
     * of the flow by an attacker. The signin attempt cannot be completed.
     *
     * **Note:** This error is currently only thrown in the Swift language bindings.
     */
        class WrongAuthFlow(message: String = "") : FxaException(message)
        
    /**
     * Origin mismatch when handling a pairing flow
     *
     * The most likely cause of this is that a user tried to pair together two firefox instances
     * that are configured to use different servers.
     */
        class OriginMismatch(message: String = "") : FxaException(message)
        
    /**
     * The sync scoped key was missing in the server response
     */
        class SyncScopedKeyMissingInServerResponse(message: String = "") : FxaException(message)
        
    /**
     * Thrown if there is a panic in the underlying Rust code.
     *
     * **Note:** This error is currently only thrown in the Kotlin language bindings.
     */
        class Panic(message: String = "") : FxaException(message)
        
    /**
     * A catch-all for other unspecified errors.
     */
        class Other(message: String = "") : FxaException(message)
        
}



sealed class FxaEvent {
    
    data class Initialize(
        val `deviceConfig`: DeviceConfig = DeviceConfig()) : FxaEvent() {
        companion object
    }
    
    data class BeginOAuthFlow(
        val `scopes`: List<kotlin.String> = emptyList(), 
        val `entrypoint`: kotlin.String = "") : FxaEvent() {
        companion object
    }
    
    data class BeginPairingFlow(
        val `pairingUrl`: kotlin.String = "", 
        val `scopes`: List<kotlin.String> = emptyList(), 
        val `entrypoint`: kotlin.String = "") : FxaEvent() {
        companion object
    }
    
    data class CompleteOAuthFlow(
        val `code`: kotlin.String = "", 
        val `state`: kotlin.String = "") : FxaEvent() {
        companion object
    }
    
    object CancelOAuthFlow : FxaEvent()
    
    
    object CheckAuthorizationStatus : FxaEvent()
    
    
    object Disconnect : FxaEvent()
    
    
    object CallGetProfile : FxaEvent()
    
    
    object __NOOP : FxaEvent()

    
    companion object
}






enum class FxaRustAuthState {
    
    DISCONNECTED,
    CONNECTED,
    AUTH_ISSUES,
    __NOOP;
    companion object
}






/**
 * FxA server to connect to
 */
sealed class FxaServer {
    
    object Release : FxaServer()
    
    
    object Stable : FxaServer()
    
    
    object Stage : FxaServer()
    
    
    object China : FxaServer()
    
    
    object LocalDev : FxaServer()
    
    
    data class Custom(
        val `url`: kotlin.String = "") : FxaServer() {
        companion object
    }
    
    object __NOOP : FxaServer()

    
    companion object
}





sealed class FxaState {
    
    object Uninitialized : FxaState()
    
    
    object Disconnected : FxaState()
    
    
    data class Authenticating(
        val `oauthUrl`: kotlin.String = "") : FxaState() {
        companion object
    }
    
    object Connected : FxaState()
    
    
    object AuthIssues : FxaState()
    
    
    object __NOOP : FxaState()

    
    companion object
}





sealed class FxaStateCheckerEvent {
    
    data class GetAuthStateSuccess(
        val `authState`: FxaRustAuthState = FxaRustAuthState.__NOOP) : FxaStateCheckerEvent() {
        companion object
    }
    
    data class BeginOAuthFlowSuccess(
        val `oauthUrl`: kotlin.String = "") : FxaStateCheckerEvent() {
        companion object
    }
    
    data class BeginPairingFlowSuccess(
        val `oauthUrl`: kotlin.String = "") : FxaStateCheckerEvent() {
        companion object
    }
    
    object CompleteOAuthFlowSuccess : FxaStateCheckerEvent()
    
    
    object InitializeDeviceSuccess : FxaStateCheckerEvent()
    
    
    object EnsureDeviceCapabilitiesSuccess : FxaStateCheckerEvent()
    
    
    data class CheckAuthorizationStatusSuccess(
        val `active`: kotlin.Boolean = false) : FxaStateCheckerEvent() {
        companion object
    }
    
    object DisconnectSuccess : FxaStateCheckerEvent()
    
    
    object GetProfileSuccess : FxaStateCheckerEvent()
    
    
    object CallError : FxaStateCheckerEvent()
    
    
    object EnsureCapabilitiesAuthError : FxaStateCheckerEvent()
    
    
    object __NOOP : FxaStateCheckerEvent()

    
    companion object
}





sealed class FxaStateCheckerState {
    
    object GetAuthState : FxaStateCheckerState()
    
    
    data class BeginOAuthFlow(
        val `scopes`: List<kotlin.String> = emptyList(), 
        val `entrypoint`: kotlin.String = "") : FxaStateCheckerState() {
        companion object
    }
    
    data class BeginPairingFlow(
        val `pairingUrl`: kotlin.String = "", 
        val `scopes`: List<kotlin.String> = emptyList(), 
        val `entrypoint`: kotlin.String = "") : FxaStateCheckerState() {
        companion object
    }
    
    data class CompleteOAuthFlow(
        val `code`: kotlin.String = "", 
        val `state`: kotlin.String = "") : FxaStateCheckerState() {
        companion object
    }
    
    object InitializeDevice : FxaStateCheckerState()
    
    
    object EnsureDeviceCapabilities : FxaStateCheckerState()
    
    
    object CheckAuthorizationStatus : FxaStateCheckerState()
    
    
    object Disconnect : FxaStateCheckerState()
    
    
    object GetProfile : FxaStateCheckerState()
    
    
    data class Complete(
        val `newState`: FxaState = FxaState.__NOOP) : FxaStateCheckerState() {
        companion object
    }
    
    object Cancel : FxaStateCheckerState()
    
    
    object __NOOP : FxaStateCheckerState()

    
    companion object
}





/**
 * A command invoked by another device.
 *
 * This enum represents all possible commands that can be invoked on
 * the device. It is the responsibility of the application to interpret
 * each command.

 */
sealed class IncomingDeviceCommand {
    
    /**
     * Indicates that a tab has been sent to this device.
     */
    data class TabReceived(
        val `sender`: Device? = null, 
        val `payload`: SendTabPayload = SendTabPayload()) : IncomingDeviceCommand() {
        companion object
    }
    
    /**
     * Indicates that the sender wants to close one or more tabs on this device.
     */
    data class TabsClosed(
        val `sender`: Device? = null, 
        val `payload`: CloseTabsPayload = CloseTabsPayload()) : IncomingDeviceCommand() {
        companion object
    }
    
    object __NOOP : IncomingDeviceCommand()

    
    companion object
}




























