// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("UNUSED_PARAMETER")

package mozilla.appservices.suggest
import mozilla.appservices.remotesettings.RemoteSettingsServer
import mozilla.appservices.remotesettings.RemoteSettingsService

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }



















/**
 * The store is the entry point to the Suggest component. It incrementally
 * downloads suggestions from the Remote Settings service, stores them in a
 * local database, and returns them in response to user queries.
 *
 * Your application should create a single store, and manage it as a singleton.
 * The store is thread-safe, and supports concurrent queries and ingests. We
 * expect that your application will call [`SuggestStore::query()`] to show
 * suggestions as the user types into the address bar, and periodically call
 * [`SuggestStore::ingest()`] in the background to update the database with
 * new suggestions from Remote Settings.
 *
 * For responsiveness, we recommend always calling `query()` on a worker
 * thread. When the user types new input into the address bar, call
 * [`SuggestStore::interrupt()`] on the main thread to cancel the query
 * for the old input, and unblock the worker thread for the new query.
 *
 * The store keeps track of the state needed to support incremental ingestion,
 * but doesn't schedule the ingestion work itself, or decide how many
 * suggestions to ingest at once. This is for two reasons:
 *
 * 1. The primitives for scheduling background work vary between platforms, and
 * aren't available to the lower-level Rust layer. You might use an idle
 * timer on Desktop, `WorkManager` on Android, or `BGTaskScheduler` on iOS.
 * 2. Ingestion constraints can change, depending on the platform and the needs
 * of your application. A mobile device on a metered connection might want
 * to request a small subset of the Suggest data and download the rest
 * later, while a desktop on a fast link might download the entire dataset
 * on the first launch.
 */
public interface SuggestStoreInterface {
    
    /**
     * Return whether any suggestions have been dismissed.
     */
    fun `anyDismissedSuggestions`(): kotlin.Boolean
    
    /**
     * Removes all content from the database.
     */
    fun `clear`()
    
    /**
     * Clear dismissed suggestions
     */
    fun `clearDismissedSuggestions`()
    
    /**
     * Dismiss a suggestion by its dismissal key.
     *
     * Dismissed suggestions cannot be fetched again.
     *
     * Prefer [SuggestStore::dismiss_by_suggestion] if you have a
     * `crate::Suggestion`. This method is intended for cases where a
     * suggestion originates outside this component.
     */
    fun `dismissByKey`(`key`: kotlin.String)
    
    /**
     * Dismiss a suggestion.
     *
     * Dismissed suggestions cannot be fetched again.
     */
    fun `dismissBySuggestion`(`suggestion`: Suggestion)
    
    /**
     * Deprecated, use [SuggestStore::dismiss_by_suggestion] or
     * [SuggestStore::dismiss_by_key] instead.
     *
     * Dismiss a suggestion
     *
     * Dismissed suggestions will not be returned again
     */
    fun `dismissSuggestion`(`suggestionUrl`: kotlin.String)
    
    /**
     * Fetches a geoname's names stored in the database.
     *
     * See `fetch_geoname_alternates` in `geoname.rs` for documentation.
     */
    fun `fetchGeonameAlternates`(`geoname`: Geoname): GeonameAlternates
    
    /**
     * Fetches geonames stored in the database. A geoname represents a
     * geographic place.
     *
     * See `fetch_geonames` in `geoname.rs` for documentation.
     */
    fun `fetchGeonames`(`query`: kotlin.String, `matchNamePrefix`: kotlin.Boolean, `filter`: List<Geoname>?): List<GeonameMatch>
    
    /**
     * Returns global Suggest configuration data.
     */
    fun `fetchGlobalConfig`(): SuggestGlobalConfig
    
    /**
     * Returns per-provider Suggest configuration data.
     */
    fun `fetchProviderConfig`(`provider`: SuggestionProvider): SuggestProviderConfig?
    
    /**
     * Ingests new suggestions from Remote Settings.
     */
    fun `ingest`(`constraints`: SuggestIngestionConstraints): SuggestIngestionMetrics
    
    /**
     * Interrupts any ongoing queries.
     *
     * This should be called when the user types new input into the address
     * bar, to ensure that they see fresh suggestions as they type. This
     * method does not interrupt any ongoing ingests.
     */
    fun `interrupt`(`kind`: InterruptKind? = null)
    
    /**
     * Return whether a suggestion has been dismissed given its dismissal key.
     *
     * [SuggestStore::query] will never return dismissed suggestions, so
     * normally you never need to know whether a suggestion has been dismissed.
     * This method is intended for cases where a dismissal key originates
     * outside this component.
     */
    fun `isDismissedByKey`(`key`: kotlin.String): kotlin.Boolean
    
    /**
     * Return whether a suggestion has been dismissed.
     *
     * [SuggestStore::query] will never return dismissed suggestions, so
     * normally you never need to know whether a `Suggestion` has been
     * dismissed, but this method can be used to do so.
     */
    fun `isDismissedBySuggestion`(`suggestion`: Suggestion): kotlin.Boolean
    
    /**
     * Queries the database for suggestions.
     */
    fun `query`(`query`: SuggestionQuery): List<Suggestion>
    
    /**
     * Queries the database for suggestions.
     */
    fun `queryWithMetrics`(`query`: SuggestionQuery): QueryWithMetricsResult
    
    companion object
}

/**
 * The store is the entry point to the Suggest component. It incrementally
 * downloads suggestions from the Remote Settings service, stores them in a
 * local database, and returns them in response to user queries.
 *
 * Your application should create a single store, and manage it as a singleton.
 * The store is thread-safe, and supports concurrent queries and ingests. We
 * expect that your application will call [`SuggestStore::query()`] to show
 * suggestions as the user types into the address bar, and periodically call
 * [`SuggestStore::ingest()`] in the background to update the database with
 * new suggestions from Remote Settings.
 *
 * For responsiveness, we recommend always calling `query()` on a worker
 * thread. When the user types new input into the address bar, call
 * [`SuggestStore::interrupt()`] on the main thread to cancel the query
 * for the old input, and unblock the worker thread for the new query.
 *
 * The store keeps track of the state needed to support incremental ingestion,
 * but doesn't schedule the ingestion work itself, or decide how many
 * suggestions to ingest at once. This is for two reasons:
 *
 * 1. The primitives for scheduling background work vary between platforms, and
 * aren't available to the lower-level Rust layer. You might use an idle
 * timer on Desktop, `WorkManager` on Android, or `BGTaskScheduler` on iOS.
 * 2. Ingestion constraints can change, depending on the platform and the needs
 * of your application. A mobile device on a metered connection might want
 * to request a small subset of the Suggest data and download the rest
 * later, while a desktop on a fast link might download the entire dataset
 * on the first launch.
 */
open class SuggestStore (private val `path`: kotlin.String = "", private val `remoteSettingsService`: RemoteSettingsService = RemoteSettingsService()
): AutoCloseable, Disposable, SuggestStoreInterface
{

    
    /**
     * Return whether any suggestions have been dismissed.
     */
    @Throws(SuggestApiException::class)override fun `anyDismissedSuggestions`(): kotlin.Boolean {
            return  false
    }

    
    /**
     * Removes all content from the database.
     */
    @Throws(SuggestApiException::class)override fun `clear`()
        {}

    
    /**
     * Clear dismissed suggestions
     */
    @Throws(SuggestApiException::class)override fun `clearDismissedSuggestions`()
        {}

    
    /**
     * Dismiss a suggestion by its dismissal key.
     *
     * Dismissed suggestions cannot be fetched again.
     *
     * Prefer [SuggestStore::dismiss_by_suggestion] if you have a
     * `crate::Suggestion`. This method is intended for cases where a
     * suggestion originates outside this component.
     */
    @Throws(SuggestApiException::class)override fun `dismissByKey`(`key`: kotlin.String)
        {}

    
    /**
     * Dismiss a suggestion.
     *
     * Dismissed suggestions cannot be fetched again.
     */
    @Throws(SuggestApiException::class)override fun `dismissBySuggestion`(`suggestion`: Suggestion)
        {}

    
    /**
     * Deprecated, use [SuggestStore::dismiss_by_suggestion] or
     * [SuggestStore::dismiss_by_key] instead.
     *
     * Dismiss a suggestion
     *
     * Dismissed suggestions will not be returned again
     */
    @Throws(SuggestApiException::class)override fun `dismissSuggestion`(`suggestionUrl`: kotlin.String)
        {}

    
    /**
     * Fetches a geoname's names stored in the database.
     *
     * See `fetch_geoname_alternates` in `geoname.rs` for documentation.
     */
    @Throws(SuggestApiException::class)override fun `fetchGeonameAlternates`(`geoname`: Geoname): GeonameAlternates {
            return  GeonameAlternates()
    }

    
    /**
     * Fetches geonames stored in the database. A geoname represents a
     * geographic place.
     *
     * See `fetch_geonames` in `geoname.rs` for documentation.
     */
    @Throws(SuggestApiException::class)override fun `fetchGeonames`(`query`: kotlin.String, `matchNamePrefix`: kotlin.Boolean, `filter`: List<Geoname>?): List<GeonameMatch> {
            return  emptyList()
    }

    
    /**
     * Returns global Suggest configuration data.
     */
    @Throws(SuggestApiException::class)override fun `fetchGlobalConfig`(): SuggestGlobalConfig {
            return  SuggestGlobalConfig()
    }

    
    /**
     * Returns per-provider Suggest configuration data.
     */
    @Throws(SuggestApiException::class)override fun `fetchProviderConfig`(`provider`: SuggestionProvider): SuggestProviderConfig? {
            return  null
    }

    
    /**
     * Ingests new suggestions from Remote Settings.
     */
    @Throws(SuggestApiException::class)override fun `ingest`(`constraints`: SuggestIngestionConstraints): SuggestIngestionMetrics {
            return  SuggestIngestionMetrics()
    }

    
    /**
     * Interrupts any ongoing queries.
     *
     * This should be called when the user types new input into the address
     * bar, to ensure that they see fresh suggestions as they type. This
     * method does not interrupt any ongoing ingests.
     */override fun `interrupt`(`kind`: InterruptKind?)
        {}

    
    /**
     * Return whether a suggestion has been dismissed given its dismissal key.
     *
     * [SuggestStore::query] will never return dismissed suggestions, so
     * normally you never need to know whether a suggestion has been dismissed.
     * This method is intended for cases where a dismissal key originates
     * outside this component.
     */
    @Throws(SuggestApiException::class)override fun `isDismissedByKey`(`key`: kotlin.String): kotlin.Boolean {
            return  false
    }

    
    /**
     * Return whether a suggestion has been dismissed.
     *
     * [SuggestStore::query] will never return dismissed suggestions, so
     * normally you never need to know whether a `Suggestion` has been
     * dismissed, but this method can be used to do so.
     */
    @Throws(SuggestApiException::class)override fun `isDismissedBySuggestion`(`suggestion`: Suggestion): kotlin.Boolean {
            return  false
    }

    
    /**
     * Queries the database for suggestions.
     */
    @Throws(SuggestApiException::class)override fun `query`(`query`: SuggestionQuery): List<Suggestion> {
            return  emptyList()
    }

    
    /**
     * Queries the database for suggestions.
     */
    @Throws(SuggestApiException::class)override fun `queryWithMetrics`(`query`: SuggestionQuery): QueryWithMetricsResult {
            return  QueryWithMetricsResult()
    }

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



/**
 * Builder for [SuggestStore]
 *
 * Using a builder is preferred to calling the constructor directly since it's harder to confuse
 * the data_path and cache_path strings.
 */
public interface SuggestStoreBuilderInterface {
    
    fun `build`(): SuggestStore
    
    /**
     * Deprecated: this is no longer used by the suggest component.
     */
    fun `cachePath`(`path`: kotlin.String): SuggestStoreBuilder
    
    fun `dataPath`(`path`: kotlin.String): SuggestStoreBuilder
    
    /**
     * Add an sqlite3 extension to load
     *
     * library_name should be the name of the library without any extension, for example `libmozsqlite3`.
     * entrypoint should be the entry point, for example `sqlite3_fts5_init`.  If `null` (the default)
     * entry point will be used (see https://sqlite.org/loadext.html for details).
     */
    fun `loadExtension`(`library`: kotlin.String, `entryPoint`: kotlin.String?): SuggestStoreBuilder
    
    fun `remoteSettingsBucketName`(`bucketName`: kotlin.String): SuggestStoreBuilder
    
    fun `remoteSettingsServer`(`server`: RemoteSettingsServer): SuggestStoreBuilder
    
    fun `remoteSettingsService`(`rsService`: RemoteSettingsService): SuggestStoreBuilder
    
    companion object
}

/**
 * Builder for [SuggestStore]
 *
 * Using a builder is preferred to calling the constructor directly since it's harder to confuse
 * the data_path and cache_path strings.
 */
open class SuggestStoreBuilder (
): AutoCloseable, Disposable, SuggestStoreBuilderInterface
{

    
    @Throws(SuggestApiException::class)override fun `build`(): SuggestStore {
            return  SuggestStore()
    }

    
    /**
     * Deprecated: this is no longer used by the suggest component.
     */override fun `cachePath`(`path`: kotlin.String): SuggestStoreBuilder {
            return  SuggestStoreBuilder()
    }

    override fun `dataPath`(`path`: kotlin.String): SuggestStoreBuilder {
            return  SuggestStoreBuilder()
    }

    
    /**
     * Add an sqlite3 extension to load
     *
     * library_name should be the name of the library without any extension, for example `libmozsqlite3`.
     * entrypoint should be the entry point, for example `sqlite3_fts5_init`.  If `null` (the default)
     * entry point will be used (see https://sqlite.org/loadext.html for details).
     */override fun `loadExtension`(`library`: kotlin.String, `entryPoint`: kotlin.String?): SuggestStoreBuilder {
            return  SuggestStoreBuilder()
    }

    override fun `remoteSettingsBucketName`(`bucketName`: kotlin.String): SuggestStoreBuilder {
            return  SuggestStoreBuilder()
    }

    override fun `remoteSettingsServer`(`server`: RemoteSettingsServer): SuggestStoreBuilder {
            return  SuggestStoreBuilder()
    }

    override fun `remoteSettingsService`(`rsService`: RemoteSettingsService): SuggestStoreBuilder {
            return  SuggestStoreBuilder()
    }

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



/**
 * A set of names for a single entity.
 */
data class AlternateNames (
    /**
     * The entity's primary name. For a `Geoname`, this is `Geoname::name`.
     */
    var `primary`: kotlin.String = ""
    , 
    /**
     * The entity's name in the language that was ingested according to the
     * locale in the remote settings context. If none exists and this
     * `AlternateNames` is for a `Geoname`, then this will be its primary name.
     */
    var `localized`: kotlin.String? = null
    , 
    /**
     * The entity's abbreviation, if any.
     */
    var `abbreviation`: kotlin.String? = null
    
) {
    
    companion object
}



/**
 * Additional data about how an FTS match was made
 */
data class FtsMatchInfo (
    /**
     * Was this a prefix match (`water b` matched against `water bottle`)
     */
    var `prefix`: kotlin.Boolean = false
    , 
    /**
     * Did the match require stemming? (`run shoes` matched against `running shoes`)
     */
    var `stemming`: kotlin.Boolean = false
    
) {
    
    companion object
}



/**
 * A single geographic place.
 *
 * This corresponds to a single row in the main "geoname" table described in
 * the GeoNames documentation [1]. We exclude fields we don't need.
 *
 * [1]: https://download.geonames.org/export/dump/readme.txt
 */
data class Geoname (
    /**
     * The `geonameid` straight from the geoname table.
     */
    var `geonameId`: kotlin.Long = 0L
    , 
    /**
     * The geoname type. This is derived from `feature_class` and
     * `feature_code` as a more convenient representation of the type.
     */
    var `geonameType`: GeonameType = GeonameType.__NOOP
    , 
    /**
     * The place's primary name.
     */
    var `name`: kotlin.String = ""
    , 
    /**
     * ISO-3166 two-letter uppercase country code, e.g., "US".
     */
    var `countryCode`: kotlin.String = ""
    , 
    /**
     * Primary geoname category. Examples:
     *
     * "PCLI" - Independent political entity: country
     * "A" - Administrative division: state, province, borough, district, etc.
     * "P" - Populated place: city, village, etc.
     */
    var `featureClass`: kotlin.String = ""
    , 
    /**
     * Secondary geoname category, depends on `feature_class`. Examples:
     *
     * "ADM1" - Administrative division 1
     * "PPL" - Populated place like a city
     */
    var `featureCode`: kotlin.String = ""
    , 
    /**
     * Administrative divisions. This maps admin division levels (1-based) to
     * their corresponding codes. For example, Liverpool has two admin
     * divisions: "ENG" at level 1 and "H8" at level 2. They would be
     * represented in this map with entries `(1, "ENG")` and `(2, "H8")`.
     */
    var `adminDivisionCodes`: Map<kotlin.UByte, kotlin.String> = emptyMap()
    , 
    /**
     * Population size.
     */
    var `population`: kotlin.ULong = 0uL
    , 
    /**
     * Latitude in decimal degrees (as a string).
     */
    var `latitude`: kotlin.String = ""
    , 
    /**
     * Longitude in decimal degrees (as a string).
     */
    var `longitude`: kotlin.String = ""
    
) {
    
    companion object
}



/**
 * Alternate names for a geoname and its country and admin divisions.
 */
data class GeonameAlternates (
    /**
     * Names for the geoname itself.
     */
    var `geoname`: AlternateNames = AlternateNames()
    , 
    /**
     * Names for the geoname's country. This will be `Some` as long as the
     * country is also in the ingested data, which should typically be true.
     */
    var `country`: AlternateNames? = null
    , 
    /**
     * Names for the geoname's admin divisions. This is parallel to
     * `Geoname::admin_division_codes`. If there are no names in the ingested
     * data for an admin division, then it will be absent from this map.
     */
    var `adminDivisions`: Map<kotlin.UByte, AlternateNames> = emptyMap()
    
) {
    
    companion object
}



/**
 * A fetched geoname with info on how it was matched.
 */
data class GeonameMatch (
    /**
     * The geoname that was matched.
     */
    var `geoname`: Geoname = Geoname()
    , 
    /**
     * The type of name that was matched.
     */
    var `matchType`: GeonameMatchType = GeonameMatchType.__NOOP
    , 
    /**
     * Whether the name was matched by prefix.
     */
    var `prefix`: kotlin.Boolean = false
    
) {
    
    companion object
}



/**
 * Single sample for a Glean labeled_timing_distribution
 */
data class LabeledTimingSample (
    var `label`: kotlin.String = ""
    , 
    /**
     * Time in microseconds
     */
    var `value`: kotlin.ULong = 0uL
    
) {
    
    companion object
}



data class QueryWithMetricsResult (
    var `suggestions`: List<Suggestion> = emptyList()
    , 
    /**
     * Samples for the `suggest.query_time` metric
     */
    var `queryTimes`: List<LabeledTimingSample> = emptyList()
    
) {
    
    companion object
}



/**
 * Global Suggest configuration data.
 */
data class SuggestGlobalConfig (
    var `showLessFrequentlyCap`: kotlin.Int = 0
    
) {
    
    companion object
}



/**
 * Constraints limit which suggestions to ingest from Remote Settings.
 */
data class SuggestIngestionConstraints (
    var `providers`: List<SuggestionProvider>? = null
    , 
    var `providerConstraints`: SuggestionProviderConstraints? = null
    , 
    /**
     * Only run ingestion if the table `suggestions` is empty

     */
    var `emptyOnly`: kotlin.Boolean = false
    
) {
    
    companion object
}



/**
 * Ingestion metrics
 *
 * These are recorded during [crate::Store::ingest] and returned to the consumer to record.
 */
data class SuggestIngestionMetrics (
    /**
     * Samples for the `suggest.ingestion_time` metric
     */
    var `ingestionTimes`: List<LabeledTimingSample> = emptyList()
    , 
    /**
     * Samples for the `suggest.ingestion_download_time` metric
     */
    var `downloadTimes`: List<LabeledTimingSample> = emptyList()
    
) {
    
    companion object
}



/**
 * Some providers manage multiple suggestion subtypes. Queries, ingests, and
 * other operations on those providers must be constrained to a desired subtype.
 */
data class SuggestionProviderConstraints (
    /**
     * Which dynamic suggestions should we fetch or ingest? Corresponds to the
     * `suggestion_type` value in dynamic suggestions remote settings records.
     */
    var `dynamicSuggestionTypes`: List<kotlin.String>? = null
    , 
    /**
     * Which strategy should we use for the AMP queries?
     * Use None for the default strategy.
     */
    var `ampAlternativeMatching`: AmpMatchingStrategy? = null
    
) {
    
    companion object
}



/**
 * A query for suggestions to show in the address bar.
 */
data class SuggestionQuery (
    var `keyword`: kotlin.String = ""
    , 
    var `providers`: List<SuggestionProvider> = emptyList()
    , 
    var `providerConstraints`: SuggestionProviderConstraints? = null
    , 
    var `limit`: kotlin.Int? = null
    
) {
    
    companion object
}




enum class AmpMatchingStrategy {
    
    /**
     * Disable keywords added via keyword expansion.
     * This eliminates keywords that for terms related to the "real" keywords, for example
     * misspellings like "underarmor" instead of "under armor"'.
     */
    NO_KEYWORD_EXPANSION,
    /**
     * Use FTS matching against the full keywords, joined together.
     */
    FTS_AGAINST_FULL_KEYWORDS,
    /**
     * Use FTS matching against the title field
     */
    FTS_AGAINST_TITLE,
    __NOOP;
    companion object
}







enum class GeonameMatchType {
    
    ABBREVIATION,
    AIRPORT_CODE,
    /**
     * This includes any names that aren't abbreviations or airport codes.
     */
    NAME,
    __NOOP;
    companion object
}






/**
 * The type of a geoname.
 */
sealed class GeonameType {
    
    object Country : GeonameType()
    
    
    /**
     * A state, province, prefecture, district, borough, etc.
     */
    data class AdminDivision(
        val `level`: kotlin.UByte = 0.toUByte()) : GeonameType() {
        companion object
    }
    
    object AdminDivisionOther : GeonameType()
    
    
    /**
     * A city, town, village, populated place, etc.
     */
    object City : GeonameType()
    
    
    object Other : GeonameType()
    
    
    object __NOOP : GeonameType()

    
    companion object
}





/**
 * What should be interrupted when [SuggestStore::interrupt] is called?
 */

enum class InterruptKind {
    
    /**
     * Interrupt read operations like [SuggestStore::query]
     */
    READ,
    /**
     * Interrupt write operations.  This mostly means [SuggestStore::ingest], but
     * other operations may also be interrupted.
     */
    WRITE,
    /**
     * Interrupt both read and write operations,
     */
    READ_WRITE,
    __NOOP;
    companion object
}








/**
 * The error type for all Suggest component operations. These errors are
 * exposed to your application, which should handle them as needed.
 */
sealed class SuggestApiException: kotlin.Exception() {
    
    class Network(
        
        val `reason`: kotlin.String = ""
        ) : SuggestApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    /**
     * The server requested a backoff after too many requests
     */
    class Backoff(
        
        val `seconds`: kotlin.ULong = 0uL
        ) : SuggestApiException() {
        override val message
            get() = "seconds=${ `seconds` }"
    }
    
    /**
     * An operation was interrupted by calling `SuggestStore.interrupt()`
     */
    class Interrupted(
        ) : SuggestApiException() {
        override val message
            get() = ""
    }
    
    class Other(
        
        val `reason`: kotlin.String = ""
        ) : SuggestApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    

    
}



/**
 * Per-provider configuration data.
 */
sealed class SuggestProviderConfig {
    
    data class Weather(
        /**
         * Weather suggestion score.
         */
        val `score`: kotlin.Double = 0.0, 
        /**
         * Threshold for weather keyword prefix matching when a weather keyword
         * is the first term in a query. Zero means prefix matching is disabled
         * and weather keywords must be typed in full when they are first in
         * the query. (Ideally this would be an `Option` and `None` would mean
         * full keywords are required, but it's probably not worth the breaking
         * API change.) This threshold does not apply to city and region names.
         */
        val `minKeywordLength`: kotlin.Int = 0) : SuggestProviderConfig() {
        companion object
    }
    
    object __NOOP : SuggestProviderConfig()

    
    companion object
}





/**
 * A suggestion from the database to show in the address bar.
 */
sealed class Suggestion {
    
    data class Amp(
        val `title`: kotlin.String = "", 
        val `url`: kotlin.String = "", 
        val `rawUrl`: kotlin.String = "", 
        val `icon`: kotlin.ByteArray? = null, 
        val `iconMimetype`: kotlin.String? = null, 
        val `fullKeyword`: kotlin.String = "", 
        val `blockId`: kotlin.Long = 0L, 
        val `advertiser`: kotlin.String = "", 
        val `iabCategory`: kotlin.String = "", 
        val `impressionUrl`: kotlin.String = "", 
        val `clickUrl`: kotlin.String = "", 
        val `rawClickUrl`: kotlin.String = "", 
        val `score`: kotlin.Double = 0.0, 
        val `ftsMatchInfo`: FtsMatchInfo? = null) : Suggestion() {
        companion object
    }
    
    data class Pocket(
        val `title`: kotlin.String = "", 
        val `url`: kotlin.String = "", 
        val `score`: kotlin.Double = 0.0, 
        val `isTopPick`: kotlin.Boolean = false) : Suggestion() {
        companion object
    }
    
    data class Wikipedia(
        val `title`: kotlin.String = "", 
        val `url`: kotlin.String = "", 
        val `icon`: kotlin.ByteArray? = null, 
        val `iconMimetype`: kotlin.String? = null, 
        val `fullKeyword`: kotlin.String = "") : Suggestion() {
        companion object
    }
    
    data class Amo(
        val `title`: kotlin.String = "", 
        val `url`: kotlin.String = "", 
        val `iconUrl`: kotlin.String = "", 
        val `description`: kotlin.String = "", 
        val `rating`: kotlin.String? = null, 
        val `numberOfRatings`: kotlin.Long = 0L, 
        val `guid`: kotlin.String = "", 
        val `score`: kotlin.Double = 0.0) : Suggestion() {
        companion object
    }
    
    data class Yelp(
        val `url`: kotlin.String = "", 
        val `title`: kotlin.String = "", 
        val `icon`: kotlin.ByteArray? = null, 
        val `iconMimetype`: kotlin.String? = null, 
        val `score`: kotlin.Double = 0.0, 
        val `hasLocationSign`: kotlin.Boolean = false, 
        val `subjectExactMatch`: kotlin.Boolean = false, 
        val `subjectType`: YelpSubjectType = YelpSubjectType.__NOOP, 
        val `locationParam`: kotlin.String = "") : Suggestion() {
        companion object
    }
    
    data class Mdn(
        val `title`: kotlin.String = "", 
        val `url`: kotlin.String = "", 
        val `description`: kotlin.String = "", 
        val `score`: kotlin.Double = 0.0) : Suggestion() {
        companion object
    }
    
    data class Weather(
        val `city`: Geoname? = null, 
        val `score`: kotlin.Double = 0.0) : Suggestion() {
        companion object
    }
    
    data class Fakespot(
        val `fakespotGrade`: kotlin.String = "", 
        val `productId`: kotlin.String = "", 
        val `rating`: kotlin.Double = 0.0, 
        val `title`: kotlin.String = "", 
        val `totalReviews`: kotlin.Long = 0L, 
        val `url`: kotlin.String = "", 
        val `icon`: kotlin.ByteArray? = null, 
        val `iconMimetype`: kotlin.String? = null, 
        val `score`: kotlin.Double = 0.0, 
        val `matchInfo`: FtsMatchInfo? = null) : Suggestion() {
        companion object
    }
    
    data class Dynamic(
        val `suggestionType`: kotlin.String = "", 
        val `data`: JsonValue? = null, 
        /**
         * This value is optionally defined in the suggestion's remote settings
         * data and is an opaque token used for dismissing the suggestion in
         * lieu of a URL. If `Some`, the suggestion can be dismissed by passing
         * the wrapped string to [crate::SuggestStore::dismiss_suggestion].
         */
        val `dismissalKey`: kotlin.String? = null, 
        val `score`: kotlin.Double = 0.0) : Suggestion() {
        companion object
    }
    
    object __NOOP : Suggestion()

    
    companion object
}





/**
 * A provider is a source of search suggestions.
 */

enum class SuggestionProvider(val value: kotlin.UByte) {
    
    AMP(1u),
    WIKIPEDIA(2u),
    AMO(3u),
    POCKET(4u),
    YELP(5u),
    MDN(6u),
    WEATHER(7u),
    FAKESPOT(8u),
    DYNAMIC(9u),
    __NOOP(0.toUByte());
    companion object
}






/**
 * Subject type for Yelp suggestion.
 */

enum class YelpSubjectType(val value: kotlin.UByte) {
    
    SERVICE(0u),
    BUSINESS(1u),
    __NOOP(0.toUByte());
    companion object
}


















































/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 * It's also what we have an external type that references a custom type.
 */
public typealias JsonValue = kotlin.String


        /**
         * Determines whether a "raw" sponsored suggestion URL is equivalent to a
         * "cooked" URL. The two URLs are equivalent if they are identical except for
         * their replaced template parameters, which can be different.
         */ fun `rawSuggestionUrlMatches`(`rawUrl`: kotlin.String, `cookedUrl`: kotlin.String): kotlin.Boolean {
            return  false
    }


