// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("UNUSED_PARAMETER")

package mozilla.appservices.crashtest

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }







/**
 * An error that can be returned from Rust code.
 */
sealed class CrashTestException(message: String = ""): kotlin.Exception(message) {
        
        class ErrorFromTheRustCode(message: String = "") : CrashTestException(message)
        
}
        /**
         * Trigger a hard abort inside the Rust code.
         *
         * This function simulates some kind of uncatchable illegal operation
         * performed inside the Rust code. After calling this function you should
         * expect your application to be halted with e.g. a `SIGABRT` or similar.

         */ fun `triggerRustAbort`()
        {}

        /**
         * Trigger an error inside the Rust code.
         *
         * This function simulates the occurrence of an expected error inside
         * the Rust code. You should expect calling this function to throw the
         * foreign-language representation of the [`CrashTestError`] class.

         */
    @Throws(CrashTestException::class) fun `triggerRustError`()
        {}

        /**
         * Trigger a panic inside the Rust code.
         *
         * This function simulates the occurrence of an unexpected state inside
         * the Rust code that causes it to panic. We build our Rust components to
         * unwind on panic, so after calling this function through the foreign
         * language bindings, you should expect it to intercept the panic translate
         * it into some foreign-language-appropriate equivalent:
         *
         *  - In Kotlin, it will throw an exception.
         *  - In Swift, it will fail with a `try!` runtime error.

         */ fun `triggerRustPanic`()
        {}


