// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("UNUSED_PARAMETER")

package mozilla.appservices.autofill

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }









public interface StoreInterface {
    
    fun `addAddress`(`a`: UpdatableAddressFields): Address
    
    fun `addCreditCard`(`cc`: UpdatableCreditCardFields): CreditCard
    
    fun `deleteAddress`(`guid`: kotlin.String): kotlin.Boolean
    
    fun `deleteCreditCard`(`guid`: kotlin.String): kotlin.Boolean
    
    fun `getAddress`(`guid`: kotlin.String): Address
    
    fun `getAllAddresses`(): List<Address>
    
    fun `getAllCreditCards`(): List<CreditCard>
    
    fun `getCreditCard`(`guid`: kotlin.String): CreditCard
    
    fun `registerWithSyncManager`()
    
    fun `scrubEncryptedData`()
    
    fun `touchAddress`(`guid`: kotlin.String)
    
    fun `touchCreditCard`(`guid`: kotlin.String)
    
    fun `updateAddress`(`guid`: kotlin.String, `a`: UpdatableAddressFields)
    
    fun `updateCreditCard`(`guid`: kotlin.String, `cc`: UpdatableCreditCardFields)
    
    companion object
}

open class Store (private val `dbpath`: kotlin.String = ""
): AutoCloseable, Disposable, StoreInterface
{

    
    @Throws(AutofillApiException::class)override fun `addAddress`(`a`: UpdatableAddressFields): Address {
            return  Address()
    }

    
    @Throws(AutofillApiException::class)override fun `addCreditCard`(`cc`: UpdatableCreditCardFields): CreditCard {
            return  CreditCard()
    }

    
    @Throws(AutofillApiException::class)override fun `deleteAddress`(`guid`: kotlin.String): kotlin.Boolean {
            return  false
    }

    
    @Throws(AutofillApiException::class)override fun `deleteCreditCard`(`guid`: kotlin.String): kotlin.Boolean {
            return  false
    }

    
    @Throws(AutofillApiException::class)override fun `getAddress`(`guid`: kotlin.String): Address {
            return  Address()
    }

    
    @Throws(AutofillApiException::class)override fun `getAllAddresses`(): List<Address> {
            return  emptyList()
    }

    
    @Throws(AutofillApiException::class)override fun `getAllCreditCards`(): List<CreditCard> {
            return  emptyList()
    }

    
    @Throws(AutofillApiException::class)override fun `getCreditCard`(`guid`: kotlin.String): CreditCard {
            return  CreditCard()
    }

    override fun `registerWithSyncManager`()
        {}

    
    @Throws(AutofillApiException::class)override fun `scrubEncryptedData`()
        {}

    
    @Throws(AutofillApiException::class)override fun `touchAddress`(`guid`: kotlin.String)
        {}

    
    @Throws(AutofillApiException::class)override fun `touchCreditCard`(`guid`: kotlin.String)
        {}

    
    @Throws(AutofillApiException::class)override fun `updateAddress`(`guid`: kotlin.String, `a`: UpdatableAddressFields)
        {}

    
    @Throws(AutofillApiException::class)override fun `updateCreditCard`(`guid`: kotlin.String, `cc`: UpdatableCreditCardFields)
        {}

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



/**
 * What you get back as an address.
 */
data class Address (
    var `guid`: kotlin.String = ""
    , 
    var `name`: kotlin.String = ""
    , 
    var `organization`: kotlin.String = ""
    , 
    var `streetAddress`: kotlin.String = ""
    , 
    var `addressLevel3`: kotlin.String = ""
    , 
    var `addressLevel2`: kotlin.String = ""
    , 
    var `addressLevel1`: kotlin.String = ""
    , 
    var `postalCode`: kotlin.String = ""
    , 
    var `country`: kotlin.String = ""
    , 
    var `tel`: kotlin.String = ""
    , 
    var `email`: kotlin.String = ""
    , 
    var `timeCreated`: kotlin.Long = 0L
    , 
    var `timeLastUsed`: kotlin.Long? = null
    , 
    var `timeLastModified`: kotlin.Long = 0L
    , 
    var `timesUsed`: kotlin.Long = 0L
    
) {
    
    companion object
}



/**
 * What you get back as a credit-card.
 */
data class CreditCard (
    var `guid`: kotlin.String = ""
    , 
    var `ccName`: kotlin.String = ""
    , 
    var `ccNumberEnc`: kotlin.String = ""
    , 
    var `ccNumberLast4`: kotlin.String = ""
    , 
    var `ccExpMonth`: kotlin.Long = 0L
    , 
    var `ccExpYear`: kotlin.Long = 0L
    , 
    var `ccType`: kotlin.String = ""
    , 
    var `timeCreated`: kotlin.Long = 0L
    , 
    var `timeLastUsed`: kotlin.Long? = null
    , 
    var `timeLastModified`: kotlin.Long = 0L
    , 
    var `timesUsed`: kotlin.Long = 0L
    
) {
    
    companion object
}



/**
 * What you pass to create or update an address.
 */
data class UpdatableAddressFields (
    var `name`: kotlin.String = ""
    , 
    var `organization`: kotlin.String = ""
    , 
    var `streetAddress`: kotlin.String = ""
    , 
    var `addressLevel3`: kotlin.String = ""
    , 
    var `addressLevel2`: kotlin.String = ""
    , 
    var `addressLevel1`: kotlin.String = ""
    , 
    var `postalCode`: kotlin.String = ""
    , 
    var `country`: kotlin.String = ""
    , 
    var `tel`: kotlin.String = ""
    , 
    var `email`: kotlin.String = ""
    
) {
    
    companion object
}



/**
 * What you pass to create or update a credit-card.
 */
data class UpdatableCreditCardFields (
    var `ccName`: kotlin.String = ""
    , 
    var `ccNumberEnc`: kotlin.String = ""
    , 
    var `ccNumberLast4`: kotlin.String = ""
    , 
    var `ccExpMonth`: kotlin.Long = 0L
    , 
    var `ccExpYear`: kotlin.Long = 0L
    , 
    var `ccType`: kotlin.String = ""
    
) {
    
    companion object
}





sealed class AutofillApiException: kotlin.Exception() {
    
    class SqlException(
        
        val `reason`: kotlin.String = ""
        ) : AutofillApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    class InterruptedException(
        ) : AutofillApiException() {
        override val message
            get() = ""
    }
    
    class CryptoException(
        
        val `reason`: kotlin.String = ""
        ) : AutofillApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    class NoSuchRecord(
        
        val `guid`: kotlin.String = ""
        ) : AutofillApiException() {
        override val message
            get() = "guid=${ `guid` }"
    }
    
    class UnexpectedAutofillApiException(
        
        val `reason`: kotlin.String = ""
        ) : AutofillApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    

    
}






        /**
         * Create a new, random, encryption key.
         */
    @Throws(AutofillApiException::class) fun `createAutofillKey`(): kotlin.String {
            return  ""
    }

        /**
         * Decrypt an arbitrary string - `key` must have come from `create_key()`
         * and `ciphertext` must have come from `encrypt_string()`
         */
    @Throws(AutofillApiException::class) fun `decryptString`(`key`: kotlin.String, `ciphertext`: kotlin.String): kotlin.String {
            return  ""
    }

        /**
         * Encrypt an arbitrary string - `key` must have come from `create_key()`
         */
    @Throws(AutofillApiException::class) fun `encryptString`(`key`: kotlin.String, `cleartext`: kotlin.String): kotlin.String {
            return  ""
    }


