// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("UNUSED_PARAMETER")

package mozilla.appservices.search
import mozilla.appservices.remotesettings.RemoteSettingsService

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }









/**
 * SearchEngineSelector parses the JSON configuration for
 * search engines and returns the applicable engines depending
 * on their region + locale.
 */
public interface SearchEngineSelectorInterface {
    
    /**
     * Clears the search configuration from memory if it is known that it is
     * not required for a time, e.g. if the configuration will only be re-filtered
     * after an app/environment update.
     */
    fun `clearSearchConfig`()
    
    /**
     * Filters the search configuration with the user's given environment,
     * and returns the set of engines and parameters that should be presented
     * to the user.
     */
    fun `filterEngineConfiguration`(`userEnvironment`: SearchUserEnvironment): RefinedSearchConfig
    
    fun `setConfigOverrides`(`overrides`: kotlin.String)
    
    /**
     * Sets the search configuration from the given string. If the configuration
     * string is unchanged since the last update, the cached configuration is
     * reused to avoid unnecessary reprocessing. This helps optimize performance,
     * particularly during test runs where the same configuration may be used
     * repeatedly.
     */
    fun `setSearchConfig`(`configuration`: kotlin.String)
    
    /**
     * Sets the RemoteSettingsService to use. The selector will create the
     * relevant remote settings client(s) from the service.
     *
     * # Params:
     * - `service`: The remote settings service instance for the application.
     * - `options`: The remote settings options to be passed to the client(s).
     * - `apply_engine_overrides`: Whether or not to apply overrides from
     * `search-config-v2-overrides` to the selected
     * engines. Should be false unless the application
     * supports the click URL feature.
     */
    fun `useRemoteSettingsServer`(`service`: RemoteSettingsService, `applyEngineOverrides`: kotlin.Boolean)
    
    companion object
}

/**
 * SearchEngineSelector parses the JSON configuration for
 * search engines and returns the applicable engines depending
 * on their region + locale.
 */
open class SearchEngineSelector (
): AutoCloseable, Disposable, SearchEngineSelectorInterface
{

    
    /**
     * Clears the search configuration from memory if it is known that it is
     * not required for a time, e.g. if the configuration will only be re-filtered
     * after an app/environment update.
     */override fun `clearSearchConfig`()
        {}

    
    /**
     * Filters the search configuration with the user's given environment,
     * and returns the set of engines and parameters that should be presented
     * to the user.
     */
    @Throws(SearchApiException::class)override fun `filterEngineConfiguration`(`userEnvironment`: SearchUserEnvironment): RefinedSearchConfig {
            return  RefinedSearchConfig()
    }

    
    @Throws(SearchApiException::class)override fun `setConfigOverrides`(`overrides`: kotlin.String)
        {}

    
    /**
     * Sets the search configuration from the given string. If the configuration
     * string is unchanged since the last update, the cached configuration is
     * reused to avoid unnecessary reprocessing. This helps optimize performance,
     * particularly during test runs where the same configuration may be used
     * repeatedly.
     */
    @Throws(SearchApiException::class)override fun `setSearchConfig`(`configuration`: kotlin.String)
        {}

    
    /**
     * Sets the RemoteSettingsService to use. The selector will create the
     * relevant remote settings client(s) from the service.
     *
     * # Params:
     * - `service`: The remote settings service instance for the application.
     * - `options`: The remote settings options to be passed to the client(s).
     * - `apply_engine_overrides`: Whether or not to apply overrides from
     * `search-config-v2-overrides` to the selected
     * engines. Should be false unless the application
     * supports the click URL feature.
     */override fun `useRemoteSettingsServer`(`service`: RemoteSettingsService, `applyEngineOverrides`: kotlin.Boolean)
        {}

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



/**
 * Defines an individual search engine URL. This is defined separately to
 * `types::SearchEngineUrl` as various fields may be optional in the supplied
 * configuration.
 */
data class JsonEngineUrl (
    /**
     * The PrePath and FilePath of the URL. May include variables for engines
     * which have a variable FilePath, e.g. `{searchTerms}` for when a search
     * term is within the path of the url.
     */
    var `base`: kotlin.String? = null
    , 
    /**
     * The HTTP method to use to send the request (`GET` or `POST`).
     * If the engine definition has not specified the method, it defaults to GET.
     */
    var `method`: JsonEngineMethod? = null
    , 
    /**
     * The parameters for this URL.
     */
    var `params`: List<SearchUrlParam>? = null
    , 
    /**
     * The name of the query parameter for the search term. Automatically
     * appended to the end of the query. This may be skipped if `{searchTerms}`
     * is included in the base.
     */
    var `searchTermParamName`: kotlin.String? = null
    
) {
    
    companion object
}



/**
 * Reflects `types::SearchEngineUrls`, but using `EngineUrl`.
 */
data class JsonEngineUrls (
    /**
     * The URL to use for searches.
     */
    var `search`: JsonEngineUrl? = null
    , 
    /**
     * The URL to use for suggestions.
     */
    var `suggestions`: JsonEngineUrl? = null
    , 
    /**
     * The URL to use for trending suggestions.
     */
    var `trending`: JsonEngineUrl? = null
    , 
    /**
     * The URL of the search engine homepage.
     */
    var `searchForm`: JsonEngineUrl? = null
    
) {
    
    companion object
}



/**
 * Details of the search engines to display to the user, generated as a result
 * of processing the search configuration.
 */
data class RefinedSearchConfig (
    /**
     * A sorted list of engines. Clients may use the engine in the order that
     * this list is specified, or they may implement their own order if they
     * have other requirements.
     *
     * The application default engines should not be assumed from this order in
     * case of future changes.
     *
     * The sort order is:
     *
     * * Application Default Engine
     * * Application Default Engine for Private Mode (if specified & different)
     * * Engines sorted by descending `SearchEngineDefinition.orderHint`
     * * Any other engines in alphabetical order (locale based comparison)
     */
    var `engines`: List<SearchEngineDefinition> = emptyList()
    , 
    /**
     * The identifier of the engine that should be used for the application
     * default engine. If this is undefined, an error has occurred, and the
     * application should either default to the first engine in the engines
     * list or otherwise handle appropriately.
     */
    var `appDefaultEngineId`: kotlin.String? = null
    , 
    /**
     * If specified, the identifier of the engine that should be used for the
     * application default engine in private browsing mode.
     * Only desktop uses this currently.
     */
    var `appPrivateDefaultEngineId`: kotlin.String? = null
    
) {
    
    companion object
}



/**
 * A definition for an individual search engine to be presented to the user.
 */
data class SearchEngineDefinition (
    /**
     * A list of aliases for this engine.
     */
    var `aliases`: List<kotlin.String> = emptyList()
    , 
    /**
     * The character set this engine uses for queries.
     */
    var `charset`: kotlin.String = ""
    , 
    /**
     * The classification of search engine according to the main search types
     * (e.g. general, shopping, travel, dictionary). Currently, only marking as
     * a general search engine is supported.
     * On Android, only general search engines may be selected as "default"
     * search engines.
     */
    var `classification`: SearchEngineClassification = SearchEngineClassification.__NOOP
    , 
    /**
     * The identifier of the search engine. This is used as an internal
     * identifier, e.g. for saving the user's settings for the engine. It is
     * also used to form the base telemetry id and may be extended by telemetrySuffix.
     */
    var `identifier`: kotlin.String = ""
    , 
    /**
     * The user visible name of the search engine.
     */
    var `name`: kotlin.String = ""
    , 
    /**
     * This search engine is presented as an option that the user may enable.
     * The application should not include these in the default list of the
     * user's engines. If not supported, it should filter them out.
     */
    var `optional`: kotlin.Boolean = false
    , 
    /**
     * The partner code for the engine. This will be inserted into parameters
     * which include `{partnerCode}`. May be the empty string.
     */
    var `partnerCode`: kotlin.String = ""
    , 
    /**
     * Optional suffix that is appended to the search engine identifier
     * following a dash, i.e. `<identifier>-<suffix>`. If it is an empty string
     * no dash should be appended.
     */
    var `telemetrySuffix`: kotlin.String = ""
    , 
    /**
     * The URLs associated with the search engine.
     */
    var `urls`: SearchEngineUrls = SearchEngineUrls()
    , 
    /**
     * A hint to the order that this engine should be in the engine list. This
     * is derived from the `engineOrders` section of the search configuration.
     * The higher the number, the nearer to the front it should be.
     * If the number is not specified, other methods of sorting may be relied
     * upon (e.g. alphabetical).
     */
    var `orderHint`: kotlin.UInt? = null
    , 
    /**
     * The url used for reporting clicks.
     */
    var `clickUrl`: kotlin.String? = null
    
) {
    
    companion object
}



/**
 * Defines an individual search engine URL.
 */
data class SearchEngineUrl (
    /**
     * The PrePath and FilePath of the URL. May include variables for engines
     * which have a variable FilePath, e.g. `{searchTerms}` for when a search
     * term is within the path of the url.
     */
    var `base`: kotlin.String = ""
    , 
    /**
     * The HTTP method to use to send the request (`GET` or `POST`).
     * If the engine definition has not specified the method, it defaults to GET.
     */
    var `method`: kotlin.String = ""
    , 
    /**
     * The parameters for this URL.
     */
    var `params`: List<SearchUrlParam> = emptyList()
    , 
    /**
     * The name of the query parameter for the search term. Automatically
     * appended to the end of the query. This may be skipped if `{searchTerms}`
     * is included in the base.
     */
    var `searchTermParamName`: kotlin.String? = null
    
) {
    
    companion object
}



/**
 * The URLs associated with the search engine.
 */
data class SearchEngineUrls (
    /**
     * The URL to use for searches.
     */
    var `search`: SearchEngineUrl = SearchEngineUrl()
    , 
    /**
     * The URL to use for suggestions.
     */
    var `suggestions`: SearchEngineUrl? = null
    , 
    /**
     * The URL to use for trending suggestions.
     */
    var `trending`: SearchEngineUrl? = null
    , 
    /**
     * The URL of the search engine homepage.
     */
    var `searchForm`: SearchEngineUrl? = null
    
) {
    
    companion object
}



/**
 * Parameter definitions for search engine URLs. The name property is always
 * specified, along with one of value, experiment_config or search_access_point.
 */
data class SearchUrlParam (
    /**
     * The name of the parameter in the url.
     */
    var `name`: kotlin.String = ""
    , 
    /**
     * The parameter value, this may be a static value, or additionally contain
     * a parameter replacement, e.g. `{inputEncoding}`. For the partner code
     * parameter, this field should be `{partnerCode}`.
     */
    var `value`: kotlin.String? = null
    , 
    /**
     * Same as value but only used if Services.polices.isEnterprise is true. Overrides other parameters of the same name.
     */
    var `enterpriseValue`: kotlin.String? = null
    , 
    /**
     * The value for the parameter will be derived from the equivalent experiment
     * configuration value.
     * Only desktop uses this currently.
     */
    var `experimentConfig`: kotlin.String? = null
    
) {
    
    companion object
}



/**
 * The user's environment that is used for filtering the search configuration.
 */
data class SearchUserEnvironment (
    /**
     * The current locale of the application that the user is using.
     */
    var `locale`: kotlin.String = ""
    , 
    /**
     * The home region that the user is currently identified as being within.
     * On desktop & android there is a 14 day lag after detecting a region
     * change before the home region changes. TBD: iOS?
     */
    var `region`: kotlin.String = ""
    , 
    /**
     * The update channel of the user's build.
     */
    var `updateChannel`: SearchUpdateChannel = SearchUpdateChannel.__NOOP
    , 
    /**
     * The distribution id for the user's build.
     */
    var `distributionId`: kotlin.String = ""
    , 
    /**
     * The search related experiment id that the user is included within. On
     * desktop this is the `searchConfiguration.experiment` variable.
     */
    var `experiment`: kotlin.String = ""
    , 
    /**
     * The application name that the user is using.
     */
    var `appName`: SearchApplicationName = SearchApplicationName.__NOOP
    , 
    /**
     * The application version that the user is using.
     */
    var `version`: kotlin.String = ""
    , 
    /**
     * The device type that the user is using.
     */
    var `deviceType`: SearchDeviceType = SearchDeviceType.__NOOP
    
) {
    
    companion object
}



/**
 * The list of possible submission methods for search engine urls.
 */

enum class JsonEngineMethod {
    
    POST,
    GET,
    __NOOP;
    companion object
}








sealed class SearchApiException: kotlin.Exception() {
    
    class Other(
        
        val `reason`: kotlin.String = ""
        ) : SearchApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    

    
}



/**
 * The list of possible application names that are currently supported.
 */

enum class SearchApplicationName {
    
    FIREFOX_ANDROID,
    FIREFOX_IOS,
    FOCUS_ANDROID,
    FOCUS_IOS,
    FIREFOX,
    __NOOP;
    companion object
}







enum class SearchDeviceType {
    
    SMARTPHONE,
    TABLET,
    NONE,
    __NOOP;
    companion object
}






/**
 * The list of acceptable classifications for a search engine.
 */

enum class SearchEngineClassification {
    
    GENERAL,
    UNKNOWN,
    __NOOP;
    companion object
}






/**
 * The list of possible update channels for a user's build.
 * Use `default` for a self-build or an unknown channel.
 */

enum class SearchUpdateChannel {
    
    NIGHTLY,
    AURORA,
    BETA,
    RELEASE,
    ESR,
    DEFAULT,
    __NOOP;
    companion object
}























