// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("UNUSED_PARAMETER")

package mozilla.appservices.syncmanager
import mozilla.appservices.sync15.DeviceType

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }









public interface SyncManagerInterface {
    
    /**
     * Disconnect engines from sync, deleting/resetting the sync-related data
     */
    fun `disconnect`()
    
    /**
     * Get a list of engine names available for syncing
     */
    fun `getAvailableEngines`(): List<kotlin.String>
    
    /**
     * Perform a sync.  See [SyncParams] and [SyncResult] for details on how this works
     */
    fun `sync`(`params`: SyncParams): SyncResult
    
    companion object
}

open class SyncManager (
): AutoCloseable, Disposable, SyncManagerInterface
{

    
    /**
     * Disconnect engines from sync, deleting/resetting the sync-related data
     */override fun `disconnect`()
        {}

    
    /**
     * Get a list of engine names available for syncing
     */override fun `getAvailableEngines`(): List<kotlin.String> {
            return  emptyList()
    }

    
    /**
     * Perform a sync.  See [SyncParams] and [SyncResult] for details on how this works
     */
    @Throws(SyncManagerException::class)override fun `sync`(`params`: SyncParams): SyncResult {
            return  SyncResult()
    }

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



data class DeviceSettings (
    var `fxaDeviceId`: kotlin.String = ""
    , 
    var `name`: kotlin.String = ""
    , 
    var `kind`: DeviceType = DeviceType.__NOOP
    
) {
    
    companion object
}



data class SyncAuthInfo (
    var `kid`: kotlin.String = ""
    , 
    var `fxaAccessToken`: kotlin.String = ""
    , 
    var `syncKey`: kotlin.String = ""
    , 
    var `tokenserverUrl`: kotlin.String = ""
    
) {
    
    companion object
}



data class SyncParams (
    /**
     * Why are we performing this sync?
     */
    var `reason`: SyncReason = SyncReason.__NOOP
    , 
    /**
     * Which engines should we sync?
     */
    var `engines`: SyncEngineSelection = SyncEngineSelection.__NOOP
    , 
    /**
     * Which engines should be enabled in the "account global" list (for
     * example, if the UI was used to change an engine's state since the last
     * sync).
     */
    var `enabledChanges`: Map<kotlin.String, kotlin.Boolean> = emptyMap()
    , 
    /**
     * Keys to encrypt/decrypt data from local database files.  These are
     * separate from the key we use to encrypt the sync payload as a whole.
     */
    var `localEncryptionKeys`: Map<kotlin.String, kotlin.String> = emptyMap()
    , 
    /**
     * Authorization for the sync server
     */
    var `authInfo`: SyncAuthInfo = SyncAuthInfo()
    , 
    /**
     * An opaque string, as returned in the previous sync's SyncResult and
     * persisted to disk, or null if no such state is available. This includes
     * information such as the list of engines previously enabled, certain
     * server timestamps and GUIDs etc. If this value isn't correctly persisted
     * and round-tripped, each sync may look like a "first sync".
     */
    var `persistedState`: kotlin.String? = null
    , 
    /**
     * Information about the current device, such as its name, formfactor and
     * FxA device ID.
     */
    var `deviceSettings`: DeviceSettings = DeviceSettings()
    
) {
    
    companion object
}



data class SyncResult (
    /**
     * Result from the sync server
     */
    var `status`: ServiceStatus = ServiceStatus.__NOOP
    , 
    /**
     * Engines that synced successfully
     */
    var `successful`: List<kotlin.String> = emptyList()
    , 
    /**
     * Maps the names of engines that failed to sync to the reason why
     */
    var `failures`: Map<kotlin.String, kotlin.String> = emptyMap()
    , 
    /**
     * State that should be persisted to disk and supplied to the sync method
     * on the next sync (See SyncParams.persisted_state).
     */
    var `persistedState`: kotlin.String = ""
    , 
    /**
     * The list of engines which are marked as "declined" (ie, disabled) on the
     * sync server. The list of declined engines is global to the account
     * rather than to the device. Apps should use this after every sync to
     * update the local state (ie, to ensure that their Sync UI correctly
     * reflects what engines are enabled and disabled), because these could
     * change after every sync.
     */
    var `declined`: List<kotlin.String>? = null
    , 
    /**
     * Earliest time that the next sync should happen at
     */
    var `nextSyncAllowedAt`: java.time.Instant? = null
    , 
    /**
     * JSON string encoding a `SyncTelemetryPing` object
     */
    var `telemetryJson`: kotlin.String? = null
    
) {
    
    companion object
}




enum class ServiceStatus {
    
    OK,
    NETWORK_ERROR,
    SERVICE_ERROR,
    AUTH_ERROR,
    BACKED_OFF,
    OTHER_ERROR,
    __NOOP;
    companion object
}






sealed class SyncEngineSelection {
    
    object All : SyncEngineSelection()
    
    
    data class Some(
        val `engines`: List<kotlin.String> = emptyList()) : SyncEngineSelection() {
        companion object
    }
    
    object __NOOP : SyncEngineSelection()

    
    companion object
}







sealed class SyncManagerException(message: String = ""): kotlin.Exception(message) {
        
        class UnknownEngine(message: String = "") : SyncManagerException(message)
        
        class UnsupportedFeature(message: String = "") : SyncManagerException(message)
        
        class Sync15Exception(message: String = "") : SyncManagerException(message)
        
        class UrlParseException(message: String = "") : SyncManagerException(message)
        
        class InterruptedException(message: String = "") : SyncManagerException(message)
        
        class JsonException(message: String = "") : SyncManagerException(message)
        
        class LoginsException(message: String = "") : SyncManagerException(message)
        
        class PlacesException(message: String = "") : SyncManagerException(message)
        
        class AnyhowException(message: String = "") : SyncManagerException(message)
        
}




enum class SyncReason {
    
    SCHEDULED,
    USER,
    PRE_SLEEP,
    STARTUP,
    ENABLED_CHANGE,
    BACKGROUNDED,
    __NOOP;
    companion object
}

















