// -*- mode: kotlin -*-

/*
 * AUTOGENERATED BY glean_parser v17.1.0. DO NOT EDIT. DO NOT COMMIT.
 */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
/* ktlint-disable no-blank-line-before-rbrace */
@file:Suppress("PackageNaming", "MaxLineLength")
package org.mozilla.appservices.syncmanager.GleanMetrics

import mozilla.telemetry.glean.private.CommonMetricData // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.EventExtras // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.HistogramType // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.Lifetime // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.MemoryUnit // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.NoExtras // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.NoReasonCodes // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.ObjectSerialize // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.ReasonCode // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.TimeUnit // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.StringMetricType // ktlint-disable import-ordering
import mozilla.telemetry.glean.private.UuidMetricType // ktlint-disable import-ordering
import mozilla.telemetry.glean.private.LabeledMetricType // ktlint-disable import-ordering

internal object SyncV2 {
    private val failureReasonLabel: StringMetricType = // generated from sync_v2.failure_reason
        StringMetricType(
            CommonMetricData(
                category = "sync_v2",
                name = "failure_reason",
                sendInPings = listOf("sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ))

    /**
     * Records a global sync failure: either due to an authentication error,
        * unexpected exception, or other error that caused the sync to fail. Error
        * strings are truncated and sanitized to omit PII, like URLs and file system
        * paths.
     */
    val failureReason: LabeledMetricType<StringMetricType> by lazy { // generated from sync_v2.failure_reason
        LabeledMetricType(
            category = "sync_v2",
            name = "failure_reason",
            subMetric = failureReasonLabel,
            disabled = false,
            lifetime = Lifetime.PING,
            sendInPings = listOf("sync"),
            labels = setOf("auth", "other", "unexpected")
        )
    }
    /**
     * Unique identifier for this sync, used to correlate together individual pings
     * for data types that were synchronized together (history, bookmarks, logins). If
     * a data type is synchronized by itself via the legacy 'sync' API (as opposed to
     * the Sync Manager), then this field will not be set on the corresponding ping.
     */
    @get:JvmName("syncUuid")
    val syncUuid: UuidMetricType by lazy { // generated from sync_v2.sync_uuid
        UuidMetricType(
            CommonMetricData(
                category = "sync_v2",
                name = "sync_uuid",
                sendInPings = listOf("bookmarks-sync", "history-sync", "logins-sync", "sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ))
    }
}
