// -*- mode: kotlin -*-

/*
 * AUTOGENERATED BY glean_parser v17.1.0. DO NOT EDIT. DO NOT COMMIT.
 */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
/* ktlint-disable no-blank-line-before-rbrace */
@file:Suppress("PackageNaming", "MaxLineLength")
package org.mozilla.appservices.syncmanager.GleanMetrics

import mozilla.telemetry.glean.private.CommonMetricData // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.EventExtras // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.HistogramType // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.Lifetime // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.MemoryUnit // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.NoExtras // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.NoReasonCodes // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.ObjectSerialize // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.ReasonCode // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.TimeUnit // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.CounterMetricType // ktlint-disable import-ordering
import mozilla.telemetry.glean.private.DatetimeMetricType // ktlint-disable import-ordering
import mozilla.telemetry.glean.private.StringMetricType // ktlint-disable import-ordering
import mozilla.telemetry.glean.private.LabeledMetricType // ktlint-disable import-ordering

internal object HistorySyncV2 {
    private val failureReasonLabel: StringMetricType = // generated from history_sync_v2.failure_reason
        StringMetricType(
            CommonMetricData(
                category = "history_sync_v2",
                name = "failure_reason",
                sendInPings = listOf("history-sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ))

    /**
     * Records why the history sync failed: either due to an authentication error,
        * unexpected exception, or other error. The error strings are truncated and
        * sanitized to omit PII, like URLs and file system paths.
     */
    val failureReason: LabeledMetricType<StringMetricType> by lazy { // generated from history_sync_v2.failure_reason
        LabeledMetricType(
            category = "history_sync_v2",
            name = "failure_reason",
            subMetric = failureReasonLabel,
            disabled = false,
            lifetime = Lifetime.PING,
            sendInPings = listOf("history-sync"),
            labels = setOf("auth", "other", "unexpected")
        )
    }
    /**
     * Records when the history sync finished. This includes the time to download,
     * apply, and upload all records.
     */
    @get:JvmName("finishedAt")
    val finishedAt: DatetimeMetricType by lazy { // generated from history_sync_v2.finished_at
        DatetimeMetricType(
            CommonMetricData(
                category = "history_sync_v2",
                name = "finished_at",
                sendInPings = listOf("history-sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ), timeUnit = TimeUnit.MILLISECOND)
    }
    private val incomingLabel: CounterMetricType = // generated from history_sync_v2.incoming
        CounterMetricType(
            CommonMetricData(
                category = "history_sync_v2",
                name = "incoming",
                sendInPings = listOf("history-sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ))

    /**
     * Records incoming history record counts. `applied` is the number of incoming
        * history pages that were successfully stored or updated in the local database.
        * `failed_to_apply` is the number of pages that were ignored due to errors.
        * `reconciled` is the number of pages with new visits locally and remotely, and
        * had their visits merged.
     */
    val incoming: LabeledMetricType<CounterMetricType> by lazy { // generated from history_sync_v2.incoming
        LabeledMetricType(
            category = "history_sync_v2",
            name = "incoming",
            subMetric = incomingLabel,
            disabled = false,
            lifetime = Lifetime.PING,
            sendInPings = listOf("history-sync"),
            labels = setOf("applied", "failed_to_apply", "reconciled")
        )
    }
    private val outgoingLabel: CounterMetricType = // generated from history_sync_v2.outgoing
        CounterMetricType(
            CommonMetricData(
                category = "history_sync_v2",
                name = "outgoing",
                sendInPings = listOf("history-sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ))

    /**
     * Records outgoing history record counts. `uploaded` is the number of records
        * that were successfully sent to the server. `failed_to_upload` is the number of
        * records that weren't uploaded, and will be retried on the next sync.
     */
    val outgoing: LabeledMetricType<CounterMetricType> by lazy { // generated from history_sync_v2.outgoing
        LabeledMetricType(
            category = "history_sync_v2",
            name = "outgoing",
            subMetric = outgoingLabel,
            disabled = false,
            lifetime = Lifetime.PING,
            sendInPings = listOf("history-sync"),
            labels = setOf("failed_to_upload", "uploaded")
        )
    }
    /**
     * Records the number of batches needed to upload all outgoing records. The Sync
     * server has a hard limit on the number of records (and request body bytes) on
     * the number of records that can fit into a single batch, and large syncs may
     * require multiple batches.
     */
    @get:JvmName("outgoingBatches")
    val outgoingBatches: CounterMetricType by lazy { // generated from history_sync_v2.outgoing_batches
        CounterMetricType(
            CommonMetricData(
                category = "history_sync_v2",
                name = "outgoing_batches",
                sendInPings = listOf("history-sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ))
    }
    /**
     * Records when the history sync started.
     */
    @get:JvmName("startedAt")
    val startedAt: DatetimeMetricType by lazy { // generated from history_sync_v2.started_at
        DatetimeMetricType(
            CommonMetricData(
                category = "history_sync_v2",
                name = "started_at",
                sendInPings = listOf("history-sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ), timeUnit = TimeUnit.MILLISECOND)
    }
    /**
     * The user's hashed Firefox Account ID.
     */
    @get:JvmName("uid")
    val uid: StringMetricType by lazy { // generated from history_sync_v2.uid
        StringMetricType(
            CommonMetricData(
                category = "history_sync_v2",
                name = "uid",
                sendInPings = listOf("history-sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ))
    }
}
