// -*- mode: kotlin -*-

/*
 * AUTOGENERATED BY glean_parser v17.1.0. DO NOT EDIT. DO NOT COMMIT.
 */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
/* ktlint-disable no-blank-line-before-rbrace */
@file:Suppress("PackageNaming", "MaxLineLength")
package org.mozilla.appservices.syncmanager.GleanMetrics

import mozilla.telemetry.glean.private.CommonMetricData // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.EventExtras // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.HistogramType // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.Lifetime // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.MemoryUnit // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.NoExtras // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.NoReasonCodes // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.ObjectSerialize // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.ReasonCode // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.TimeUnit // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.EventMetricType // ktlint-disable import-ordering

internal object FxaTabV2 {
    @Suppress("ClassNaming", "EnumNaming")
    data class ReceivedExtra(
        val flowId: String? = null,
        val reason: String? = null,
        val streamId: String? = null
    ) : EventExtras {
        override fun toExtraRecord(): Map<String, String> {
            val map = mutableMapOf<String, String>()

            this.flowId?.let {
                map.put("flow_id", it.toString())
            }
            this.reason?.let {
                map.put("reason", it.toString())
            }
            this.streamId?.let {
                map.put("stream_id", it.toString())
            }
            return map
        }
    }
    @Suppress("ClassNaming", "EnumNaming")
    data class SentExtra(
        val flowId: String? = null,
        val streamId: String? = null
    ) : EventExtras {
        override fun toExtraRecord(): Map<String, String> {
            val map = mutableMapOf<String, String>()

            this.flowId?.let {
                map.put("flow_id", it.toString())
            }
            this.streamId?.let {
                map.put("stream_id", it.toString())
            }
            return map
        }
    }
    /**
     * Recorded when a tab is received.  Also sent by desktop - see also the docs at
     * https://firefox-source-docs.mozilla.org/toolkit/components/telemetry/data/sync-
     * ping.html
     */
    @get:JvmName("received")
    val received: EventMetricType<ReceivedExtra> by lazy { // generated from fxa_tab_v2.received
        EventMetricType<ReceivedExtra>(
            CommonMetricData(
                category = "fxa_tab_v2",
                name = "received",
                sendInPings = listOf("sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ), allowedExtraKeys = listOf("flow_id", "reason", "stream_id"))
    }
    /**
     * Recorded when a tab is sent. Also sent by desktop - see also the docs at
     * https://firefox-source-docs.mozilla.org/toolkit/components/telemetry/data/sync-
     * ping.html
     */
    @get:JvmName("sent")
    val sent: EventMetricType<SentExtra> by lazy { // generated from fxa_tab_v2.sent
        EventMetricType<SentExtra>(
            CommonMetricData(
                category = "fxa_tab_v2",
                name = "sent",
                sendInPings = listOf("sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ), allowedExtraKeys = listOf("flow_id", "stream_id"))
    }
}
