// -*- mode: kotlin -*-

/*
 * AUTOGENERATED BY glean_parser v17.1.0. DO NOT EDIT. DO NOT COMMIT.
 */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
/* ktlint-disable no-blank-line-before-rbrace */
@file:Suppress("PackageNaming", "MaxLineLength")
package org.mozilla.appservices.syncmanager.GleanMetrics

import mozilla.telemetry.glean.private.CommonMetricData // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.EventExtras // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.HistogramType // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.Lifetime // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.MemoryUnit // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.NoExtras // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.NoReasonCodes // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.ObjectSerialize // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.ReasonCode // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.TimeUnit // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.CounterMetricType // ktlint-disable import-ordering
import mozilla.telemetry.glean.private.DatetimeMetricType // ktlint-disable import-ordering
import mozilla.telemetry.glean.private.StringMetricType // ktlint-disable import-ordering
import mozilla.telemetry.glean.private.LabeledMetricType // ktlint-disable import-ordering

internal object BookmarksSyncV2 {
    private val failureReasonLabel: StringMetricType = // generated from bookmarks_sync_v2.failure_reason
        StringMetricType(
            CommonMetricData(
                category = "bookmarks_sync_v2",
                name = "failure_reason",
                sendInPings = listOf("bookmarks-sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ))

    /**
     * Records bookmark sync failure reasons.
     */
    val failureReason: LabeledMetricType<StringMetricType> by lazy { // generated from bookmarks_sync_v2.failure_reason
        LabeledMetricType(
            category = "bookmarks_sync_v2",
            name = "failure_reason",
            subMetric = failureReasonLabel,
            disabled = false,
            lifetime = Lifetime.PING,
            sendInPings = listOf("bookmarks-sync"),
            labels = setOf("auth", "other", "unexpected")
        )
    }
    /**
     * Records when the bookmark sync finished.
     */
    @get:JvmName("finishedAt")
    val finishedAt: DatetimeMetricType by lazy { // generated from bookmarks_sync_v2.finished_at
        DatetimeMetricType(
            CommonMetricData(
                category = "bookmarks_sync_v2",
                name = "finished_at",
                sendInPings = listOf("bookmarks-sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ), timeUnit = TimeUnit.MILLISECOND)
    }
    private val incomingLabel: CounterMetricType = // generated from bookmarks_sync_v2.incoming
        CounterMetricType(
            CommonMetricData(
                category = "bookmarks_sync_v2",
                name = "incoming",
                sendInPings = listOf("bookmarks-sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ))

    /**
     * Records incoming bookmark record counts.
     */
    val incoming: LabeledMetricType<CounterMetricType> by lazy { // generated from bookmarks_sync_v2.incoming
        LabeledMetricType(
            category = "bookmarks_sync_v2",
            name = "incoming",
            subMetric = incomingLabel,
            disabled = false,
            lifetime = Lifetime.PING,
            sendInPings = listOf("bookmarks-sync"),
            labels = setOf("applied", "failed_to_apply", "reconciled")
        )
    }
    private val outgoingLabel: CounterMetricType = // generated from bookmarks_sync_v2.outgoing
        CounterMetricType(
            CommonMetricData(
                category = "bookmarks_sync_v2",
                name = "outgoing",
                sendInPings = listOf("bookmarks-sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ))

    /**
     * Records outgoing bookmark record counts.
     */
    val outgoing: LabeledMetricType<CounterMetricType> by lazy { // generated from bookmarks_sync_v2.outgoing
        LabeledMetricType(
            category = "bookmarks_sync_v2",
            name = "outgoing",
            subMetric = outgoingLabel,
            disabled = false,
            lifetime = Lifetime.PING,
            sendInPings = listOf("bookmarks-sync"),
            labels = setOf("failed_to_upload", "uploaded")
        )
    }
    /**
     * Records the number of batches needed to upload all outgoing records.
     */
    @get:JvmName("outgoingBatches")
    val outgoingBatches: CounterMetricType by lazy { // generated from bookmarks_sync_v2.outgoing_batches
        CounterMetricType(
            CommonMetricData(
                category = "bookmarks_sync_v2",
                name = "outgoing_batches",
                sendInPings = listOf("bookmarks-sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ))
    }
    private val remoteTreeProblemsLabel: CounterMetricType = // generated from bookmarks_sync_v2.remote_tree_problems
        CounterMetricType(
            CommonMetricData(
                category = "bookmarks_sync_v2",
                name = "remote_tree_problems",
                sendInPings = listOf("bookmarks-sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ))

    /**
     * Records counts for structure problems and divergences in the remote bookmarks
        * tree. These are documented in https://github.com/mozilla/dogear/blob/fbade15f2a
        * 4f11215e30b8f428a0a8df3defeaec/src/tree.rs#L1273-L1294.
     */
    val remoteTreeProblems: LabeledMetricType<CounterMetricType> by lazy { // generated from bookmarks_sync_v2.remote_tree_problems
        LabeledMetricType(
            category = "bookmarks_sync_v2",
            name = "remote_tree_problems",
            subMetric = remoteTreeProblemsLabel,
            disabled = false,
            lifetime = Lifetime.PING,
            sendInPings = listOf("bookmarks-sync"),
            labels = setOf("misparented_roots", "missing_children", "missing_parent_guids", "multiple_parents_by_children", "non_folder_parent_guids", "orphans", "parent_child_disagreements")
        )
    }
    /**
     * Records when the bookmark sync started.
     */
    @get:JvmName("startedAt")
    val startedAt: DatetimeMetricType by lazy { // generated from bookmarks_sync_v2.started_at
        DatetimeMetricType(
            CommonMetricData(
                category = "bookmarks_sync_v2",
                name = "started_at",
                sendInPings = listOf("bookmarks-sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ), timeUnit = TimeUnit.MILLISECOND)
    }
    /**
     * The user's hashed Firefox Account ID.
     */
    @get:JvmName("uid")
    val uid: StringMetricType by lazy { // generated from bookmarks_sync_v2.uid
        StringMetricType(
            CommonMetricData(
                category = "bookmarks_sync_v2",
                name = "uid",
                sendInPings = listOf("bookmarks-sync"),
                lifetime = Lifetime.PING,
                disabled = false
            ))
    }
}
