// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package mozilla.appservices.places.uniffi

// Common helper code.
//
// Ideally this would live in a separate .kt file where it can be unittested etc
// in isolation, and perhaps even published as a re-useable package.
//
// However, it's important that the details of how this helper code works (e.g. the
// way that different builtin types are passed across the FFI) exactly match what's
// expected by the Rust code on the other side of the interface. In practice right
// now that means coming from the exact some version of `uniffi` that was used to
// compile the Rust component. The easiest way to ensure this is to bundle the Kotlin
// helpers directly inline like we're doing here.

import com.sun.jna.Library
import com.sun.jna.IntegerType
import com.sun.jna.Native
import com.sun.jna.Pointer
import com.sun.jna.Structure
import com.sun.jna.Callback
import com.sun.jna.ptr.*
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.nio.CharBuffer
import java.nio.charset.CodingErrorAction
import java.util.concurrent.atomic.AtomicLong
import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.atomic.AtomicBoolean

// This is a helper for safely working with byte buffers returned from the Rust code.
// A rust-owned buffer is represented by its capacity, its current length, and a
// pointer to the underlying data.

/**
 * @suppress
 */
@Structure.FieldOrder("capacity", "len", "data")
open class RustBuffer : Structure() {
    // Note: `capacity` and `len` are actually `ULong` values, but JVM only supports signed values.
    // When dealing with these fields, make sure to call `toULong()`.
    @JvmField var capacity: Long = 0
    @JvmField var len: Long = 0
    @JvmField var data: Pointer? = null

    class ByValue: RustBuffer(), Structure.ByValue
    class ByReference: RustBuffer(), Structure.ByReference

   internal fun setValue(other: RustBuffer) {
        capacity = other.capacity
        len = other.len
        data = other.data
    }

    companion object {
        internal fun alloc(size: ULong = 0UL) = uniffiRustCall() { status ->
            // Note: need to convert the size to a `Long` value to make this work with JVM.
            UniffiLib.INSTANCE.ffi_places_rustbuffer_alloc(size.toLong(), status)
        }.also {
            if(it.data == null) {
               throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=${size})")
           }
        }

        internal fun create(capacity: ULong, len: ULong, data: Pointer?): RustBuffer.ByValue {
            var buf = RustBuffer.ByValue()
            buf.capacity = capacity.toLong()
            buf.len = len.toLong()
            buf.data = data
            return buf
        }

        internal fun free(buf: RustBuffer.ByValue) = uniffiRustCall() { status ->
            UniffiLib.INSTANCE.ffi_places_rustbuffer_free(buf, status)
        }
    }

    @Suppress("TooGenericExceptionThrown")
    fun asByteBuffer() =
        this.data?.getByteBuffer(0, this.len.toLong())?.also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
}

/**
 * The equivalent of the `*mut RustBuffer` type.
 * Required for callbacks taking in an out pointer.
 *
 * Size is the sum of all values in the struct.
 *
 * @suppress
 */
class RustBufferByReference : ByReference(16) {
    /**
     * Set the pointed-to `RustBuffer` to the given value.
     */
    fun setValue(value: RustBuffer.ByValue) {
        // NOTE: The offsets are as they are in the C-like struct.
        val pointer = getPointer()
        pointer.setLong(0, value.capacity)
        pointer.setLong(8, value.len)
        pointer.setPointer(16, value.data)
    }

    /**
     * Get a `RustBuffer.ByValue` from this reference.
     */
    fun getValue(): RustBuffer.ByValue {
        val pointer = getPointer()
        val value = RustBuffer.ByValue()
        value.writeField("capacity", pointer.getLong(0))
        value.writeField("len", pointer.getLong(8))
        value.writeField("data", pointer.getLong(16))

        return value
    }
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@Structure.FieldOrder("len", "data")
internal open class ForeignBytes : Structure() {
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue : ForeignBytes(), Structure.ByValue
}
/**
 * The FfiConverter interface handles converter types to and from the FFI
 *
 * All implementing objects should be public to support external types.  When a
 * type is external we need to import it's FfiConverter.
 *
 * @suppress
 */
public interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `ByteBuffer`
    fun read(buf: ByteBuffer): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): ULong

    // Write a Kotlin type to a `ByteBuffer`
    fun write(value: KotlinType, buf: ByteBuffer)

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer.ByValue {
        val rbuf = RustBuffer.alloc(allocationSize(value))
        try {
            val bbuf = rbuf.data!!.getByteBuffer(0, rbuf.capacity).also {
                it.order(ByteOrder.BIG_ENDIAN)
            }
            write(value, bbuf)
            rbuf.writeField("len", bbuf.position().toLong())
            return rbuf
        } catch (e: Throwable) {
            RustBuffer.free(rbuf)
            throw e
        }
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer.ByValue): KotlinType {
        val byteBuf = rbuf.asByteBuffer()!!
        try {
           val item = read(byteBuf)
           if (byteBuf.hasRemaining()) {
               throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
           }
           return item
        } finally {
            RustBuffer.free(rbuf)
        }
    }
}

/**
 * FfiConverter that uses `RustBuffer` as the FfiType
 *
 * @suppress
 */
public interface FfiConverterRustBuffer<KotlinType>: FfiConverter<KotlinType, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue) = liftFromRustBuffer(value)
    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}
// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.

internal const val UNIFFI_CALL_SUCCESS = 0.toByte()
internal const val UNIFFI_CALL_ERROR = 1.toByte()
internal const val UNIFFI_CALL_UNEXPECTED_ERROR = 2.toByte()

@Structure.FieldOrder("code", "error_buf")
internal open class UniffiRustCallStatus : Structure() {
    @JvmField var code: Byte = 0
    @JvmField var error_buf: RustBuffer.ByValue = RustBuffer.ByValue()

    class ByValue: UniffiRustCallStatus(), Structure.ByValue

    fun isSuccess(): Boolean {
        return code == UNIFFI_CALL_SUCCESS
    }

    fun isError(): Boolean {
        return code == UNIFFI_CALL_ERROR
    }

    fun isPanic(): Boolean {
        return code == UNIFFI_CALL_UNEXPECTED_ERROR
    }

    companion object {
        fun create(code: Byte, errorBuf: RustBuffer.ByValue): UniffiRustCallStatus.ByValue {
            val callStatus = UniffiRustCallStatus.ByValue()
            callStatus.code = code
            callStatus.error_buf = errorBuf
            return callStatus
        }
    }
}

class InternalException(message: String) : kotlin.Exception(message)

/**
 * Each top-level error class has a companion object that can lift the error from the call status's rust buffer
 *
 * @suppress
 */
interface UniffiRustCallStatusErrorHandler<E> {
    fun lift(error_buf: RustBuffer.ByValue): E;
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
private inline fun <U, E: kotlin.Exception> uniffiRustCallWithError(errorHandler: UniffiRustCallStatusErrorHandler<E>, callback: (UniffiRustCallStatus) -> U): U {
    var status = UniffiRustCallStatus()
    val return_value = callback(status)
    uniffiCheckCallStatus(errorHandler, status)
    return return_value
}

// Check UniffiRustCallStatus and throw an error if the call wasn't successful
private fun<E: kotlin.Exception> uniffiCheckCallStatus(errorHandler: UniffiRustCallStatusErrorHandler<E>, status: UniffiRustCallStatus) {
    if (status.isSuccess()) {
        return
    } else if (status.isError()) {
        throw errorHandler.lift(status.error_buf)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.error_buf.len > 0) {
            throw InternalException(FfiConverterString.lift(status.error_buf))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

/**
 * UniffiRustCallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
 *
 * @suppress
 */
object UniffiNullRustCallStatusErrorHandler: UniffiRustCallStatusErrorHandler<InternalException> {
    override fun lift(error_buf: RustBuffer.ByValue): InternalException {
        RustBuffer.free(error_buf)
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
private inline fun <U> uniffiRustCall(callback: (UniffiRustCallStatus) -> U): U {
    return uniffiRustCallWithError(UniffiNullRustCallStatusErrorHandler, callback)
}

internal inline fun<T> uniffiTraitInterfaceCall(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
) {
    try {
        writeReturn(makeCall())
    } catch(e: kotlin.Exception) {
        callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
        callStatus.error_buf = FfiConverterString.lower(e.toString())
    }
}

internal inline fun<T, reified E: Throwable> uniffiTraitInterfaceCallWithError(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
    lowerError: (E) -> RustBuffer.ByValue
) {
    try {
        writeReturn(makeCall())
    } catch(e: kotlin.Exception) {
        if (e is E) {
            callStatus.code = UNIFFI_CALL_ERROR
            callStatus.error_buf = lowerError(e)
        } else {
            callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
            callStatus.error_buf = FfiConverterString.lower(e.toString())
        }
    }
}
// Map handles to objects
//
// This is used pass an opaque 64-bit handle representing a foreign object to the Rust code.
internal class UniffiHandleMap<T: Any> {
    private val map = ConcurrentHashMap<Long, T>()
    private val counter = java.util.concurrent.atomic.AtomicLong(0)

    val size: Int
        get() = map.size

    // Insert a new object into the handle map and get a handle for it
    fun insert(obj: T): Long {
        val handle = counter.getAndAdd(1)
        map.put(handle, obj)
        return handle
    }

    // Get an object from the handle map
    fun get(handle: Long): T {
        return map.get(handle) ?: throw InternalException("UniffiHandleMap.get: Invalid handle")
    }

    // Remove an entry from the handlemap and get the Kotlin object back
    fun remove(handle: Long): T {
        return map.remove(handle) ?: throw InternalException("UniffiHandleMap: Invalid handle")
    }
}

// Contains loading, initialization code,
// and the FFI Function declarations in a com.sun.jna.Library.
@Synchronized
private fun findLibraryName(componentName: String): String {
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "megazord"
}

private inline fun <reified Lib : Library> loadIndirect(
    componentName: String
): Lib {
    return Native.load<Lib>(findLibraryName(componentName), Lib::class.java)
}

// Define FFI callback types
internal interface UniffiRustFutureContinuationCallback : com.sun.jna.Callback {
    fun callback(`data`: Long,`pollResult`: Byte,)
}
internal interface UniffiForeignFutureFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
internal interface UniffiCallbackInterfaceFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
@Structure.FieldOrder("handle", "free")
internal open class UniffiForeignFuture(
    @JvmField internal var `handle`: Long = 0.toLong(),
    @JvmField internal var `free`: UniffiForeignFutureFree? = null,
) : Structure() {
    class UniffiByValue(
        `handle`: Long = 0.toLong(),
        `free`: UniffiForeignFutureFree? = null,
    ): UniffiForeignFuture(`handle`,`free`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFuture) {
        `handle` = other.`handle`
        `free` = other.`free`
    }

}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF32(
    @JvmField internal var `returnValue`: Float = 0.0f,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Float = 0.0f,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF64(
    @JvmField internal var `returnValue`: Double = 0.0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Double = 0.0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructPointer(
    @JvmField internal var `returnValue`: Pointer = Pointer.NULL,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Pointer = Pointer.NULL,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructPointer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructPointer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompletePointer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructPointer.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructRustBuffer(
    @JvmField internal var `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructRustBuffer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructRustBuffer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteRustBuffer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructRustBuffer.UniffiByValue,)
}
@Structure.FieldOrder("callStatus")
internal open class UniffiForeignFutureStructVoid(
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructVoid(`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructVoid) {
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteVoid : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructVoid.UniffiByValue,)
}


































































































































































// For large crates we prevent `MethodTooLargeException` (see #2340)
// N.B. the name of the extension is very misleading, since it is 
// rather `InterfaceTooLargeException`, caused by too many methods 
// in the interface for large crates.
//
// By splitting the otherwise huge interface into two parts
// * UniffiLib 
// * IntegrityCheckingUniffiLib (this)
// we allow for ~2x as many methods in the UniffiLib interface.
// 
// The `ffi_uniffi_contract_version` method and all checksum methods are put 
// into `IntegrityCheckingUniffiLib` and these methods are called only once,
// when the library is loaded.
internal interface IntegrityCheckingUniffiLib : Library {
    // Integrity check functions only
    fun uniffi_places_checksum_func_places_api_new(
): Short
fun uniffi_places_checksum_method_placesapi_bookmarks_reset(
): Short
fun uniffi_places_checksum_method_placesapi_bookmarks_sync(
): Short
fun uniffi_places_checksum_method_placesapi_history_sync(
): Short
fun uniffi_places_checksum_method_placesapi_new_connection(
): Short
fun uniffi_places_checksum_method_placesapi_register_with_sync_manager(
): Short
fun uniffi_places_checksum_method_placesapi_reset_history(
): Short
fun uniffi_places_checksum_method_placesconnection_accept_result(
): Short
fun uniffi_places_checksum_method_placesconnection_apply_observation(
): Short
fun uniffi_places_checksum_method_placesconnection_bookmarks_count_bookmarks_in_trees(
): Short
fun uniffi_places_checksum_method_placesconnection_bookmarks_delete(
): Short
fun uniffi_places_checksum_method_placesconnection_bookmarks_delete_everything(
): Short
fun uniffi_places_checksum_method_placesconnection_bookmarks_get_all_with_url(
): Short
fun uniffi_places_checksum_method_placesconnection_bookmarks_get_by_guid(
): Short
fun uniffi_places_checksum_method_placesconnection_bookmarks_get_recent(
): Short
fun uniffi_places_checksum_method_placesconnection_bookmarks_get_tree(
): Short
fun uniffi_places_checksum_method_placesconnection_bookmarks_get_url_for_keyword(
): Short
fun uniffi_places_checksum_method_placesconnection_bookmarks_insert(
): Short
fun uniffi_places_checksum_method_placesconnection_bookmarks_search(
): Short
fun uniffi_places_checksum_method_placesconnection_bookmarks_update(
): Short
fun uniffi_places_checksum_method_placesconnection_delete_everything_history(
): Short
fun uniffi_places_checksum_method_placesconnection_delete_visit(
): Short
fun uniffi_places_checksum_method_placesconnection_delete_visits_between(
): Short
fun uniffi_places_checksum_method_placesconnection_delete_visits_for(
): Short
fun uniffi_places_checksum_method_placesconnection_get_history_highlights(
): Short
fun uniffi_places_checksum_method_placesconnection_get_history_metadata_between(
): Short
fun uniffi_places_checksum_method_placesconnection_get_history_metadata_since(
): Short
fun uniffi_places_checksum_method_placesconnection_get_latest_history_metadata_for_url(
): Short
fun uniffi_places_checksum_method_placesconnection_get_top_frecent_site_infos(
): Short
fun uniffi_places_checksum_method_placesconnection_get_visit_count(
): Short
fun uniffi_places_checksum_method_placesconnection_get_visit_count_for_host(
): Short
fun uniffi_places_checksum_method_placesconnection_get_visit_infos(
): Short
fun uniffi_places_checksum_method_placesconnection_get_visit_page(
): Short
fun uniffi_places_checksum_method_placesconnection_get_visit_page_with_bound(
): Short
fun uniffi_places_checksum_method_placesconnection_get_visited(
): Short
fun uniffi_places_checksum_method_placesconnection_get_visited_urls_in_range(
): Short
fun uniffi_places_checksum_method_placesconnection_match_url(
): Short
fun uniffi_places_checksum_method_placesconnection_metadata_delete(
): Short
fun uniffi_places_checksum_method_placesconnection_metadata_delete_older_than(
): Short
fun uniffi_places_checksum_method_placesconnection_new_interrupt_handle(
): Short
fun uniffi_places_checksum_method_placesconnection_note_history_metadata_observation(
): Short
fun uniffi_places_checksum_method_placesconnection_places_history_import_from_ios(
): Short
fun uniffi_places_checksum_method_placesconnection_query_autocomplete(
): Short
fun uniffi_places_checksum_method_placesconnection_query_history_metadata(
): Short
fun uniffi_places_checksum_method_placesconnection_run_maintenance_checkpoint(
): Short
fun uniffi_places_checksum_method_placesconnection_run_maintenance_optimize(
): Short
fun uniffi_places_checksum_method_placesconnection_run_maintenance_prune(
): Short
fun uniffi_places_checksum_method_placesconnection_run_maintenance_vacuum(
): Short
fun uniffi_places_checksum_method_sqlinterrupthandle_interrupt(
): Short
fun ffi_places_uniffi_contract_version(
): Int

}

// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.
internal interface UniffiLib : Library {
    companion object {
        internal val INSTANCE: UniffiLib by lazy {
            val componentName = "places"
            // For large crates we prevent `MethodTooLargeException` (see #2340)
            // N.B. the name of the extension is very misleading, since it is 
            // rather `InterfaceTooLargeException`, caused by too many methods 
            // in the interface for large crates.
            //
            // By splitting the otherwise huge interface into two parts
            // * UniffiLib (this)
            // * IntegrityCheckingUniffiLib
            // And all checksum methods are put into `IntegrityCheckingUniffiLib`
            // we allow for ~2x as many methods in the UniffiLib interface.
            // 
            // Thus we first load the library with `loadIndirect` as `IntegrityCheckingUniffiLib`
            // so that we can (optionally!) call `uniffiCheckApiChecksums`...
            loadIndirect<IntegrityCheckingUniffiLib>(componentName)
                .also { lib: IntegrityCheckingUniffiLib ->
                    uniffiCheckContractApiVersion(lib)
                    uniffiCheckApiChecksums(lib)
                }
            // ... and then we load the library as `UniffiLib`
            // N.B. we cannot use `loadIndirect` once and then try to cast it to `UniffiLib`
            // => results in `java.lang.ClassCastException: com.sun.proxy.$Proxy cannot be cast to ...`
            // error. So we must call `loadIndirect` twice. For crates large enough
            // to trigger this issue, the performance impact is negligible, running on
            // a macOS M1 machine the `loadIndirect` call takes ~50ms.
            val lib = loadIndirect<UniffiLib>(componentName)
            // No need to check the contract version and checksums, since 
            // we already did that with `IntegrityCheckingUniffiLib` above.
            // Loading of library with integrity check done.
            lib
        }
        
        // The Cleaner for the whole library
        internal val CLEANER: UniffiCleaner by lazy {
            UniffiCleaner.create()
        }
    }

    // FFI functions
    fun uniffi_places_fn_clone_placesapi(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_places_fn_free_placesapi(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_placesapi_bookmarks_reset(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_placesapi_bookmarks_sync(`ptr`: Pointer,`keyId`: RustBuffer.ByValue,`accessToken`: RustBuffer.ByValue,`syncKey`: RustBuffer.ByValue,`tokenserverUrl`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesapi_history_sync(`ptr`: Pointer,`keyId`: RustBuffer.ByValue,`accessToken`: RustBuffer.ByValue,`syncKey`: RustBuffer.ByValue,`tokenserverUrl`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesapi_new_connection(`ptr`: Pointer,`connType`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_places_fn_method_placesapi_register_with_sync_manager(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_placesapi_reset_history(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_clone_placesconnection(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_places_fn_free_placesconnection(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_placesconnection_accept_result(`ptr`: Pointer,`searchString`: RustBuffer.ByValue,`url`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_placesconnection_apply_observation(`ptr`: Pointer,`visit`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_placesconnection_bookmarks_count_bookmarks_in_trees(`ptr`: Pointer,`folderGuids`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Int
fun uniffi_places_fn_method_placesconnection_bookmarks_delete(`ptr`: Pointer,`id`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_places_fn_method_placesconnection_bookmarks_delete_everything(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_placesconnection_bookmarks_get_all_with_url(`ptr`: Pointer,`url`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_bookmarks_get_by_guid(`ptr`: Pointer,`guid`: RustBuffer.ByValue,`getDirectChildren`: Byte,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_bookmarks_get_recent(`ptr`: Pointer,`limit`: Int,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_bookmarks_get_tree(`ptr`: Pointer,`itemGuid`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_bookmarks_get_url_for_keyword(`ptr`: Pointer,`keyword`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_bookmarks_insert(`ptr`: Pointer,`bookmark`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_bookmarks_search(`ptr`: Pointer,`query`: RustBuffer.ByValue,`limit`: Int,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_bookmarks_update(`ptr`: Pointer,`data`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_placesconnection_delete_everything_history(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_placesconnection_delete_visit(`ptr`: Pointer,`url`: RustBuffer.ByValue,`timestamp`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_placesconnection_delete_visits_between(`ptr`: Pointer,`start`: Long,`end`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_placesconnection_delete_visits_for(`ptr`: Pointer,`url`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_placesconnection_get_history_highlights(`ptr`: Pointer,`weights`: RustBuffer.ByValue,`limit`: Int,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_get_history_metadata_between(`ptr`: Pointer,`start`: Long,`end`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_get_history_metadata_since(`ptr`: Pointer,`since`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_get_latest_history_metadata_for_url(`ptr`: Pointer,`url`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_get_top_frecent_site_infos(`ptr`: Pointer,`numItems`: Int,`thresholdOption`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_get_visit_count(`ptr`: Pointer,`excludeTypes`: Int,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun uniffi_places_fn_method_placesconnection_get_visit_count_for_host(`ptr`: Pointer,`host`: RustBuffer.ByValue,`before`: Long,`excludeTypes`: Int,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun uniffi_places_fn_method_placesconnection_get_visit_infos(`ptr`: Pointer,`startDate`: Long,`endDate`: Long,`excludeTypes`: Int,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_get_visit_page(`ptr`: Pointer,`offset`: Long,`count`: Long,`excludeTypes`: Int,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_get_visit_page_with_bound(`ptr`: Pointer,`bound`: Long,`offset`: Long,`count`: Long,`excludeTypes`: Int,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_get_visited(`ptr`: Pointer,`urls`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_get_visited_urls_in_range(`ptr`: Pointer,`start`: Long,`end`: Long,`includeRemote`: Byte,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_match_url(`ptr`: Pointer,`query`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_metadata_delete(`ptr`: Pointer,`url`: RustBuffer.ByValue,`referrerUrl`: RustBuffer.ByValue,`searchTerm`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_placesconnection_metadata_delete_older_than(`ptr`: Pointer,`olderThan`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_placesconnection_new_interrupt_handle(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_places_fn_method_placesconnection_note_history_metadata_observation(`ptr`: Pointer,`data`: RustBuffer.ByValue,`options`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_placesconnection_places_history_import_from_ios(`ptr`: Pointer,`dbPath`: RustBuffer.ByValue,`lastSyncTimestamp`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_query_autocomplete(`ptr`: Pointer,`search`: RustBuffer.ByValue,`limit`: Int,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_query_history_metadata(`ptr`: Pointer,`query`: RustBuffer.ByValue,`limit`: Int,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_run_maintenance_checkpoint(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_placesconnection_run_maintenance_optimize(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_placesconnection_run_maintenance_prune(`ptr`: Pointer,`dbSizeLimit`: Int,`pruneLimit`: Int,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_places_fn_method_placesconnection_run_maintenance_vacuum(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_clone_sqlinterrupthandle(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_places_fn_free_sqlinterrupthandle(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_method_sqlinterrupthandle_interrupt(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_places_fn_func_places_api_new(`dbPath`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun ffi_places_rustbuffer_alloc(`size`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun ffi_places_rustbuffer_from_bytes(`bytes`: ForeignBytes.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun ffi_places_rustbuffer_free(`buf`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun ffi_places_rustbuffer_reserve(`buf`: RustBuffer.ByValue,`additional`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun ffi_places_rust_future_poll_u8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_places_rust_future_cancel_u8(`handle`: Long,
): Unit
fun ffi_places_rust_future_free_u8(`handle`: Long,
): Unit
fun ffi_places_rust_future_complete_u8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun ffi_places_rust_future_poll_i8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_places_rust_future_cancel_i8(`handle`: Long,
): Unit
fun ffi_places_rust_future_free_i8(`handle`: Long,
): Unit
fun ffi_places_rust_future_complete_i8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun ffi_places_rust_future_poll_u16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_places_rust_future_cancel_u16(`handle`: Long,
): Unit
fun ffi_places_rust_future_free_u16(`handle`: Long,
): Unit
fun ffi_places_rust_future_complete_u16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Short
fun ffi_places_rust_future_poll_i16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_places_rust_future_cancel_i16(`handle`: Long,
): Unit
fun ffi_places_rust_future_free_i16(`handle`: Long,
): Unit
fun ffi_places_rust_future_complete_i16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Short
fun ffi_places_rust_future_poll_u32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_places_rust_future_cancel_u32(`handle`: Long,
): Unit
fun ffi_places_rust_future_free_u32(`handle`: Long,
): Unit
fun ffi_places_rust_future_complete_u32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Int
fun ffi_places_rust_future_poll_i32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_places_rust_future_cancel_i32(`handle`: Long,
): Unit
fun ffi_places_rust_future_free_i32(`handle`: Long,
): Unit
fun ffi_places_rust_future_complete_i32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Int
fun ffi_places_rust_future_poll_u64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_places_rust_future_cancel_u64(`handle`: Long,
): Unit
fun ffi_places_rust_future_free_u64(`handle`: Long,
): Unit
fun ffi_places_rust_future_complete_u64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun ffi_places_rust_future_poll_i64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_places_rust_future_cancel_i64(`handle`: Long,
): Unit
fun ffi_places_rust_future_free_i64(`handle`: Long,
): Unit
fun ffi_places_rust_future_complete_i64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun ffi_places_rust_future_poll_f32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_places_rust_future_cancel_f32(`handle`: Long,
): Unit
fun ffi_places_rust_future_free_f32(`handle`: Long,
): Unit
fun ffi_places_rust_future_complete_f32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Float
fun ffi_places_rust_future_poll_f64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_places_rust_future_cancel_f64(`handle`: Long,
): Unit
fun ffi_places_rust_future_free_f64(`handle`: Long,
): Unit
fun ffi_places_rust_future_complete_f64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Double
fun ffi_places_rust_future_poll_pointer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_places_rust_future_cancel_pointer(`handle`: Long,
): Unit
fun ffi_places_rust_future_free_pointer(`handle`: Long,
): Unit
fun ffi_places_rust_future_complete_pointer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun ffi_places_rust_future_poll_rust_buffer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_places_rust_future_cancel_rust_buffer(`handle`: Long,
): Unit
fun ffi_places_rust_future_free_rust_buffer(`handle`: Long,
): Unit
fun ffi_places_rust_future_complete_rust_buffer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun ffi_places_rust_future_poll_void(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_places_rust_future_cancel_void(`handle`: Long,
): Unit
fun ffi_places_rust_future_free_void(`handle`: Long,
): Unit
fun ffi_places_rust_future_complete_void(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Unit

}

private fun uniffiCheckContractApiVersion(lib: IntegrityCheckingUniffiLib) {
    // Get the bindings contract version from our ComponentInterface
    val bindings_contract_version = 29
    // Get the scaffolding contract version by calling the into the dylib
    val scaffolding_contract_version = lib.ffi_places_uniffi_contract_version()
    if (bindings_contract_version != scaffolding_contract_version) {
        throw RuntimeException("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    }
}
@Suppress("UNUSED_PARAMETER")
private fun uniffiCheckApiChecksums(lib: IntegrityCheckingUniffiLib) {
    if (lib.uniffi_places_checksum_func_places_api_new() != 61152.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesapi_bookmarks_reset() != 55149.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesapi_bookmarks_sync() != 54759.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesapi_history_sync() != 17496.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesapi_new_connection() != 52100.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesapi_register_with_sync_manager() != 51829.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesapi_reset_history() != 6106.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_accept_result() != 37823.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_apply_observation() != 21237.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_bookmarks_count_bookmarks_in_trees() != 42888.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_bookmarks_delete() != 45103.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_bookmarks_delete_everything() != 63220.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_bookmarks_get_all_with_url() != 14617.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_bookmarks_get_by_guid() != 61351.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_bookmarks_get_recent() != 42501.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_bookmarks_get_tree() != 63569.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_bookmarks_get_url_for_keyword() != 36697.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_bookmarks_insert() != 60832.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_bookmarks_search() != 33699.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_bookmarks_update() != 21797.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_delete_everything_history() != 49787.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_delete_visit() != 24294.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_delete_visits_between() != 25398.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_delete_visits_for() != 29015.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_get_history_highlights() != 47165.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_get_history_metadata_between() != 11598.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_get_history_metadata_since() != 26978.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_get_latest_history_metadata_for_url() != 4169.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_get_top_frecent_site_infos() != 4671.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_get_visit_count() != 5900.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_get_visit_count_for_host() != 44234.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_get_visit_infos() != 53292.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_get_visit_page() != 49538.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_get_visit_page_with_bound() != 17277.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_get_visited() != 7835.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_get_visited_urls_in_range() != 48399.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_match_url() != 17169.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_metadata_delete() != 29409.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_metadata_delete_older_than() != 30473.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_new_interrupt_handle() != 5418.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_note_history_metadata_observation() != 31493.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_places_history_import_from_ios() != 596.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_query_autocomplete() != 35323.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_query_history_metadata() != 21791.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_run_maintenance_checkpoint() != 3524.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_run_maintenance_optimize() != 56373.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_run_maintenance_prune() != 54740.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_placesconnection_run_maintenance_vacuum() != 17497.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_places_checksum_method_sqlinterrupthandle_interrupt() != 10423.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

/**
 * @suppress
 */
public fun uniffiEnsureInitialized() {
    UniffiLib.INSTANCE
}

// Async support

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }

/** 
 * Used to instantiate an interface without an actual pointer, for fakes in tests, mostly.
 *
 * @suppress
 * */
object NoPointer

/**
 * @suppress
 */
public object FfiConverterUInt: FfiConverter<UInt, Int> {
    override fun lift(value: Int): UInt {
        return value.toUInt()
    }

    override fun read(buf: ByteBuffer): UInt {
        return lift(buf.getInt())
    }

    override fun lower(value: UInt): Int {
        return value.toInt()
    }

    override fun allocationSize(value: UInt) = 4UL

    override fun write(value: UInt, buf: ByteBuffer) {
        buf.putInt(value.toInt())
    }
}

/**
 * @suppress
 */
public object FfiConverterInt: FfiConverter<Int, Int> {
    override fun lift(value: Int): Int {
        return value
    }

    override fun read(buf: ByteBuffer): Int {
        return buf.getInt()
    }

    override fun lower(value: Int): Int {
        return value
    }

    override fun allocationSize(value: Int) = 4UL

    override fun write(value: Int, buf: ByteBuffer) {
        buf.putInt(value)
    }
}

/**
 * @suppress
 */
public object FfiConverterULong: FfiConverter<ULong, Long> {
    override fun lift(value: Long): ULong {
        return value.toULong()
    }

    override fun read(buf: ByteBuffer): ULong {
        return lift(buf.getLong())
    }

    override fun lower(value: ULong): Long {
        return value.toLong()
    }

    override fun allocationSize(value: ULong) = 8UL

    override fun write(value: ULong, buf: ByteBuffer) {
        buf.putLong(value.toLong())
    }
}

/**
 * @suppress
 */
public object FfiConverterLong: FfiConverter<Long, Long> {
    override fun lift(value: Long): Long {
        return value
    }

    override fun read(buf: ByteBuffer): Long {
        return buf.getLong()
    }

    override fun lower(value: Long): Long {
        return value
    }

    override fun allocationSize(value: Long) = 8UL

    override fun write(value: Long, buf: ByteBuffer) {
        buf.putLong(value)
    }
}

/**
 * @suppress
 */
public object FfiConverterDouble: FfiConverter<Double, Double> {
    override fun lift(value: Double): Double {
        return value
    }

    override fun read(buf: ByteBuffer): Double {
        return buf.getDouble()
    }

    override fun lower(value: Double): Double {
        return value
    }

    override fun allocationSize(value: Double) = 8UL

    override fun write(value: Double, buf: ByteBuffer) {
        buf.putDouble(value)
    }
}

/**
 * @suppress
 */
public object FfiConverterBoolean: FfiConverter<Boolean, Byte> {
    override fun lift(value: Byte): Boolean {
        return value.toInt() != 0
    }

    override fun read(buf: ByteBuffer): Boolean {
        return lift(buf.get())
    }

    override fun lower(value: Boolean): Byte {
        return if (value) 1.toByte() else 0.toByte()
    }

    override fun allocationSize(value: Boolean) = 1UL

    override fun write(value: Boolean, buf: ByteBuffer) {
        buf.put(lower(value))
    }
}

/**
 * @suppress
 */
public object FfiConverterString: FfiConverter<String, RustBuffer.ByValue> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer.ByValue): String {
        try {
            val byteArr = ByteArray(value.len.toInt())
            value.asByteBuffer()!!.get(byteArr)
            return byteArr.toString(Charsets.UTF_8)
        } finally {
            RustBuffer.free(value)
        }
    }

    override fun read(buf: ByteBuffer): String {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr.toString(Charsets.UTF_8)
    }

    fun toUtf8(value: String): ByteBuffer {
        // Make sure we don't have invalid UTF-16, check for lone surrogates.
        return Charsets.UTF_8.newEncoder().run {
            onMalformedInput(CodingErrorAction.REPORT)
            encode(CharBuffer.wrap(value))
        }
    }

    override fun lower(value: String): RustBuffer.ByValue {
        val byteBuf = toUtf8(value)
        // Ideally we'd pass these bytes to `ffi_bytebuffer_from_bytes`, but doing so would require us
        // to copy them into a JNA `Memory`. So we might as well directly copy them into a `RustBuffer`.
        val rbuf = RustBuffer.alloc(byteBuf.limit().toULong())
        rbuf.asByteBuffer()!!.put(byteBuf)
        return rbuf
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per UTF-16 code unit which will always be
    // enough.
    override fun allocationSize(value: String): ULong {
        val sizeForLength = 4UL
        val sizeForString = value.length.toULong() * 3UL
        return sizeForLength + sizeForString
    }

    override fun write(value: String, buf: ByteBuffer) {
        val byteBuf = toUtf8(value)
        buf.putInt(byteBuf.limit())
        buf.put(byteBuf)
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * The cleaner interface for Object finalization code to run.
 * This is the entry point to any implementation that we're using.
 *
 * The cleaner registers objects and returns cleanables, so now we are
 * defining a `UniffiCleaner` with a `UniffiClenaer.Cleanable` to abstract the
 * different implmentations available at compile time.
 *
 * @suppress
 */
interface UniffiCleaner {
    interface Cleanable {
        fun clean()
    }

    fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable

    companion object
}

// The fallback Jna cleaner, which is available for both Android, and the JVM.
private class UniffiJnaCleaner : UniffiCleaner {
    private val cleaner = com.sun.jna.internal.Cleaner.getCleaner()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        UniffiJnaCleanable(cleaner.register(value, cleanUpTask))
}

private class UniffiJnaCleanable(
    private val cleanable: com.sun.jna.internal.Cleaner.Cleanable,
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}


// We decide at uniffi binding generation time whether we were
// using Android or not.
// There are further runtime checks to chose the correct implementation
// of the cleaner.
private fun UniffiCleaner.Companion.create(): UniffiCleaner =
    try {
        // For safety's sake: if the library hasn't been run in android_cleaner = true
        // mode, but is being run on Android, then we still need to think about
        // Android API versions.
        // So we check if java.lang.ref.Cleaner is there, and use that…
        java.lang.Class.forName("java.lang.ref.Cleaner")
        JavaLangRefCleaner()
    } catch (e: ClassNotFoundException) {
        // … otherwise, fallback to the JNA cleaner.
        UniffiJnaCleaner()
    }

private class JavaLangRefCleaner : UniffiCleaner {
    val cleaner = java.lang.ref.Cleaner.create()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        JavaLangRefCleanable(cleaner.register(value, cleanUpTask))
}

private class JavaLangRefCleanable(
    val cleanable: java.lang.ref.Cleaner.Cleanable
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}
public interface PlacesApiInterface {
    
    fun `bookmarksReset`()
    
    fun `bookmarksSync`(`keyId`: kotlin.String, `accessToken`: kotlin.String, `syncKey`: kotlin.String, `tokenserverUrl`: Url): kotlin.String
    
    fun `historySync`(`keyId`: kotlin.String, `accessToken`: kotlin.String, `syncKey`: kotlin.String, `tokenserverUrl`: Url): kotlin.String
    
    fun `newConnection`(`connType`: ConnectionType): PlacesConnection
    
    fun `registerWithSyncManager`()
    
    fun `resetHistory`()
    
    companion object
}

open class PlacesApi: Disposable, AutoCloseable, PlacesApiInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_places_fn_free_placesapi(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_places_fn_clone_placesapi(pointer!!, status)
        }
    }

    
    @Throws(PlacesApiException::class)override fun `bookmarksReset`()
        = 
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesapi_bookmarks_reset(
        it, _status)
}
    }
    
    

    
    @Throws(PlacesApiException::class)override fun `bookmarksSync`(`keyId`: kotlin.String, `accessToken`: kotlin.String, `syncKey`: kotlin.String, `tokenserverUrl`: Url): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesapi_bookmarks_sync(
        it, FfiConverterString.lower(`keyId`),FfiConverterString.lower(`accessToken`),FfiConverterString.lower(`syncKey`),FfiConverterTypeUrl.lower(`tokenserverUrl`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `historySync`(`keyId`: kotlin.String, `accessToken`: kotlin.String, `syncKey`: kotlin.String, `tokenserverUrl`: Url): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesapi_history_sync(
        it, FfiConverterString.lower(`keyId`),FfiConverterString.lower(`accessToken`),FfiConverterString.lower(`syncKey`),FfiConverterTypeUrl.lower(`tokenserverUrl`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `newConnection`(`connType`: ConnectionType): PlacesConnection {
            return FfiConverterTypePlacesConnection.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesapi_new_connection(
        it, FfiConverterTypeConnectionType.lower(`connType`),_status)
}
    }
    )
    }
    

    override fun `registerWithSyncManager`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesapi_register_with_sync_manager(
        it, _status)
}
    }
    
    

    
    @Throws(PlacesApiException::class)override fun `resetHistory`()
        = 
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesapi_reset_history(
        it, _status)
}
    }
    
    

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypePlacesApi: FfiConverter<PlacesApi, Pointer> {

    override fun lower(value: PlacesApi): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): PlacesApi {
        return PlacesApi(value)
    }

    override fun read(buf: ByteBuffer): PlacesApi {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: PlacesApi) = 8UL

    override fun write(value: PlacesApi, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface PlacesConnectionInterface {
    
    /**
     * `url` is a `string` and not a `URL` because `accept_result`
     * handles malformed urls
     */
    fun `acceptResult`(`searchString`: kotlin.String, `url`: kotlin.String)
    
    fun `applyObservation`(`visit`: VisitObservation)
    
    /**
     * Counts the number of bookmarks in the bookmark tree under the specified GUID. Does not count
     * the passed item, so an empty folder will return zero, as will a non-existing GUID or the
     * guid of a non-folder item.
     * Counts only bookmark items - ie, sub-folders and separators are not counted.
     */
    fun `bookmarksCountBookmarksInTrees`(`folderGuids`: List<Guid>): kotlin.UInt
    
    fun `bookmarksDelete`(`id`: Guid): kotlin.Boolean
    
    fun `bookmarksDeleteEverything`()
    
    fun `bookmarksGetAllWithUrl`(`url`: kotlin.String): List<BookmarkItem>
    
    fun `bookmarksGetByGuid`(`guid`: Guid, `getDirectChildren`: kotlin.Boolean): BookmarkItem?
    
    fun `bookmarksGetRecent`(`limit`: kotlin.Int): List<BookmarkItem>
    
    fun `bookmarksGetTree`(`itemGuid`: Guid): BookmarkItem?
    
    fun `bookmarksGetUrlForKeyword`(`keyword`: kotlin.String): Url?
    
    fun `bookmarksInsert`(`bookmark`: InsertableBookmarkItem): Guid
    
    fun `bookmarksSearch`(`query`: kotlin.String, `limit`: kotlin.Int): List<BookmarkItem>
    
    fun `bookmarksUpdate`(`data`: BookmarkUpdateInfo)
    
    fun `deleteEverythingHistory`()
    
    fun `deleteVisit`(`url`: kotlin.String, `timestamp`: PlacesTimestamp)
    
    fun `deleteVisitsBetween`(`start`: PlacesTimestamp, `end`: PlacesTimestamp)
    
    fun `deleteVisitsFor`(`url`: kotlin.String)
    
    fun `getHistoryHighlights`(`weights`: HistoryHighlightWeights, `limit`: kotlin.Int): List<HistoryHighlight>
    
    fun `getHistoryMetadataBetween`(`start`: PlacesTimestamp, `end`: PlacesTimestamp): List<HistoryMetadata>
    
    fun `getHistoryMetadataSince`(`since`: PlacesTimestamp): List<HistoryMetadata>
    
    fun `getLatestHistoryMetadataForUrl`(`url`: Url): HistoryMetadata?
    
    fun `getTopFrecentSiteInfos`(`numItems`: kotlin.Int, `thresholdOption`: FrecencyThresholdOption): List<TopFrecentSiteInfo>
    
    fun `getVisitCount`(`excludeTypes`: VisitTransitionSet): kotlin.Long
    
    fun `getVisitCountForHost`(`host`: kotlin.String, `before`: PlacesTimestamp, `excludeTypes`: VisitTransitionSet): kotlin.Long
    
    fun `getVisitInfos`(`startDate`: PlacesTimestamp, `endDate`: PlacesTimestamp, `excludeTypes`: VisitTransitionSet): List<HistoryVisitInfo>
    
    fun `getVisitPage`(`offset`: kotlin.Long, `count`: kotlin.Long, `excludeTypes`: VisitTransitionSet): List<HistoryVisitInfo>
    
    fun `getVisitPageWithBound`(`bound`: kotlin.Long, `offset`: kotlin.Long, `count`: kotlin.Long, `excludeTypes`: VisitTransitionSet): HistoryVisitInfosWithBound
    
    fun `getVisited`(`urls`: List<kotlin.String>): List<kotlin.Boolean>
    
    fun `getVisitedUrlsInRange`(`start`: PlacesTimestamp, `end`: PlacesTimestamp, `includeRemote`: kotlin.Boolean): List<Url>
    
    fun `matchUrl`(`query`: kotlin.String): Url?
    
    fun `metadataDelete`(`url`: Url, `referrerUrl`: Url?, `searchTerm`: kotlin.String?)
    
    fun `metadataDeleteOlderThan`(`olderThan`: PlacesTimestamp)
    
    fun `newInterruptHandle`(): SqlInterruptHandle
    
    fun `noteHistoryMetadataObservation`(`data`: HistoryMetadataObservation, `options`: NoteHistoryMetadataObservationOptions)
    
    fun `placesHistoryImportFromIos`(`dbPath`: kotlin.String, `lastSyncTimestamp`: kotlin.Long): HistoryMigrationResult
    
    fun `queryAutocomplete`(`search`: kotlin.String, `limit`: kotlin.Int): List<SearchResult>
    
    fun `queryHistoryMetadata`(`query`: kotlin.String, `limit`: kotlin.Int): List<HistoryMetadata>
    
    /**
     * Run maintenance on the places DB (checkpoint step)
     *
     * The `run_maintenance_*()` functions are intended to be run during idle time and will take steps
     * to clean up / shrink the database.  They're split up so that we can time each one in the
     * Kotlin wrapper code (This is needed because we only have access to the Glean API in Kotlin and
     * it supports a stop-watch style API, not recording specific values).
     */
    fun `runMaintenanceCheckpoint`()
    
    /**
     * Run maintenance on the places DB (optimize step)
     *
     * The `run_maintenance_*()` functions are intended to be run during idle time and will take steps
     * to clean up / shrink the database.  They're split up so that we can time each one in the
     * Kotlin wrapper code (This is needed because we only have access to the Glean API in Kotlin and
     * it supports a stop-watch style API, not recording specific values).
     */
    fun `runMaintenanceOptimize`()
    
    /**
     * Run maintenance on the places DB (prune step)
     *
     * The `run_maintenance_*()` functions are intended to be run during idle time and will take steps
     * to clean up / shrink the database.  They're split up so that we can time each one in the
     * Kotlin wrapper code (This is needed because we only have access to the Glean API in Kotlin and
     * it supports a stop-watch style API, not recording specific values).
     *
     * db_size_limit is the approximate storage limit in bytes.  If the database is using more space
     * than this, some older visits will be deleted to free up space.  Pass in a 0 to skip this.
     *
     * prune_limit is the maximum number of visits to prune if the database is over db_size_limit
     */
    fun `runMaintenancePrune`(`dbSizeLimit`: kotlin.UInt, `pruneLimit`: kotlin.UInt): RunMaintenanceMetrics
    
    /**
     * Run maintenance on the places DB (vacuum step)
     *
     * The `run_maintenance_*()` functions are intended to be run during idle time and will take steps
     * to clean up / shrink the database.  They're split up so that we can time each one in the
     * Kotlin wrapper code (This is needed because we only have access to the Glean API in Kotlin and
     * it supports a stop-watch style API, not recording specific values).
     */
    fun `runMaintenanceVacuum`()
    
    companion object
}

open class PlacesConnection: Disposable, AutoCloseable, PlacesConnectionInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_places_fn_free_placesconnection(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_places_fn_clone_placesconnection(pointer!!, status)
        }
    }

    
    /**
     * `url` is a `string` and not a `URL` because `accept_result`
     * handles malformed urls
     */
    @Throws(PlacesApiException::class)override fun `acceptResult`(`searchString`: kotlin.String, `url`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_accept_result(
        it, FfiConverterString.lower(`searchString`),FfiConverterString.lower(`url`),_status)
}
    }
    
    

    
    @Throws(PlacesApiException::class)override fun `applyObservation`(`visit`: VisitObservation)
        = 
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_apply_observation(
        it, FfiConverterTypeVisitObservation.lower(`visit`),_status)
}
    }
    
    

    
    /**
     * Counts the number of bookmarks in the bookmark tree under the specified GUID. Does not count
     * the passed item, so an empty folder will return zero, as will a non-existing GUID or the
     * guid of a non-folder item.
     * Counts only bookmark items - ie, sub-folders and separators are not counted.
     */
    @Throws(PlacesApiException::class)override fun `bookmarksCountBookmarksInTrees`(`folderGuids`: List<Guid>): kotlin.UInt {
            return FfiConverterUInt.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_bookmarks_count_bookmarks_in_trees(
        it, FfiConverterSequenceTypeGuid.lower(`folderGuids`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `bookmarksDelete`(`id`: Guid): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_bookmarks_delete(
        it, FfiConverterTypeGuid.lower(`id`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `bookmarksDeleteEverything`()
        = 
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_bookmarks_delete_everything(
        it, _status)
}
    }
    
    

    
    @Throws(PlacesApiException::class)override fun `bookmarksGetAllWithUrl`(`url`: kotlin.String): List<BookmarkItem> {
            return FfiConverterSequenceTypeBookmarkItem.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_bookmarks_get_all_with_url(
        it, FfiConverterString.lower(`url`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `bookmarksGetByGuid`(`guid`: Guid, `getDirectChildren`: kotlin.Boolean): BookmarkItem? {
            return FfiConverterOptionalTypeBookmarkItem.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_bookmarks_get_by_guid(
        it, FfiConverterTypeGuid.lower(`guid`),FfiConverterBoolean.lower(`getDirectChildren`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `bookmarksGetRecent`(`limit`: kotlin.Int): List<BookmarkItem> {
            return FfiConverterSequenceTypeBookmarkItem.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_bookmarks_get_recent(
        it, FfiConverterInt.lower(`limit`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `bookmarksGetTree`(`itemGuid`: Guid): BookmarkItem? {
            return FfiConverterOptionalTypeBookmarkItem.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_bookmarks_get_tree(
        it, FfiConverterTypeGuid.lower(`itemGuid`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `bookmarksGetUrlForKeyword`(`keyword`: kotlin.String): Url? {
            return FfiConverterOptionalTypeUrl.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_bookmarks_get_url_for_keyword(
        it, FfiConverterString.lower(`keyword`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `bookmarksInsert`(`bookmark`: InsertableBookmarkItem): Guid {
            return FfiConverterTypeGuid.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_bookmarks_insert(
        it, FfiConverterTypeInsertableBookmarkItem.lower(`bookmark`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `bookmarksSearch`(`query`: kotlin.String, `limit`: kotlin.Int): List<BookmarkItem> {
            return FfiConverterSequenceTypeBookmarkItem.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_bookmarks_search(
        it, FfiConverterString.lower(`query`),FfiConverterInt.lower(`limit`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `bookmarksUpdate`(`data`: BookmarkUpdateInfo)
        = 
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_bookmarks_update(
        it, FfiConverterTypeBookmarkUpdateInfo.lower(`data`),_status)
}
    }
    
    

    
    @Throws(PlacesApiException::class)override fun `deleteEverythingHistory`()
        = 
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_delete_everything_history(
        it, _status)
}
    }
    
    

    
    @Throws(PlacesApiException::class)override fun `deleteVisit`(`url`: kotlin.String, `timestamp`: PlacesTimestamp)
        = 
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_delete_visit(
        it, FfiConverterString.lower(`url`),FfiConverterTypePlacesTimestamp.lower(`timestamp`),_status)
}
    }
    
    

    
    @Throws(PlacesApiException::class)override fun `deleteVisitsBetween`(`start`: PlacesTimestamp, `end`: PlacesTimestamp)
        = 
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_delete_visits_between(
        it, FfiConverterTypePlacesTimestamp.lower(`start`),FfiConverterTypePlacesTimestamp.lower(`end`),_status)
}
    }
    
    

    
    @Throws(PlacesApiException::class)override fun `deleteVisitsFor`(`url`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_delete_visits_for(
        it, FfiConverterString.lower(`url`),_status)
}
    }
    
    

    
    @Throws(PlacesApiException::class)override fun `getHistoryHighlights`(`weights`: HistoryHighlightWeights, `limit`: kotlin.Int): List<HistoryHighlight> {
            return FfiConverterSequenceTypeHistoryHighlight.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_get_history_highlights(
        it, FfiConverterTypeHistoryHighlightWeights.lower(`weights`),FfiConverterInt.lower(`limit`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `getHistoryMetadataBetween`(`start`: PlacesTimestamp, `end`: PlacesTimestamp): List<HistoryMetadata> {
            return FfiConverterSequenceTypeHistoryMetadata.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_get_history_metadata_between(
        it, FfiConverterTypePlacesTimestamp.lower(`start`),FfiConverterTypePlacesTimestamp.lower(`end`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `getHistoryMetadataSince`(`since`: PlacesTimestamp): List<HistoryMetadata> {
            return FfiConverterSequenceTypeHistoryMetadata.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_get_history_metadata_since(
        it, FfiConverterTypePlacesTimestamp.lower(`since`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `getLatestHistoryMetadataForUrl`(`url`: Url): HistoryMetadata? {
            return FfiConverterOptionalTypeHistoryMetadata.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_get_latest_history_metadata_for_url(
        it, FfiConverterTypeUrl.lower(`url`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `getTopFrecentSiteInfos`(`numItems`: kotlin.Int, `thresholdOption`: FrecencyThresholdOption): List<TopFrecentSiteInfo> {
            return FfiConverterSequenceTypeTopFrecentSiteInfo.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_get_top_frecent_site_infos(
        it, FfiConverterInt.lower(`numItems`),FfiConverterTypeFrecencyThresholdOption.lower(`thresholdOption`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `getVisitCount`(`excludeTypes`: VisitTransitionSet): kotlin.Long {
            return FfiConverterLong.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_get_visit_count(
        it, FfiConverterTypeVisitTransitionSet.lower(`excludeTypes`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `getVisitCountForHost`(`host`: kotlin.String, `before`: PlacesTimestamp, `excludeTypes`: VisitTransitionSet): kotlin.Long {
            return FfiConverterLong.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_get_visit_count_for_host(
        it, FfiConverterString.lower(`host`),FfiConverterTypePlacesTimestamp.lower(`before`),FfiConverterTypeVisitTransitionSet.lower(`excludeTypes`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `getVisitInfos`(`startDate`: PlacesTimestamp, `endDate`: PlacesTimestamp, `excludeTypes`: VisitTransitionSet): List<HistoryVisitInfo> {
            return FfiConverterSequenceTypeHistoryVisitInfo.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_get_visit_infos(
        it, FfiConverterTypePlacesTimestamp.lower(`startDate`),FfiConverterTypePlacesTimestamp.lower(`endDate`),FfiConverterTypeVisitTransitionSet.lower(`excludeTypes`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `getVisitPage`(`offset`: kotlin.Long, `count`: kotlin.Long, `excludeTypes`: VisitTransitionSet): List<HistoryVisitInfo> {
            return FfiConverterSequenceTypeHistoryVisitInfo.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_get_visit_page(
        it, FfiConverterLong.lower(`offset`),FfiConverterLong.lower(`count`),FfiConverterTypeVisitTransitionSet.lower(`excludeTypes`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `getVisitPageWithBound`(`bound`: kotlin.Long, `offset`: kotlin.Long, `count`: kotlin.Long, `excludeTypes`: VisitTransitionSet): HistoryVisitInfosWithBound {
            return FfiConverterTypeHistoryVisitInfosWithBound.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_get_visit_page_with_bound(
        it, FfiConverterLong.lower(`bound`),FfiConverterLong.lower(`offset`),FfiConverterLong.lower(`count`),FfiConverterTypeVisitTransitionSet.lower(`excludeTypes`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `getVisited`(`urls`: List<kotlin.String>): List<kotlin.Boolean> {
            return FfiConverterSequenceBoolean.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_get_visited(
        it, FfiConverterSequenceString.lower(`urls`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `getVisitedUrlsInRange`(`start`: PlacesTimestamp, `end`: PlacesTimestamp, `includeRemote`: kotlin.Boolean): List<Url> {
            return FfiConverterSequenceTypeUrl.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_get_visited_urls_in_range(
        it, FfiConverterTypePlacesTimestamp.lower(`start`),FfiConverterTypePlacesTimestamp.lower(`end`),FfiConverterBoolean.lower(`includeRemote`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `matchUrl`(`query`: kotlin.String): Url? {
            return FfiConverterOptionalTypeUrl.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_match_url(
        it, FfiConverterString.lower(`query`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `metadataDelete`(`url`: Url, `referrerUrl`: Url?, `searchTerm`: kotlin.String?)
        = 
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_metadata_delete(
        it, FfiConverterTypeUrl.lower(`url`),FfiConverterOptionalTypeUrl.lower(`referrerUrl`),FfiConverterOptionalString.lower(`searchTerm`),_status)
}
    }
    
    

    
    @Throws(PlacesApiException::class)override fun `metadataDeleteOlderThan`(`olderThan`: PlacesTimestamp)
        = 
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_metadata_delete_older_than(
        it, FfiConverterTypePlacesTimestamp.lower(`olderThan`),_status)
}
    }
    
    

    override fun `newInterruptHandle`(): SqlInterruptHandle {
            return FfiConverterTypeSqlInterruptHandle.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_new_interrupt_handle(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `noteHistoryMetadataObservation`(`data`: HistoryMetadataObservation, `options`: NoteHistoryMetadataObservationOptions)
        = 
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_note_history_metadata_observation(
        it, FfiConverterTypeHistoryMetadataObservation.lower(`data`),FfiConverterTypeNoteHistoryMetadataObservationOptions.lower(`options`),_status)
}
    }
    
    

    
    @Throws(PlacesApiException::class)override fun `placesHistoryImportFromIos`(`dbPath`: kotlin.String, `lastSyncTimestamp`: kotlin.Long): HistoryMigrationResult {
            return FfiConverterTypeHistoryMigrationResult.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_places_history_import_from_ios(
        it, FfiConverterString.lower(`dbPath`),FfiConverterLong.lower(`lastSyncTimestamp`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `queryAutocomplete`(`search`: kotlin.String, `limit`: kotlin.Int): List<SearchResult> {
            return FfiConverterSequenceTypeSearchResult.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_query_autocomplete(
        it, FfiConverterString.lower(`search`),FfiConverterInt.lower(`limit`),_status)
}
    }
    )
    }
    

    
    @Throws(PlacesApiException::class)override fun `queryHistoryMetadata`(`query`: kotlin.String, `limit`: kotlin.Int): List<HistoryMetadata> {
            return FfiConverterSequenceTypeHistoryMetadata.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_query_history_metadata(
        it, FfiConverterString.lower(`query`),FfiConverterInt.lower(`limit`),_status)
}
    }
    )
    }
    

    
    /**
     * Run maintenance on the places DB (checkpoint step)
     *
     * The `run_maintenance_*()` functions are intended to be run during idle time and will take steps
     * to clean up / shrink the database.  They're split up so that we can time each one in the
     * Kotlin wrapper code (This is needed because we only have access to the Glean API in Kotlin and
     * it supports a stop-watch style API, not recording specific values).
     */
    @Throws(PlacesApiException::class)override fun `runMaintenanceCheckpoint`()
        = 
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_run_maintenance_checkpoint(
        it, _status)
}
    }
    
    

    
    /**
     * Run maintenance on the places DB (optimize step)
     *
     * The `run_maintenance_*()` functions are intended to be run during idle time and will take steps
     * to clean up / shrink the database.  They're split up so that we can time each one in the
     * Kotlin wrapper code (This is needed because we only have access to the Glean API in Kotlin and
     * it supports a stop-watch style API, not recording specific values).
     */
    @Throws(PlacesApiException::class)override fun `runMaintenanceOptimize`()
        = 
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_run_maintenance_optimize(
        it, _status)
}
    }
    
    

    
    /**
     * Run maintenance on the places DB (prune step)
     *
     * The `run_maintenance_*()` functions are intended to be run during idle time and will take steps
     * to clean up / shrink the database.  They're split up so that we can time each one in the
     * Kotlin wrapper code (This is needed because we only have access to the Glean API in Kotlin and
     * it supports a stop-watch style API, not recording specific values).
     *
     * db_size_limit is the approximate storage limit in bytes.  If the database is using more space
     * than this, some older visits will be deleted to free up space.  Pass in a 0 to skip this.
     *
     * prune_limit is the maximum number of visits to prune if the database is over db_size_limit
     */
    @Throws(PlacesApiException::class)override fun `runMaintenancePrune`(`dbSizeLimit`: kotlin.UInt, `pruneLimit`: kotlin.UInt): RunMaintenanceMetrics {
            return FfiConverterTypeRunMaintenanceMetrics.lift(
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_run_maintenance_prune(
        it, FfiConverterUInt.lower(`dbSizeLimit`),FfiConverterUInt.lower(`pruneLimit`),_status)
}
    }
    )
    }
    

    
    /**
     * Run maintenance on the places DB (vacuum step)
     *
     * The `run_maintenance_*()` functions are intended to be run during idle time and will take steps
     * to clean up / shrink the database.  They're split up so that we can time each one in the
     * Kotlin wrapper code (This is needed because we only have access to the Glean API in Kotlin and
     * it supports a stop-watch style API, not recording specific values).
     */
    @Throws(PlacesApiException::class)override fun `runMaintenanceVacuum`()
        = 
    callWithPointer {
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_placesconnection_run_maintenance_vacuum(
        it, _status)
}
    }
    
    

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypePlacesConnection: FfiConverter<PlacesConnection, Pointer> {

    override fun lower(value: PlacesConnection): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): PlacesConnection {
        return PlacesConnection(value)
    }

    override fun read(buf: ByteBuffer): PlacesConnection {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: PlacesConnection) = 8UL

    override fun write(value: PlacesConnection, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface SqlInterruptHandleInterface {
    
    fun `interrupt`()
    
    companion object
}

open class SqlInterruptHandle: Disposable, AutoCloseable, SqlInterruptHandleInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_places_fn_free_sqlinterrupthandle(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_places_fn_clone_sqlinterrupthandle(pointer!!, status)
        }
    }

    override fun `interrupt`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_method_sqlinterrupthandle_interrupt(
        it, _status)
}
    }
    
    

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeSqlInterruptHandle: FfiConverter<SqlInterruptHandle, Pointer> {

    override fun lower(value: SqlInterruptHandle): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): SqlInterruptHandle {
        return SqlInterruptHandle(value)
    }

    override fun read(buf: ByteBuffer): SqlInterruptHandle {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SqlInterruptHandle) = 8UL

    override fun write(value: SqlInterruptHandle, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}



data class BookmarkData (
    var `guid`: Guid, 
    var `parentGuid`: Guid, 
    var `position`: kotlin.UInt, 
    var `dateAdded`: PlacesTimestamp, 
    var `lastModified`: PlacesTimestamp, 
    var `url`: Url, 
    var `title`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeBookmarkData: FfiConverterRustBuffer<BookmarkData> {
    override fun read(buf: ByteBuffer): BookmarkData {
        return BookmarkData(
            FfiConverterTypeGuid.read(buf),
            FfiConverterTypeGuid.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterTypePlacesTimestamp.read(buf),
            FfiConverterTypePlacesTimestamp.read(buf),
            FfiConverterTypeUrl.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: BookmarkData) = (
            FfiConverterTypeGuid.allocationSize(value.`guid`) +
            FfiConverterTypeGuid.allocationSize(value.`parentGuid`) +
            FfiConverterUInt.allocationSize(value.`position`) +
            FfiConverterTypePlacesTimestamp.allocationSize(value.`dateAdded`) +
            FfiConverterTypePlacesTimestamp.allocationSize(value.`lastModified`) +
            FfiConverterTypeUrl.allocationSize(value.`url`) +
            FfiConverterOptionalString.allocationSize(value.`title`)
    )

    override fun write(value: BookmarkData, buf: ByteBuffer) {
            FfiConverterTypeGuid.write(value.`guid`, buf)
            FfiConverterTypeGuid.write(value.`parentGuid`, buf)
            FfiConverterUInt.write(value.`position`, buf)
            FfiConverterTypePlacesTimestamp.write(value.`dateAdded`, buf)
            FfiConverterTypePlacesTimestamp.write(value.`lastModified`, buf)
            FfiConverterTypeUrl.write(value.`url`, buf)
            FfiConverterOptionalString.write(value.`title`, buf)
    }
}



data class BookmarkFolder (
    var `guid`: Guid, 
    var `dateAdded`: PlacesTimestamp, 
    var `lastModified`: PlacesTimestamp, 
    var `parentGuid`: Guid?, 
    var `position`: kotlin.UInt, 
    var `title`: kotlin.String?, 
    var `childGuids`: List<Guid>?, 
    var `childNodes`: List<BookmarkItem>?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeBookmarkFolder: FfiConverterRustBuffer<BookmarkFolder> {
    override fun read(buf: ByteBuffer): BookmarkFolder {
        return BookmarkFolder(
            FfiConverterTypeGuid.read(buf),
            FfiConverterTypePlacesTimestamp.read(buf),
            FfiConverterTypePlacesTimestamp.read(buf),
            FfiConverterOptionalTypeGuid.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalSequenceTypeGuid.read(buf),
            FfiConverterOptionalSequenceTypeBookmarkItem.read(buf),
        )
    }

    override fun allocationSize(value: BookmarkFolder) = (
            FfiConverterTypeGuid.allocationSize(value.`guid`) +
            FfiConverterTypePlacesTimestamp.allocationSize(value.`dateAdded`) +
            FfiConverterTypePlacesTimestamp.allocationSize(value.`lastModified`) +
            FfiConverterOptionalTypeGuid.allocationSize(value.`parentGuid`) +
            FfiConverterUInt.allocationSize(value.`position`) +
            FfiConverterOptionalString.allocationSize(value.`title`) +
            FfiConverterOptionalSequenceTypeGuid.allocationSize(value.`childGuids`) +
            FfiConverterOptionalSequenceTypeBookmarkItem.allocationSize(value.`childNodes`)
    )

    override fun write(value: BookmarkFolder, buf: ByteBuffer) {
            FfiConverterTypeGuid.write(value.`guid`, buf)
            FfiConverterTypePlacesTimestamp.write(value.`dateAdded`, buf)
            FfiConverterTypePlacesTimestamp.write(value.`lastModified`, buf)
            FfiConverterOptionalTypeGuid.write(value.`parentGuid`, buf)
            FfiConverterUInt.write(value.`position`, buf)
            FfiConverterOptionalString.write(value.`title`, buf)
            FfiConverterOptionalSequenceTypeGuid.write(value.`childGuids`, buf)
            FfiConverterOptionalSequenceTypeBookmarkItem.write(value.`childNodes`, buf)
    }
}



data class BookmarkSeparator (
    var `guid`: Guid, 
    var `dateAdded`: PlacesTimestamp, 
    var `lastModified`: PlacesTimestamp, 
    var `parentGuid`: Guid, 
    var `position`: kotlin.UInt
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeBookmarkSeparator: FfiConverterRustBuffer<BookmarkSeparator> {
    override fun read(buf: ByteBuffer): BookmarkSeparator {
        return BookmarkSeparator(
            FfiConverterTypeGuid.read(buf),
            FfiConverterTypePlacesTimestamp.read(buf),
            FfiConverterTypePlacesTimestamp.read(buf),
            FfiConverterTypeGuid.read(buf),
            FfiConverterUInt.read(buf),
        )
    }

    override fun allocationSize(value: BookmarkSeparator) = (
            FfiConverterTypeGuid.allocationSize(value.`guid`) +
            FfiConverterTypePlacesTimestamp.allocationSize(value.`dateAdded`) +
            FfiConverterTypePlacesTimestamp.allocationSize(value.`lastModified`) +
            FfiConverterTypeGuid.allocationSize(value.`parentGuid`) +
            FfiConverterUInt.allocationSize(value.`position`)
    )

    override fun write(value: BookmarkSeparator, buf: ByteBuffer) {
            FfiConverterTypeGuid.write(value.`guid`, buf)
            FfiConverterTypePlacesTimestamp.write(value.`dateAdded`, buf)
            FfiConverterTypePlacesTimestamp.write(value.`lastModified`, buf)
            FfiConverterTypeGuid.write(value.`parentGuid`, buf)
            FfiConverterUInt.write(value.`position`, buf)
    }
}



data class BookmarkUpdateInfo (
    var `guid`: Guid, 
    var `title`: kotlin.String?, 
    var `url`: kotlin.String?, 
    var `parentGuid`: Guid?, 
    var `position`: kotlin.UInt?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeBookmarkUpdateInfo: FfiConverterRustBuffer<BookmarkUpdateInfo> {
    override fun read(buf: ByteBuffer): BookmarkUpdateInfo {
        return BookmarkUpdateInfo(
            FfiConverterTypeGuid.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalTypeGuid.read(buf),
            FfiConverterOptionalUInt.read(buf),
        )
    }

    override fun allocationSize(value: BookmarkUpdateInfo) = (
            FfiConverterTypeGuid.allocationSize(value.`guid`) +
            FfiConverterOptionalString.allocationSize(value.`title`) +
            FfiConverterOptionalString.allocationSize(value.`url`) +
            FfiConverterOptionalTypeGuid.allocationSize(value.`parentGuid`) +
            FfiConverterOptionalUInt.allocationSize(value.`position`)
    )

    override fun write(value: BookmarkUpdateInfo, buf: ByteBuffer) {
            FfiConverterTypeGuid.write(value.`guid`, buf)
            FfiConverterOptionalString.write(value.`title`, buf)
            FfiConverterOptionalString.write(value.`url`, buf)
            FfiConverterOptionalTypeGuid.write(value.`parentGuid`, buf)
            FfiConverterOptionalUInt.write(value.`position`, buf)
    }
}



/**
 * Exists just to convince uniffi to generate `liftSequence*` helpers!
 */
data class Dummy (
    var `md`: List<HistoryMetadata>?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeDummy: FfiConverterRustBuffer<Dummy> {
    override fun read(buf: ByteBuffer): Dummy {
        return Dummy(
            FfiConverterOptionalSequenceTypeHistoryMetadata.read(buf),
        )
    }

    override fun allocationSize(value: Dummy) = (
            FfiConverterOptionalSequenceTypeHistoryMetadata.allocationSize(value.`md`)
    )

    override fun write(value: Dummy, buf: ByteBuffer) {
            FfiConverterOptionalSequenceTypeHistoryMetadata.write(value.`md`, buf)
    }
}



data class HistoryHighlight (
    var `score`: kotlin.Double, 
    var `placeId`: kotlin.Int, 
    var `url`: kotlin.String, 
    var `title`: kotlin.String?, 
    var `previewImageUrl`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeHistoryHighlight: FfiConverterRustBuffer<HistoryHighlight> {
    override fun read(buf: ByteBuffer): HistoryHighlight {
        return HistoryHighlight(
            FfiConverterDouble.read(buf),
            FfiConverterInt.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: HistoryHighlight) = (
            FfiConverterDouble.allocationSize(value.`score`) +
            FfiConverterInt.allocationSize(value.`placeId`) +
            FfiConverterString.allocationSize(value.`url`) +
            FfiConverterOptionalString.allocationSize(value.`title`) +
            FfiConverterOptionalString.allocationSize(value.`previewImageUrl`)
    )

    override fun write(value: HistoryHighlight, buf: ByteBuffer) {
            FfiConverterDouble.write(value.`score`, buf)
            FfiConverterInt.write(value.`placeId`, buf)
            FfiConverterString.write(value.`url`, buf)
            FfiConverterOptionalString.write(value.`title`, buf)
            FfiConverterOptionalString.write(value.`previewImageUrl`, buf)
    }
}



data class HistoryHighlightWeights (
    var `viewTime`: kotlin.Double, 
    var `frequency`: kotlin.Double
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeHistoryHighlightWeights: FfiConverterRustBuffer<HistoryHighlightWeights> {
    override fun read(buf: ByteBuffer): HistoryHighlightWeights {
        return HistoryHighlightWeights(
            FfiConverterDouble.read(buf),
            FfiConverterDouble.read(buf),
        )
    }

    override fun allocationSize(value: HistoryHighlightWeights) = (
            FfiConverterDouble.allocationSize(value.`viewTime`) +
            FfiConverterDouble.allocationSize(value.`frequency`)
    )

    override fun write(value: HistoryHighlightWeights, buf: ByteBuffer) {
            FfiConverterDouble.write(value.`viewTime`, buf)
            FfiConverterDouble.write(value.`frequency`, buf)
    }
}



/**
 * This is what is returned.
 */
data class HistoryMetadata (
    var `url`: kotlin.String, 
    var `title`: kotlin.String?, 
    var `previewImageUrl`: kotlin.String?, 
    var `createdAt`: kotlin.Long, 
    var `updatedAt`: kotlin.Long, 
    var `totalViewTime`: kotlin.Int, 
    var `searchTerm`: kotlin.String?, 
    var `documentType`: DocumentType, 
    var `referrerUrl`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeHistoryMetadata: FfiConverterRustBuffer<HistoryMetadata> {
    override fun read(buf: ByteBuffer): HistoryMetadata {
        return HistoryMetadata(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterLong.read(buf),
            FfiConverterLong.read(buf),
            FfiConverterInt.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterTypeDocumentType.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: HistoryMetadata) = (
            FfiConverterString.allocationSize(value.`url`) +
            FfiConverterOptionalString.allocationSize(value.`title`) +
            FfiConverterOptionalString.allocationSize(value.`previewImageUrl`) +
            FfiConverterLong.allocationSize(value.`createdAt`) +
            FfiConverterLong.allocationSize(value.`updatedAt`) +
            FfiConverterInt.allocationSize(value.`totalViewTime`) +
            FfiConverterOptionalString.allocationSize(value.`searchTerm`) +
            FfiConverterTypeDocumentType.allocationSize(value.`documentType`) +
            FfiConverterOptionalString.allocationSize(value.`referrerUrl`)
    )

    override fun write(value: HistoryMetadata, buf: ByteBuffer) {
            FfiConverterString.write(value.`url`, buf)
            FfiConverterOptionalString.write(value.`title`, buf)
            FfiConverterOptionalString.write(value.`previewImageUrl`, buf)
            FfiConverterLong.write(value.`createdAt`, buf)
            FfiConverterLong.write(value.`updatedAt`, buf)
            FfiConverterInt.write(value.`totalViewTime`, buf)
            FfiConverterOptionalString.write(value.`searchTerm`, buf)
            FfiConverterTypeDocumentType.write(value.`documentType`, buf)
            FfiConverterOptionalString.write(value.`referrerUrl`, buf)
    }
}



/**
 * This is used as an "input" to the api.
 */
data class HistoryMetadataObservation (
    var `url`: kotlin.String, 
    var `referrerUrl`: kotlin.String? = null, 
    var `searchTerm`: kotlin.String? = null, 
    var `viewTime`: kotlin.Int? = null, 
    var `documentType`: DocumentType? = null, 
    var `title`: kotlin.String? = null
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeHistoryMetadataObservation: FfiConverterRustBuffer<HistoryMetadataObservation> {
    override fun read(buf: ByteBuffer): HistoryMetadataObservation {
        return HistoryMetadataObservation(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalInt.read(buf),
            FfiConverterOptionalTypeDocumentType.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: HistoryMetadataObservation) = (
            FfiConverterString.allocationSize(value.`url`) +
            FfiConverterOptionalString.allocationSize(value.`referrerUrl`) +
            FfiConverterOptionalString.allocationSize(value.`searchTerm`) +
            FfiConverterOptionalInt.allocationSize(value.`viewTime`) +
            FfiConverterOptionalTypeDocumentType.allocationSize(value.`documentType`) +
            FfiConverterOptionalString.allocationSize(value.`title`)
    )

    override fun write(value: HistoryMetadataObservation, buf: ByteBuffer) {
            FfiConverterString.write(value.`url`, buf)
            FfiConverterOptionalString.write(value.`referrerUrl`, buf)
            FfiConverterOptionalString.write(value.`searchTerm`, buf)
            FfiConverterOptionalInt.write(value.`viewTime`, buf)
            FfiConverterOptionalTypeDocumentType.write(value.`documentType`, buf)
            FfiConverterOptionalString.write(value.`title`, buf)
    }
}



data class HistoryMigrationResult (
    var `numTotal`: kotlin.UInt, 
    var `numSucceeded`: kotlin.UInt, 
    var `numFailed`: kotlin.UInt, 
    var `totalDuration`: kotlin.ULong
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeHistoryMigrationResult: FfiConverterRustBuffer<HistoryMigrationResult> {
    override fun read(buf: ByteBuffer): HistoryMigrationResult {
        return HistoryMigrationResult(
            FfiConverterUInt.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterULong.read(buf),
        )
    }

    override fun allocationSize(value: HistoryMigrationResult) = (
            FfiConverterUInt.allocationSize(value.`numTotal`) +
            FfiConverterUInt.allocationSize(value.`numSucceeded`) +
            FfiConverterUInt.allocationSize(value.`numFailed`) +
            FfiConverterULong.allocationSize(value.`totalDuration`)
    )

    override fun write(value: HistoryMigrationResult, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`numTotal`, buf)
            FfiConverterUInt.write(value.`numSucceeded`, buf)
            FfiConverterUInt.write(value.`numFailed`, buf)
            FfiConverterULong.write(value.`totalDuration`, buf)
    }
}



data class HistoryVisitInfo (
    var `url`: Url, 
    var `title`: kotlin.String?, 
    var `timestamp`: PlacesTimestamp, 
    var `visitType`: VisitType, 
    var `isHidden`: kotlin.Boolean, 
    var `previewImageUrl`: Url?, 
    var `isRemote`: kotlin.Boolean
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeHistoryVisitInfo: FfiConverterRustBuffer<HistoryVisitInfo> {
    override fun read(buf: ByteBuffer): HistoryVisitInfo {
        return HistoryVisitInfo(
            FfiConverterTypeUrl.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterTypePlacesTimestamp.read(buf),
            FfiConverterTypeVisitType.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalTypeUrl.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: HistoryVisitInfo) = (
            FfiConverterTypeUrl.allocationSize(value.`url`) +
            FfiConverterOptionalString.allocationSize(value.`title`) +
            FfiConverterTypePlacesTimestamp.allocationSize(value.`timestamp`) +
            FfiConverterTypeVisitType.allocationSize(value.`visitType`) +
            FfiConverterBoolean.allocationSize(value.`isHidden`) +
            FfiConverterOptionalTypeUrl.allocationSize(value.`previewImageUrl`) +
            FfiConverterBoolean.allocationSize(value.`isRemote`)
    )

    override fun write(value: HistoryVisitInfo, buf: ByteBuffer) {
            FfiConverterTypeUrl.write(value.`url`, buf)
            FfiConverterOptionalString.write(value.`title`, buf)
            FfiConverterTypePlacesTimestamp.write(value.`timestamp`, buf)
            FfiConverterTypeVisitType.write(value.`visitType`, buf)
            FfiConverterBoolean.write(value.`isHidden`, buf)
            FfiConverterOptionalTypeUrl.write(value.`previewImageUrl`, buf)
            FfiConverterBoolean.write(value.`isRemote`, buf)
    }
}



data class HistoryVisitInfosWithBound (
    var `infos`: List<HistoryVisitInfo>, 
    var `bound`: kotlin.Long, 
    var `offset`: kotlin.Long
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeHistoryVisitInfosWithBound: FfiConverterRustBuffer<HistoryVisitInfosWithBound> {
    override fun read(buf: ByteBuffer): HistoryVisitInfosWithBound {
        return HistoryVisitInfosWithBound(
            FfiConverterSequenceTypeHistoryVisitInfo.read(buf),
            FfiConverterLong.read(buf),
            FfiConverterLong.read(buf),
        )
    }

    override fun allocationSize(value: HistoryVisitInfosWithBound) = (
            FfiConverterSequenceTypeHistoryVisitInfo.allocationSize(value.`infos`) +
            FfiConverterLong.allocationSize(value.`bound`) +
            FfiConverterLong.allocationSize(value.`offset`)
    )

    override fun write(value: HistoryVisitInfosWithBound, buf: ByteBuffer) {
            FfiConverterSequenceTypeHistoryVisitInfo.write(value.`infos`, buf)
            FfiConverterLong.write(value.`bound`, buf)
            FfiConverterLong.write(value.`offset`, buf)
    }
}



data class InsertableBookmark (
    var `guid`: Guid? = null, 
    var `parentGuid`: Guid, 
    var `position`: BookmarkPosition, 
    var `dateAdded`: PlacesTimestamp? = null, 
    var `lastModified`: PlacesTimestamp? = null, 
    var `url`: Url, 
    var `title`: kotlin.String? = null
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeInsertableBookmark: FfiConverterRustBuffer<InsertableBookmark> {
    override fun read(buf: ByteBuffer): InsertableBookmark {
        return InsertableBookmark(
            FfiConverterOptionalTypeGuid.read(buf),
            FfiConverterTypeGuid.read(buf),
            FfiConverterTypeBookmarkPosition.read(buf),
            FfiConverterOptionalTypePlacesTimestamp.read(buf),
            FfiConverterOptionalTypePlacesTimestamp.read(buf),
            FfiConverterTypeUrl.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: InsertableBookmark) = (
            FfiConverterOptionalTypeGuid.allocationSize(value.`guid`) +
            FfiConverterTypeGuid.allocationSize(value.`parentGuid`) +
            FfiConverterTypeBookmarkPosition.allocationSize(value.`position`) +
            FfiConverterOptionalTypePlacesTimestamp.allocationSize(value.`dateAdded`) +
            FfiConverterOptionalTypePlacesTimestamp.allocationSize(value.`lastModified`) +
            FfiConverterTypeUrl.allocationSize(value.`url`) +
            FfiConverterOptionalString.allocationSize(value.`title`)
    )

    override fun write(value: InsertableBookmark, buf: ByteBuffer) {
            FfiConverterOptionalTypeGuid.write(value.`guid`, buf)
            FfiConverterTypeGuid.write(value.`parentGuid`, buf)
            FfiConverterTypeBookmarkPosition.write(value.`position`, buf)
            FfiConverterOptionalTypePlacesTimestamp.write(value.`dateAdded`, buf)
            FfiConverterOptionalTypePlacesTimestamp.write(value.`lastModified`, buf)
            FfiConverterTypeUrl.write(value.`url`, buf)
            FfiConverterOptionalString.write(value.`title`, buf)
    }
}



data class InsertableBookmarkFolder (
    var `guid`: Guid? = null, 
    var `parentGuid`: Guid, 
    var `position`: BookmarkPosition, 
    var `dateAdded`: PlacesTimestamp? = null, 
    var `lastModified`: PlacesTimestamp? = null, 
    var `title`: kotlin.String? = null, 
    var `children`: List<InsertableBookmarkItem>
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeInsertableBookmarkFolder: FfiConverterRustBuffer<InsertableBookmarkFolder> {
    override fun read(buf: ByteBuffer): InsertableBookmarkFolder {
        return InsertableBookmarkFolder(
            FfiConverterOptionalTypeGuid.read(buf),
            FfiConverterTypeGuid.read(buf),
            FfiConverterTypeBookmarkPosition.read(buf),
            FfiConverterOptionalTypePlacesTimestamp.read(buf),
            FfiConverterOptionalTypePlacesTimestamp.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterSequenceTypeInsertableBookmarkItem.read(buf),
        )
    }

    override fun allocationSize(value: InsertableBookmarkFolder) = (
            FfiConverterOptionalTypeGuid.allocationSize(value.`guid`) +
            FfiConverterTypeGuid.allocationSize(value.`parentGuid`) +
            FfiConverterTypeBookmarkPosition.allocationSize(value.`position`) +
            FfiConverterOptionalTypePlacesTimestamp.allocationSize(value.`dateAdded`) +
            FfiConverterOptionalTypePlacesTimestamp.allocationSize(value.`lastModified`) +
            FfiConverterOptionalString.allocationSize(value.`title`) +
            FfiConverterSequenceTypeInsertableBookmarkItem.allocationSize(value.`children`)
    )

    override fun write(value: InsertableBookmarkFolder, buf: ByteBuffer) {
            FfiConverterOptionalTypeGuid.write(value.`guid`, buf)
            FfiConverterTypeGuid.write(value.`parentGuid`, buf)
            FfiConverterTypeBookmarkPosition.write(value.`position`, buf)
            FfiConverterOptionalTypePlacesTimestamp.write(value.`dateAdded`, buf)
            FfiConverterOptionalTypePlacesTimestamp.write(value.`lastModified`, buf)
            FfiConverterOptionalString.write(value.`title`, buf)
            FfiConverterSequenceTypeInsertableBookmarkItem.write(value.`children`, buf)
    }
}



data class InsertableBookmarkSeparator (
    var `guid`: Guid? = null, 
    var `parentGuid`: Guid, 
    var `position`: BookmarkPosition, 
    var `dateAdded`: PlacesTimestamp? = null, 
    var `lastModified`: PlacesTimestamp? = null
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeInsertableBookmarkSeparator: FfiConverterRustBuffer<InsertableBookmarkSeparator> {
    override fun read(buf: ByteBuffer): InsertableBookmarkSeparator {
        return InsertableBookmarkSeparator(
            FfiConverterOptionalTypeGuid.read(buf),
            FfiConverterTypeGuid.read(buf),
            FfiConverterTypeBookmarkPosition.read(buf),
            FfiConverterOptionalTypePlacesTimestamp.read(buf),
            FfiConverterOptionalTypePlacesTimestamp.read(buf),
        )
    }

    override fun allocationSize(value: InsertableBookmarkSeparator) = (
            FfiConverterOptionalTypeGuid.allocationSize(value.`guid`) +
            FfiConverterTypeGuid.allocationSize(value.`parentGuid`) +
            FfiConverterTypeBookmarkPosition.allocationSize(value.`position`) +
            FfiConverterOptionalTypePlacesTimestamp.allocationSize(value.`dateAdded`) +
            FfiConverterOptionalTypePlacesTimestamp.allocationSize(value.`lastModified`)
    )

    override fun write(value: InsertableBookmarkSeparator, buf: ByteBuffer) {
            FfiConverterOptionalTypeGuid.write(value.`guid`, buf)
            FfiConverterTypeGuid.write(value.`parentGuid`, buf)
            FfiConverterTypeBookmarkPosition.write(value.`position`, buf)
            FfiConverterOptionalTypePlacesTimestamp.write(value.`dateAdded`, buf)
            FfiConverterOptionalTypePlacesTimestamp.write(value.`lastModified`, buf)
    }
}



/**
 * Options for recording history metadata observations.
 */
data class NoteHistoryMetadataObservationOptions (
    var `ifPageMissing`: HistoryMetadataPageMissingBehavior = HistoryMetadataPageMissingBehavior.IGNORE_OBSERVATION
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeNoteHistoryMetadataObservationOptions: FfiConverterRustBuffer<NoteHistoryMetadataObservationOptions> {
    override fun read(buf: ByteBuffer): NoteHistoryMetadataObservationOptions {
        return NoteHistoryMetadataObservationOptions(
            FfiConverterTypeHistoryMetadataPageMissingBehavior.read(buf),
        )
    }

    override fun allocationSize(value: NoteHistoryMetadataObservationOptions) = (
            FfiConverterTypeHistoryMetadataPageMissingBehavior.allocationSize(value.`ifPageMissing`)
    )

    override fun write(value: NoteHistoryMetadataObservationOptions, buf: ByteBuffer) {
            FfiConverterTypeHistoryMetadataPageMissingBehavior.write(value.`ifPageMissing`, buf)
    }
}



data class RunMaintenanceMetrics (
    var `prunedVisits`: kotlin.Boolean, 
    var `dbSizeBefore`: kotlin.UInt, 
    var `dbSizeAfter`: kotlin.UInt
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeRunMaintenanceMetrics: FfiConverterRustBuffer<RunMaintenanceMetrics> {
    override fun read(buf: ByteBuffer): RunMaintenanceMetrics {
        return RunMaintenanceMetrics(
            FfiConverterBoolean.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterUInt.read(buf),
        )
    }

    override fun allocationSize(value: RunMaintenanceMetrics) = (
            FfiConverterBoolean.allocationSize(value.`prunedVisits`) +
            FfiConverterUInt.allocationSize(value.`dbSizeBefore`) +
            FfiConverterUInt.allocationSize(value.`dbSizeAfter`)
    )

    override fun write(value: RunMaintenanceMetrics, buf: ByteBuffer) {
            FfiConverterBoolean.write(value.`prunedVisits`, buf)
            FfiConverterUInt.write(value.`dbSizeBefore`, buf)
            FfiConverterUInt.write(value.`dbSizeAfter`, buf)
    }
}



data class SearchResult (
    var `url`: Url, 
    var `title`: kotlin.String, 
    var `frecency`: kotlin.Long
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeSearchResult: FfiConverterRustBuffer<SearchResult> {
    override fun read(buf: ByteBuffer): SearchResult {
        return SearchResult(
            FfiConverterTypeUrl.read(buf),
            FfiConverterString.read(buf),
            FfiConverterLong.read(buf),
        )
    }

    override fun allocationSize(value: SearchResult) = (
            FfiConverterTypeUrl.allocationSize(value.`url`) +
            FfiConverterString.allocationSize(value.`title`) +
            FfiConverterLong.allocationSize(value.`frecency`)
    )

    override fun write(value: SearchResult, buf: ByteBuffer) {
            FfiConverterTypeUrl.write(value.`url`, buf)
            FfiConverterString.write(value.`title`, buf)
            FfiConverterLong.write(value.`frecency`, buf)
    }
}



data class TopFrecentSiteInfo (
    var `url`: Url, 
    var `title`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeTopFrecentSiteInfo: FfiConverterRustBuffer<TopFrecentSiteInfo> {
    override fun read(buf: ByteBuffer): TopFrecentSiteInfo {
        return TopFrecentSiteInfo(
            FfiConverterTypeUrl.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: TopFrecentSiteInfo) = (
            FfiConverterTypeUrl.allocationSize(value.`url`) +
            FfiConverterOptionalString.allocationSize(value.`title`)
    )

    override fun write(value: TopFrecentSiteInfo, buf: ByteBuffer) {
            FfiConverterTypeUrl.write(value.`url`, buf)
            FfiConverterOptionalString.write(value.`title`, buf)
    }
}



/**
 * Encapsulates either information about a visit to a page, or meta information about the page,
 * or both. Use [VisitType.UPDATE_PLACE] to differentiate an update from a visit.
 */
data class VisitObservation (
    var `url`: Url, 
    var `title`: kotlin.String? = null, 
    var `visitType`: VisitType?, 
    var `isError`: kotlin.Boolean? = null, 
    var `isRedirectSource`: kotlin.Boolean? = null, 
    var `isPermanentRedirectSource`: kotlin.Boolean? = null, 
    var `at`: PlacesTimestamp? = null, 
    var `referrer`: Url? = null, 
    var `isRemote`: kotlin.Boolean? = null, 
    var `previewImageUrl`: Url? = null
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeVisitObservation: FfiConverterRustBuffer<VisitObservation> {
    override fun read(buf: ByteBuffer): VisitObservation {
        return VisitObservation(
            FfiConverterTypeUrl.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalTypeVisitType.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterOptionalTypePlacesTimestamp.read(buf),
            FfiConverterOptionalTypeUrl.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterOptionalTypeUrl.read(buf),
        )
    }

    override fun allocationSize(value: VisitObservation) = (
            FfiConverterTypeUrl.allocationSize(value.`url`) +
            FfiConverterOptionalString.allocationSize(value.`title`) +
            FfiConverterOptionalTypeVisitType.allocationSize(value.`visitType`) +
            FfiConverterOptionalBoolean.allocationSize(value.`isError`) +
            FfiConverterOptionalBoolean.allocationSize(value.`isRedirectSource`) +
            FfiConverterOptionalBoolean.allocationSize(value.`isPermanentRedirectSource`) +
            FfiConverterOptionalTypePlacesTimestamp.allocationSize(value.`at`) +
            FfiConverterOptionalTypeUrl.allocationSize(value.`referrer`) +
            FfiConverterOptionalBoolean.allocationSize(value.`isRemote`) +
            FfiConverterOptionalTypeUrl.allocationSize(value.`previewImageUrl`)
    )

    override fun write(value: VisitObservation, buf: ByteBuffer) {
            FfiConverterTypeUrl.write(value.`url`, buf)
            FfiConverterOptionalString.write(value.`title`, buf)
            FfiConverterOptionalTypeVisitType.write(value.`visitType`, buf)
            FfiConverterOptionalBoolean.write(value.`isError`, buf)
            FfiConverterOptionalBoolean.write(value.`isRedirectSource`, buf)
            FfiConverterOptionalBoolean.write(value.`isPermanentRedirectSource`, buf)
            FfiConverterOptionalTypePlacesTimestamp.write(value.`at`, buf)
            FfiConverterOptionalTypeUrl.write(value.`referrer`, buf)
            FfiConverterOptionalBoolean.write(value.`isRemote`, buf)
            FfiConverterOptionalTypeUrl.write(value.`previewImageUrl`, buf)
    }
}



sealed class BookmarkItem {
    
    data class Bookmark(
        val `b`: BookmarkData) : BookmarkItem() {
        companion object
    }
    
    data class Separator(
        val `s`: BookmarkSeparator) : BookmarkItem() {
        companion object
    }
    
    data class Folder(
        val `f`: BookmarkFolder) : BookmarkItem() {
        companion object
    }
    

    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeBookmarkItem : FfiConverterRustBuffer<BookmarkItem>{
    override fun read(buf: ByteBuffer): BookmarkItem {
        return when(buf.getInt()) {
            1 -> BookmarkItem.Bookmark(
                FfiConverterTypeBookmarkData.read(buf),
                )
            2 -> BookmarkItem.Separator(
                FfiConverterTypeBookmarkSeparator.read(buf),
                )
            3 -> BookmarkItem.Folder(
                FfiConverterTypeBookmarkFolder.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: BookmarkItem) = when(value) {
        is BookmarkItem.Bookmark -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterTypeBookmarkData.allocationSize(value.`b`)
            )
        }
        is BookmarkItem.Separator -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterTypeBookmarkSeparator.allocationSize(value.`s`)
            )
        }
        is BookmarkItem.Folder -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterTypeBookmarkFolder.allocationSize(value.`f`)
            )
        }
    }

    override fun write(value: BookmarkItem, buf: ByteBuffer) {
        when(value) {
            is BookmarkItem.Bookmark -> {
                buf.putInt(1)
                FfiConverterTypeBookmarkData.write(value.`b`, buf)
                Unit
            }
            is BookmarkItem.Separator -> {
                buf.putInt(2)
                FfiConverterTypeBookmarkSeparator.write(value.`s`, buf)
                Unit
            }
            is BookmarkItem.Folder -> {
                buf.putInt(3)
                FfiConverterTypeBookmarkFolder.write(value.`f`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}





/**
 * Where the item should be placed.
 */
sealed class BookmarkPosition {
    
    data class Specific(
        val `pos`: kotlin.UInt) : BookmarkPosition() {
        companion object
    }
    
    object Append : BookmarkPosition()
    
    

    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeBookmarkPosition : FfiConverterRustBuffer<BookmarkPosition>{
    override fun read(buf: ByteBuffer): BookmarkPosition {
        return when(buf.getInt()) {
            1 -> BookmarkPosition.Specific(
                FfiConverterUInt.read(buf),
                )
            2 -> BookmarkPosition.Append
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: BookmarkPosition) = when(value) {
        is BookmarkPosition.Specific -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterUInt.allocationSize(value.`pos`)
            )
        }
        is BookmarkPosition.Append -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
            )
        }
    }

    override fun write(value: BookmarkPosition, buf: ByteBuffer) {
        when(value) {
            is BookmarkPosition.Specific -> {
                buf.putInt(1)
                FfiConverterUInt.write(value.`pos`, buf)
                Unit
            }
            is BookmarkPosition.Append -> {
                buf.putInt(2)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class ConnectionType {
    
    READ_ONLY,
    READ_WRITE,
    SYNC;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeConnectionType: FfiConverterRustBuffer<ConnectionType> {
    override fun read(buf: ByteBuffer) = try {
        ConnectionType.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: ConnectionType) = 4UL

    override fun write(value: ConnectionType, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class DocumentType {
    
    /**
     * A page that isn't described by any other more specific types.
     */
    REGULAR,
    /**
     * A media page.
     */
    MEDIA;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeDocumentType: FfiConverterRustBuffer<DocumentType> {
    override fun read(buf: ByteBuffer) = try {
        DocumentType.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: DocumentType) = 4UL

    override fun write(value: DocumentType, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}





/**
 * Frecency threshold options for fetching top frecent sites. Requests a page that was visited
 * with a frecency score greater or equal to the value associated with the enums
 */

enum class FrecencyThresholdOption {
    
    /**
     * Returns all visited pages. The frecency score is 0
     */
    NONE,
    /**
     * Skip visited pages that were only visited once. The frecency score is 101
     */
    SKIP_ONE_TIME_PAGES;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeFrecencyThresholdOption: FfiConverterRustBuffer<FrecencyThresholdOption> {
    override fun read(buf: ByteBuffer) = try {
        FrecencyThresholdOption.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: FrecencyThresholdOption) = 4UL

    override fun write(value: FrecencyThresholdOption, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}





/**
 * The action to take when recording a history metadata observation for
 * a page that doesn't have an entry in the history database.
 */

enum class HistoryMetadataPageMissingBehavior {
    
    /**
     * Insert an entry for the page into the history database.
     */
    INSERT_PAGE,
    /**
     * Ignore and discard the observation. This is the default behavior.
     */
    IGNORE_OBSERVATION;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeHistoryMetadataPageMissingBehavior: FfiConverterRustBuffer<HistoryMetadataPageMissingBehavior> {
    override fun read(buf: ByteBuffer) = try {
        HistoryMetadataPageMissingBehavior.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: HistoryMetadataPageMissingBehavior) = 4UL

    override fun write(value: HistoryMetadataPageMissingBehavior, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}





sealed class InsertableBookmarkItem {
    
    data class Bookmark(
        val `b`: InsertableBookmark) : InsertableBookmarkItem() {
        companion object
    }
    
    data class Folder(
        val `f`: InsertableBookmarkFolder) : InsertableBookmarkItem() {
        companion object
    }
    
    data class Separator(
        val `s`: InsertableBookmarkSeparator) : InsertableBookmarkItem() {
        companion object
    }
    

    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeInsertableBookmarkItem : FfiConverterRustBuffer<InsertableBookmarkItem>{
    override fun read(buf: ByteBuffer): InsertableBookmarkItem {
        return when(buf.getInt()) {
            1 -> InsertableBookmarkItem.Bookmark(
                FfiConverterTypeInsertableBookmark.read(buf),
                )
            2 -> InsertableBookmarkItem.Folder(
                FfiConverterTypeInsertableBookmarkFolder.read(buf),
                )
            3 -> InsertableBookmarkItem.Separator(
                FfiConverterTypeInsertableBookmarkSeparator.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: InsertableBookmarkItem) = when(value) {
        is InsertableBookmarkItem.Bookmark -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterTypeInsertableBookmark.allocationSize(value.`b`)
            )
        }
        is InsertableBookmarkItem.Folder -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterTypeInsertableBookmarkFolder.allocationSize(value.`f`)
            )
        }
        is InsertableBookmarkItem.Separator -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterTypeInsertableBookmarkSeparator.allocationSize(value.`s`)
            )
        }
    }

    override fun write(value: InsertableBookmarkItem, buf: ByteBuffer) {
        when(value) {
            is InsertableBookmarkItem.Bookmark -> {
                buf.putInt(1)
                FfiConverterTypeInsertableBookmark.write(value.`b`, buf)
                Unit
            }
            is InsertableBookmarkItem.Folder -> {
                buf.putInt(2)
                FfiConverterTypeInsertableBookmarkFolder.write(value.`f`, buf)
                Unit
            }
            is InsertableBookmarkItem.Separator -> {
                buf.putInt(3)
                FfiConverterTypeInsertableBookmarkSeparator.write(value.`s`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}







sealed class PlacesApiException: kotlin.Exception() {
    
    class UnexpectedPlacesException(
        
        val `reason`: kotlin.String
        ) : PlacesApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    class UrlParseFailed(
        
        val `reason`: kotlin.String
        ) : PlacesApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    class PlacesConnectionBusy(
        
        val `reason`: kotlin.String
        ) : PlacesApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    class OperationInterrupted(
        
        val `reason`: kotlin.String
        ) : PlacesApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    class UnknownBookmarkItem(
        
        val `reason`: kotlin.String
        ) : PlacesApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    class InvalidBookmarkOperation(
        
        val `reason`: kotlin.String
        ) : PlacesApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    

    companion object ErrorHandler : UniffiRustCallStatusErrorHandler<PlacesApiException> {
        override fun lift(error_buf: RustBuffer.ByValue): PlacesApiException = FfiConverterTypePlacesApiError.lift(error_buf)
    }

    
}

/**
 * @suppress
 */
public object FfiConverterTypePlacesApiError : FfiConverterRustBuffer<PlacesApiException> {
    override fun read(buf: ByteBuffer): PlacesApiException {
        

        return when(buf.getInt()) {
            1 -> PlacesApiException.UnexpectedPlacesException(
                FfiConverterString.read(buf),
                )
            2 -> PlacesApiException.UrlParseFailed(
                FfiConverterString.read(buf),
                )
            3 -> PlacesApiException.PlacesConnectionBusy(
                FfiConverterString.read(buf),
                )
            4 -> PlacesApiException.OperationInterrupted(
                FfiConverterString.read(buf),
                )
            5 -> PlacesApiException.UnknownBookmarkItem(
                FfiConverterString.read(buf),
                )
            6 -> PlacesApiException.InvalidBookmarkOperation(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: PlacesApiException): ULong {
        return when(value) {
            is PlacesApiException.UnexpectedPlacesException -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
                + FfiConverterString.allocationSize(value.`reason`)
            )
            is PlacesApiException.UrlParseFailed -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
                + FfiConverterString.allocationSize(value.`reason`)
            )
            is PlacesApiException.PlacesConnectionBusy -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
                + FfiConverterString.allocationSize(value.`reason`)
            )
            is PlacesApiException.OperationInterrupted -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
                + FfiConverterString.allocationSize(value.`reason`)
            )
            is PlacesApiException.UnknownBookmarkItem -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
                + FfiConverterString.allocationSize(value.`reason`)
            )
            is PlacesApiException.InvalidBookmarkOperation -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
                + FfiConverterString.allocationSize(value.`reason`)
            )
        }
    }

    override fun write(value: PlacesApiException, buf: ByteBuffer) {
        when(value) {
            is PlacesApiException.UnexpectedPlacesException -> {
                buf.putInt(1)
                FfiConverterString.write(value.`reason`, buf)
                Unit
            }
            is PlacesApiException.UrlParseFailed -> {
                buf.putInt(2)
                FfiConverterString.write(value.`reason`, buf)
                Unit
            }
            is PlacesApiException.PlacesConnectionBusy -> {
                buf.putInt(3)
                FfiConverterString.write(value.`reason`, buf)
                Unit
            }
            is PlacesApiException.OperationInterrupted -> {
                buf.putInt(4)
                FfiConverterString.write(value.`reason`, buf)
                Unit
            }
            is PlacesApiException.UnknownBookmarkItem -> {
                buf.putInt(5)
                FfiConverterString.write(value.`reason`, buf)
                Unit
            }
            is PlacesApiException.InvalidBookmarkOperation -> {
                buf.putInt(6)
                FfiConverterString.write(value.`reason`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




enum class VisitType {
    
    /**
     * This transition type means the user followed a link.
     */
    LINK,
    /**
     * This transition type means that the user typed the page's URL in the
     * URL bar or selected it from UI (URL bar autocomplete results, etc)
     */
    TYPED,
    BOOKMARK,
    EMBED,
    REDIRECT_PERMANENT,
    REDIRECT_TEMPORARY,
    DOWNLOAD,
    FRAMED_LINK,
    RELOAD,
    /**
     * Internal visit type used for meta data updates. Doesn't represent an actual page visit
     */
    UPDATE_PLACE;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeVisitType: FfiConverterRustBuffer<VisitType> {
    override fun read(buf: ByteBuffer) = try {
        VisitType.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: VisitType) = 4UL

    override fun write(value: VisitType, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






/**
 * @suppress
 */
public object FfiConverterOptionalUInt: FfiConverterRustBuffer<kotlin.UInt?> {
    override fun read(buf: ByteBuffer): kotlin.UInt? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterUInt.read(buf)
    }

    override fun allocationSize(value: kotlin.UInt?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterUInt.allocationSize(value)
        }
    }

    override fun write(value: kotlin.UInt?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterUInt.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalInt: FfiConverterRustBuffer<kotlin.Int?> {
    override fun read(buf: ByteBuffer): kotlin.Int? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterInt.read(buf)
    }

    override fun allocationSize(value: kotlin.Int?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterInt.allocationSize(value)
        }
    }

    override fun write(value: kotlin.Int?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterInt.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalBoolean: FfiConverterRustBuffer<kotlin.Boolean?> {
    override fun read(buf: ByteBuffer): kotlin.Boolean? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterBoolean.read(buf)
    }

    override fun allocationSize(value: kotlin.Boolean?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterBoolean.allocationSize(value)
        }
    }

    override fun write(value: kotlin.Boolean?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterBoolean.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalString: FfiConverterRustBuffer<kotlin.String?> {
    override fun read(buf: ByteBuffer): kotlin.String? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterString.read(buf)
    }

    override fun allocationSize(value: kotlin.String?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterString.allocationSize(value)
        }
    }

    override fun write(value: kotlin.String?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterString.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeHistoryMetadata: FfiConverterRustBuffer<HistoryMetadata?> {
    override fun read(buf: ByteBuffer): HistoryMetadata? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeHistoryMetadata.read(buf)
    }

    override fun allocationSize(value: HistoryMetadata?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeHistoryMetadata.allocationSize(value)
        }
    }

    override fun write(value: HistoryMetadata?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeHistoryMetadata.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeBookmarkItem: FfiConverterRustBuffer<BookmarkItem?> {
    override fun read(buf: ByteBuffer): BookmarkItem? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeBookmarkItem.read(buf)
    }

    override fun allocationSize(value: BookmarkItem?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeBookmarkItem.allocationSize(value)
        }
    }

    override fun write(value: BookmarkItem?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeBookmarkItem.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeDocumentType: FfiConverterRustBuffer<DocumentType?> {
    override fun read(buf: ByteBuffer): DocumentType? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeDocumentType.read(buf)
    }

    override fun allocationSize(value: DocumentType?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeDocumentType.allocationSize(value)
        }
    }

    override fun write(value: DocumentType?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeDocumentType.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeVisitType: FfiConverterRustBuffer<VisitType?> {
    override fun read(buf: ByteBuffer): VisitType? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeVisitType.read(buf)
    }

    override fun allocationSize(value: VisitType?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeVisitType.allocationSize(value)
        }
    }

    override fun write(value: VisitType?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeVisitType.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalSequenceTypeHistoryMetadata: FfiConverterRustBuffer<List<HistoryMetadata>?> {
    override fun read(buf: ByteBuffer): List<HistoryMetadata>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeHistoryMetadata.read(buf)
    }

    override fun allocationSize(value: List<HistoryMetadata>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterSequenceTypeHistoryMetadata.allocationSize(value)
        }
    }

    override fun write(value: List<HistoryMetadata>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeHistoryMetadata.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalSequenceTypeBookmarkItem: FfiConverterRustBuffer<List<BookmarkItem>?> {
    override fun read(buf: ByteBuffer): List<BookmarkItem>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeBookmarkItem.read(buf)
    }

    override fun allocationSize(value: List<BookmarkItem>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterSequenceTypeBookmarkItem.allocationSize(value)
        }
    }

    override fun write(value: List<BookmarkItem>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeBookmarkItem.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalSequenceTypeGuid: FfiConverterRustBuffer<List<Guid>?> {
    override fun read(buf: ByteBuffer): List<Guid>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeGuid.read(buf)
    }

    override fun allocationSize(value: List<Guid>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterSequenceTypeGuid.allocationSize(value)
        }
    }

    override fun write(value: List<Guid>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeGuid.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeGuid: FfiConverterRustBuffer<Guid?> {
    override fun read(buf: ByteBuffer): Guid? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeGuid.read(buf)
    }

    override fun allocationSize(value: Guid?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeGuid.allocationSize(value)
        }
    }

    override fun write(value: Guid?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeGuid.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypePlacesTimestamp: FfiConverterRustBuffer<PlacesTimestamp?> {
    override fun read(buf: ByteBuffer): PlacesTimestamp? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypePlacesTimestamp.read(buf)
    }

    override fun allocationSize(value: PlacesTimestamp?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypePlacesTimestamp.allocationSize(value)
        }
    }

    override fun write(value: PlacesTimestamp?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypePlacesTimestamp.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeUrl: FfiConverterRustBuffer<Url?> {
    override fun read(buf: ByteBuffer): Url? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeUrl.read(buf)
    }

    override fun allocationSize(value: Url?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeUrl.allocationSize(value)
        }
    }

    override fun write(value: Url?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeUrl.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceBoolean: FfiConverterRustBuffer<List<kotlin.Boolean>> {
    override fun read(buf: ByteBuffer): List<kotlin.Boolean> {
        val len = buf.getInt()
        return List<kotlin.Boolean>(len) {
            FfiConverterBoolean.read(buf)
        }
    }

    override fun allocationSize(value: List<kotlin.Boolean>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterBoolean.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<kotlin.Boolean>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterBoolean.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceString: FfiConverterRustBuffer<List<kotlin.String>> {
    override fun read(buf: ByteBuffer): List<kotlin.String> {
        val len = buf.getInt()
        return List<kotlin.String>(len) {
            FfiConverterString.read(buf)
        }
    }

    override fun allocationSize(value: List<kotlin.String>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterString.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<kotlin.String>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterString.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeHistoryHighlight: FfiConverterRustBuffer<List<HistoryHighlight>> {
    override fun read(buf: ByteBuffer): List<HistoryHighlight> {
        val len = buf.getInt()
        return List<HistoryHighlight>(len) {
            FfiConverterTypeHistoryHighlight.read(buf)
        }
    }

    override fun allocationSize(value: List<HistoryHighlight>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeHistoryHighlight.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<HistoryHighlight>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeHistoryHighlight.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeHistoryMetadata: FfiConverterRustBuffer<List<HistoryMetadata>> {
    override fun read(buf: ByteBuffer): List<HistoryMetadata> {
        val len = buf.getInt()
        return List<HistoryMetadata>(len) {
            FfiConverterTypeHistoryMetadata.read(buf)
        }
    }

    override fun allocationSize(value: List<HistoryMetadata>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeHistoryMetadata.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<HistoryMetadata>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeHistoryMetadata.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeHistoryVisitInfo: FfiConverterRustBuffer<List<HistoryVisitInfo>> {
    override fun read(buf: ByteBuffer): List<HistoryVisitInfo> {
        val len = buf.getInt()
        return List<HistoryVisitInfo>(len) {
            FfiConverterTypeHistoryVisitInfo.read(buf)
        }
    }

    override fun allocationSize(value: List<HistoryVisitInfo>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeHistoryVisitInfo.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<HistoryVisitInfo>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeHistoryVisitInfo.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeSearchResult: FfiConverterRustBuffer<List<SearchResult>> {
    override fun read(buf: ByteBuffer): List<SearchResult> {
        val len = buf.getInt()
        return List<SearchResult>(len) {
            FfiConverterTypeSearchResult.read(buf)
        }
    }

    override fun allocationSize(value: List<SearchResult>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeSearchResult.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<SearchResult>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeSearchResult.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeTopFrecentSiteInfo: FfiConverterRustBuffer<List<TopFrecentSiteInfo>> {
    override fun read(buf: ByteBuffer): List<TopFrecentSiteInfo> {
        val len = buf.getInt()
        return List<TopFrecentSiteInfo>(len) {
            FfiConverterTypeTopFrecentSiteInfo.read(buf)
        }
    }

    override fun allocationSize(value: List<TopFrecentSiteInfo>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeTopFrecentSiteInfo.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<TopFrecentSiteInfo>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeTopFrecentSiteInfo.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeBookmarkItem: FfiConverterRustBuffer<List<BookmarkItem>> {
    override fun read(buf: ByteBuffer): List<BookmarkItem> {
        val len = buf.getInt()
        return List<BookmarkItem>(len) {
            FfiConverterTypeBookmarkItem.read(buf)
        }
    }

    override fun allocationSize(value: List<BookmarkItem>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeBookmarkItem.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<BookmarkItem>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeBookmarkItem.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeInsertableBookmarkItem: FfiConverterRustBuffer<List<InsertableBookmarkItem>> {
    override fun read(buf: ByteBuffer): List<InsertableBookmarkItem> {
        val len = buf.getInt()
        return List<InsertableBookmarkItem>(len) {
            FfiConverterTypeInsertableBookmarkItem.read(buf)
        }
    }

    override fun allocationSize(value: List<InsertableBookmarkItem>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeInsertableBookmarkItem.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<InsertableBookmarkItem>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeInsertableBookmarkItem.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeGuid: FfiConverterRustBuffer<List<Guid>> {
    override fun read(buf: ByteBuffer): List<Guid> {
        val len = buf.getInt()
        return List<Guid>(len) {
            FfiConverterTypeGuid.read(buf)
        }
    }

    override fun allocationSize(value: List<Guid>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeGuid.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<Guid>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeGuid.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeUrl: FfiConverterRustBuffer<List<Url>> {
    override fun read(buf: ByteBuffer): List<Url> {
        val len = buf.getInt()
        return List<Url>(len) {
            FfiConverterTypeUrl.read(buf)
        }
    }

    override fun allocationSize(value: List<Url>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeUrl.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<Url>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeUrl.write(it, buf)
        }
    }
}



/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 * It's also what we have an external type that references a custom type.
 */
public typealias Guid = kotlin.String
public typealias FfiConverterTypeGuid = FfiConverterString



/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 * It's also what we have an external type that references a custom type.
 */
public typealias PlacesTimestamp = kotlin.Long
public typealias FfiConverterTypePlacesTimestamp = FfiConverterLong



/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 * It's also what we have an external type that references a custom type.
 */
public typealias Url = kotlin.String
public typealias FfiConverterTypeUrl = FfiConverterString



/**
 * Typealias from the type name used in the UDL file to the builtin type.  This
 * is needed because the UDL type name is used in function/method signatures.
 * It's also what we have an external type that references a custom type.
 */
public typealias VisitTransitionSet = kotlin.Int
public typealias FfiConverterTypeVisitTransitionSet = FfiConverterInt
    @Throws(PlacesApiException::class) fun `placesApiNew`(`dbPath`: kotlin.String): PlacesApi {
            return FfiConverterTypePlacesApi.lift(
    uniffiRustCallWithError(PlacesApiException) { _status ->
    UniffiLib.INSTANCE.uniffi_places_fn_func_places_api_new(
        FfiConverterString.lower(`dbPath`),_status)
}
    )
    }
    


