// -*- mode: kotlin -*-

/*
 * AUTOGENERATED BY glean_parser v17.1.0. DO NOT EDIT. DO NOT COMMIT.
 */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
/* ktlint-disable no-blank-line-before-rbrace */
@file:Suppress("PackageNaming", "MaxLineLength")
package org.mozilla.appservices.places.GleanMetrics

import mozilla.telemetry.glean.private.CommonMetricData // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.EventExtras // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.HistogramType // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.Lifetime // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.MemoryUnit // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.NoExtras // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.NoReasonCodes // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.ObjectSerialize // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.ReasonCode // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.TimeUnit // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.CounterMetricType // ktlint-disable import-ordering
import mozilla.telemetry.glean.private.MemoryDistributionMetricType // ktlint-disable import-ordering
import mozilla.telemetry.glean.private.TimingDistributionMetricType // ktlint-disable import-ordering
import mozilla.telemetry.glean.private.LabeledMetricType // ktlint-disable import-ordering

internal object PlacesManager {
    /**
     * Size of the db after executing `run_maintenance()`
     */
    @get:JvmName("dbSizeAfterMaintenance")
    val dbSizeAfterMaintenance: MemoryDistributionMetricType by lazy { // generated from places_manager.db_size_after_maintenance
        MemoryDistributionMetricType(
            CommonMetricData(
                category = "places_manager",
                name = "db_size_after_maintenance",
                sendInPings = listOf("metrics"),
                lifetime = Lifetime.PING,
                disabled = false
            ), memoryUnit = MemoryUnit.KILOBYTE)
    }
    /**
     * The total number of read operations performed on the places store. The count
     * only includes operations triggered by the application, not e.g. incidental
     * reads performed as part of a sync. It is intended to be used together with
     * `read_query_error_count` to measure the overall error rate of read operations
     * on the places store.
     */
    @get:JvmName("readQueryCount")
    val readQueryCount: CounterMetricType by lazy { // generated from places_manager.read_query_count
        CounterMetricType(
            CommonMetricData(
                category = "places_manager",
                name = "read_query_count",
                sendInPings = listOf("metrics"),
                lifetime = Lifetime.PING,
                disabled = false
            ))
    }
    private val readQueryErrorCountLabel: CounterMetricType = // generated from places_manager.read_query_error_count
        CounterMetricType(
            CommonMetricData(
                category = "places_manager",
                name = "read_query_error_count",
                sendInPings = listOf("metrics"),
                lifetime = Lifetime.PING,
                disabled = false
            ))

    /**
     * The total number of errors encountered during read operations on the places
        * store, labeled by type. It is intended to be used together with
        * `read_query_count` to measure the overall error rate of read operations on the
        * places store.
     */
    val readQueryErrorCount: LabeledMetricType<CounterMetricType> by lazy { // generated from places_manager.read_query_error_count
        LabeledMetricType(
            category = "places_manager",
            name = "read_query_error_count",
            subMetric = readQueryErrorCountLabel,
            disabled = false,
            lifetime = Lifetime.PING,
            sendInPings = listOf("metrics"),
            labels = setOf("operation_interrupted", "url_parse_failed")
        )
    }
    /**
     * Time taken to execute `PRAGMA_CHECKPOINT` inside `run_maintenance()`
     */
    @get:JvmName("runMaintenanceChkPntTime")
    val runMaintenanceChkPntTime: TimingDistributionMetricType by lazy { // generated from places_manager.run_maintenance_chk_pnt_time
        TimingDistributionMetricType(
            CommonMetricData(
                category = "places_manager",
                name = "run_maintenance_chk_pnt_time",
                sendInPings = listOf("metrics"),
                lifetime = Lifetime.PING,
                disabled = false
            ), timeUnit = TimeUnit.MILLISECOND)
    }
    /**
     * Time taken to execute `PRAGMA optimize` inside `run_maintenance()`
     */
    @get:JvmName("runMaintenanceOptimizeTime")
    val runMaintenanceOptimizeTime: TimingDistributionMetricType by lazy { // generated from places_manager.run_maintenance_optimize_time
        TimingDistributionMetricType(
            CommonMetricData(
                category = "places_manager",
                name = "run_maintenance_optimize_time",
                sendInPings = listOf("metrics"),
                lifetime = Lifetime.PING,
                disabled = false
            ), timeUnit = TimeUnit.MILLISECOND)
    }
    /**
     * Time taken to execute `prune_older_visits()` inside `run_maintenance()`
     */
    @get:JvmName("runMaintenancePruneTime")
    val runMaintenancePruneTime: TimingDistributionMetricType by lazy { // generated from places_manager.run_maintenance_prune_time
        TimingDistributionMetricType(
            CommonMetricData(
                category = "places_manager",
                name = "run_maintenance_prune_time",
                sendInPings = listOf("metrics"),
                lifetime = Lifetime.PING,
                disabled = false
            ), timeUnit = TimeUnit.MILLISECOND)
    }
    /**
     * Time taken to execute `run_maintenance()`
     */
    @get:JvmName("runMaintenanceTime")
    val runMaintenanceTime: TimingDistributionMetricType by lazy { // generated from places_manager.run_maintenance_time
        TimingDistributionMetricType(
            CommonMetricData(
                category = "places_manager",
                name = "run_maintenance_time",
                sendInPings = listOf("metrics"),
                lifetime = Lifetime.PING,
                disabled = false
            ), timeUnit = TimeUnit.MILLISECOND)
    }
    /**
     * Time taken to execute `VACUUM` inside `run_maintenance()`
     */
    @get:JvmName("runMaintenanceVacuumTime")
    val runMaintenanceVacuumTime: TimingDistributionMetricType by lazy { // generated from places_manager.run_maintenance_vacuum_time
        TimingDistributionMetricType(
            CommonMetricData(
                category = "places_manager",
                name = "run_maintenance_vacuum_time",
                sendInPings = listOf("metrics"),
                lifetime = Lifetime.PING,
                disabled = false
            ), timeUnit = TimeUnit.MILLISECOND)
    }
    /**
     * The total number of write operations performed on the places store. The count
     * only includes operations triggered by the application, not e.g. incidental
     * writes performed as part of a sync. It is intended to be used together with
     * `write_query_error_count` to measure the overall error rate of write operations
     * on the places store.
     */
    @get:JvmName("writeQueryCount")
    val writeQueryCount: CounterMetricType by lazy { // generated from places_manager.write_query_count
        CounterMetricType(
            CommonMetricData(
                category = "places_manager",
                name = "write_query_count",
                sendInPings = listOf("metrics"),
                lifetime = Lifetime.PING,
                disabled = false
            ))
    }
    private val writeQueryErrorCountLabel: CounterMetricType = // generated from places_manager.write_query_error_count
        CounterMetricType(
            CommonMetricData(
                category = "places_manager",
                name = "write_query_error_count",
                sendInPings = listOf("metrics"),
                lifetime = Lifetime.PING,
                disabled = false
            ))

    /**
     * The total number of errors encountered during write operations on the places
        * store, labeled by type. It is intended to be used together with
        * `write_query_count` to measure the overall error rate of write operations on
        * the places store.
     */
    val writeQueryErrorCount: LabeledMetricType<CounterMetricType> by lazy { // generated from places_manager.write_query_error_count
        LabeledMetricType(
            category = "places_manager",
            name = "write_query_error_count",
            subMetric = writeQueryErrorCountLabel,
            disabled = false,
            lifetime = Lifetime.PING,
            sendInPings = listOf("metrics"),
            labels = setOf("bookmarks_corruption", "cannot_update_root", "invalid_bookmark_update", "invalid_parent", "json_parse_failed", "operation_interrupted", "places_connection_busy", "unexpected_places_exception", "unknown_bookmark_item", "url_parse_failed", "url_too_long")
        )
    }
}
