// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("UNUSED_PARAMETER")

package mozilla.appservices.logins

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }











public interface EncryptorDecryptor {
    
    fun `decrypt`(`ciphertext`: kotlin.ByteArray): kotlin.ByteArray
    
    fun `encrypt`(`cleartext`: kotlin.ByteArray): kotlin.ByteArray
    
    companion object
}

open class EncryptorDecryptorImpl (
): AutoCloseable, Disposable, EncryptorDecryptor
{

    
    @Throws(LoginsApiException::class)override fun `decrypt`(`ciphertext`: kotlin.ByteArray): kotlin.ByteArray {
            return  byteArrayOf()
    }

    
    @Throws(LoginsApiException::class)override fun `encrypt`(`cleartext`: kotlin.ByteArray): kotlin.ByteArray {
            return  byteArrayOf()
    }

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



public interface KeyManager {
    
    fun `getKey`(): kotlin.ByteArray
    
    companion object
}

open class KeyManagerImpl (
): AutoCloseable, Disposable, KeyManager
{

    
    @Throws(LoginsApiException::class)override fun `getKey`(): kotlin.ByteArray {
            return  byteArrayOf()
    }

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



public interface LoginStoreInterface {
    
    fun `add`(`login`: LoginEntry): Login
    
    fun `addMany`(`logins`: List<LoginEntry>): List<BulkResultEntry>
    
    fun `addManyWithMeta`(`entriesWithMeta`: List<LoginEntryWithMeta>): List<BulkResultEntry>
    
    fun `addOrUpdate`(`login`: LoginEntry): Login
    
    fun `addWithMeta`(`entryWithMeta`: LoginEntryWithMeta): Login
    
    fun `delete`(`id`: kotlin.String): kotlin.Boolean
    
    /**
     * The `delete_undecryptable_records_for_remote_replacement` function locally deletes stored logins
     * that cannot be decrypted and sets the last sync time to 0 so any existing server records can be downloaded
     * and overwrite the locally deleted records.
     *
     * NB: This function was created to unblock iOS logins users who are unable to sync logins and should not be used
     * outside of this use case.
     */
    fun `deleteUndecryptableRecordsForRemoteReplacement`()
    
    fun `findLoginToUpdate`(`look`: LoginEntry): Login?
    
    fun `get`(`id`: kotlin.String): Login?
    
    fun `getByBaseDomain`(`baseDomain`: kotlin.String): List<Login>
    
    fun `hasLoginsByBaseDomain`(`baseDomain`: kotlin.String): kotlin.Boolean
    
    fun `isEmpty`(): kotlin.Boolean
    
    fun `list`(): List<Login>
    
    fun `registerWithSyncManager`()
    
    fun `reset`()
    
    fun `touch`(`id`: kotlin.String)
    
    fun `update`(`id`: kotlin.String, `login`: LoginEntry): Login
    
    fun `wipeLocal`()
    
    companion object
}

open class LoginStore (private val `path`: kotlin.String = "", private val `encdec`: EncryptorDecryptor = EncryptorDecryptorImpl()
): AutoCloseable, Disposable, LoginStoreInterface
{

    
    @Throws(LoginsApiException::class)override fun `add`(`login`: LoginEntry): Login {
            return  Login()
    }

    
    @Throws(LoginsApiException::class)override fun `addMany`(`logins`: List<LoginEntry>): List<BulkResultEntry> {
            return  emptyList()
    }

    
    @Throws(LoginsApiException::class)override fun `addManyWithMeta`(`entriesWithMeta`: List<LoginEntryWithMeta>): List<BulkResultEntry> {
            return  emptyList()
    }

    
    @Throws(LoginsApiException::class)override fun `addOrUpdate`(`login`: LoginEntry): Login {
            return  Login()
    }

    
    @Throws(LoginsApiException::class)override fun `addWithMeta`(`entryWithMeta`: LoginEntryWithMeta): Login {
            return  Login()
    }

    
    @Throws(LoginsApiException::class)override fun `delete`(`id`: kotlin.String): kotlin.Boolean {
            return  false
    }

    
    /**
     * The `delete_undecryptable_records_for_remote_replacement` function locally deletes stored logins
     * that cannot be decrypted and sets the last sync time to 0 so any existing server records can be downloaded
     * and overwrite the locally deleted records.
     *
     * NB: This function was created to unblock iOS logins users who are unable to sync logins and should not be used
     * outside of this use case.
     */
    @Throws(LoginsApiException::class)override fun `deleteUndecryptableRecordsForRemoteReplacement`()
        {}

    
    @Throws(LoginsApiException::class)override fun `findLoginToUpdate`(`look`: LoginEntry): Login? {
            return  null
    }

    
    @Throws(LoginsApiException::class)override fun `get`(`id`: kotlin.String): Login? {
            return  null
    }

    
    @Throws(LoginsApiException::class)override fun `getByBaseDomain`(`baseDomain`: kotlin.String): List<Login> {
            return  emptyList()
    }

    
    @Throws(LoginsApiException::class)override fun `hasLoginsByBaseDomain`(`baseDomain`: kotlin.String): kotlin.Boolean {
            return  false
    }

    
    @Throws(LoginsApiException::class)override fun `isEmpty`(): kotlin.Boolean {
            return  false
    }

    
    @Throws(LoginsApiException::class)override fun `list`(): List<Login> {
            return  emptyList()
    }

    override fun `registerWithSyncManager`()
        {}

    
    @Throws(LoginsApiException::class)override fun `reset`()
        {}

    
    @Throws(LoginsApiException::class)override fun `touch`(`id`: kotlin.String)
        {}

    
    @Throws(LoginsApiException::class)override fun `update`(`id`: kotlin.String, `login`: LoginEntry): Login {
            return  Login()
    }

    
    @Throws(LoginsApiException::class)override fun `wipeLocal`()
        {}

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



public interface ManagedEncryptorDecryptorInterface {
    
    companion object
}

open class ManagedEncryptorDecryptor (private val `keyManager`: KeyManager = KeyManagerImpl()
): AutoCloseable, Disposable, ManagedEncryptorDecryptorInterface
{

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



public interface StaticKeyManagerInterface {
    
    companion object
}

open class StaticKeyManager (private val `key`: kotlin.String = ""
): AutoCloseable, Disposable, StaticKeyManagerInterface
{

    

    override fun close() {}
    override fun destroy() {}

    
    
    companion object
    
}



/**
 * A login stored in the database
 */
data class Login (
    var `id`: kotlin.String = ""
    , 
    var `timesUsed`: kotlin.Long = 0L
    , 
    var `timeCreated`: kotlin.Long = 0L
    , 
    var `timeLastUsed`: kotlin.Long = 0L
    , 
    var `timePasswordChanged`: kotlin.Long = 0L
    , 
    var `origin`: kotlin.String = ""
    , 
    var `httpRealm`: kotlin.String? = null
    , 
    var `formActionOrigin`: kotlin.String? = null
    , 
    var `usernameField`: kotlin.String = ""
    , 
    var `passwordField`: kotlin.String = ""
    , 
    var `password`: kotlin.String = ""
    , 
    var `username`: kotlin.String = ""
    
) {
    
    companion object
}



/**
 * A login entry from the user, not linked to any database record.
 * The add/update APIs input these.
 */
data class LoginEntry (
    var `origin`: kotlin.String = ""
    , 
    var `httpRealm`: kotlin.String? = null
    , 
    var `formActionOrigin`: kotlin.String? = null
    , 
    var `usernameField`: kotlin.String = ""
    , 
    var `passwordField`: kotlin.String = ""
    , 
    var `password`: kotlin.String = ""
    , 
    var `username`: kotlin.String = ""
    
) {
    
    companion object
}



/**
 * A login together with record fields, handed over to the store API; ie a login persisted
 * elsewhere, useful for migrations
 */
data class LoginEntryWithMeta (
    var `entry`: LoginEntry = LoginEntry()
    , 
    var `meta`: LoginMeta = LoginMeta()
    
) {
    
    companion object
}



/**
 * Login data specific to database records.
 * The add_with_record API inputs this.
 */
data class LoginMeta (
    var `id`: kotlin.String = ""
    , 
    var `timesUsed`: kotlin.Long = 0L
    , 
    var `timeCreated`: kotlin.Long = 0L
    , 
    var `timeLastUsed`: kotlin.Long = 0L
    , 
    var `timePasswordChanged`: kotlin.Long = 0L
    
) {
    
    companion object
}



/**
 * A bulk insert result entry, returned by `add_many` and `add_many_with_meta`
 */
sealed class BulkResultEntry {
    
    data class Success(
        val `login`: Login = Login()) : BulkResultEntry() {
        companion object
    }
    
    data class Error(
        val `message`: kotlin.String = "") : BulkResultEntry() {
        companion object
    }
    
    object __NOOP : BulkResultEntry()

    
    companion object
}






enum class LoginOrErrorMessage {
    
    LOGIN,
    STRING,
    __NOOP;
    companion object
}








/**
 * These are the errors returned by our public API.
 */
sealed class LoginsApiException: kotlin.Exception() {
    
    /**
     * NSS not initialized.
     */
    class NssUninitialized(
        ) : LoginsApiException() {
        override val message
            get() = ""
    }
    
    /**
     * NSS error during authentication
     */
    class NssAuthenticationException(
        
        val `reason`: kotlin.String = ""
        ) : LoginsApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    /**
     * error during authentication (in PrimaryPasswordAuthenticator)
     */
    class AuthenticationException(
        
        val `reason`: kotlin.String = ""
        ) : LoginsApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    /**
     * authentication has been cancelled.
     */
    class AuthenticationCanceled(
        ) : LoginsApiException() {
        override val message
            get() = ""
    }
    
    /**
     * The login data supplied is invalid. The reason will indicate what's wrong with it.
     */
    class InvalidRecord(
        
        val `reason`: kotlin.String = ""
        ) : LoginsApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    /**
     * Asking to do something with a guid which doesn't exist.
     */
    class NoSuchRecord(
        
        val `reason`: kotlin.String = ""
        ) : LoginsApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    /**
     * Encryption key is missing.
     */
    class MissingKey(
        ) : LoginsApiException() {
        override val message
            get() = ""
    }
    
    /**
     * Encryption key is not valid.
     */
    class InvalidKey(
        ) : LoginsApiException() {
        override val message
            get() = ""
    }
    
    /**
     * encryption failed
     */
    class EncryptionFailed(
        
        val `reason`: kotlin.String = ""
        ) : LoginsApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    /**
     * decryption failed
     */
    class DecryptionFailed(
        
        val `reason`: kotlin.String = ""
        ) : LoginsApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    /**
     * An operation was interrupted at the request of the consuming app.
     */
    class Interrupted(
        
        val `reason`: kotlin.String = ""
        ) : LoginsApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    /**
     * Sync reported that authentication failed and the user should re-enter their FxA password.
     */
    class SyncAuthInvalid(
        
        val `reason`: kotlin.String = ""
        ) : LoginsApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    
    /**
     * something internal went wrong which doesn't have a public error value
     * because the consuming app can not reasonably take any action to resolve it.
     * The underlying error will have been logged and reported.
     * (ideally would just be `Unexpected`, but that would be a breaking change)
     */
    class UnexpectedLoginsApiException(
        
        val `reason`: kotlin.String = ""
        ) : LoginsApiException() {
        override val message
            get() = "reason=${ `reason` }"
    }
    

    
}












        /**
         * Check that key is still valid using the output of `create_canary`.
         */
    @Throws(LoginsApiException::class) fun `checkCanary`(`canary`: kotlin.String, `text`: kotlin.String, `encryptionKey`: kotlin.String): kotlin.Boolean {
            return  false
    }

        /**
         * Create a "canary" string, which can be used to test if the encryption
         */
    @Throws(LoginsApiException::class) fun `createCanary`(`text`: kotlin.String, `encryptionKey`: kotlin.String): kotlin.String {
            return  ""
    }

        /**
         * We expose the crypto primitives on the namespace
         * Create a new, random, encryption key.
         */
    @Throws(LoginsApiException::class) fun `createKey`(): kotlin.String {
            return  ""
    }

        /**
         * Create a LoginStore by passing in a db path and a static key
         */ fun `createLoginStoreWithStaticKeyManager`(`path`: kotlin.String, `key`: kotlin.String): LoginStore {
            return  LoginStore()
    }

        /**
         * Similar to create_static_key_manager above, create a
         * ManagedEncryptorDecryptor by passing in a KeyManager
         */ fun `createManagedEncdec`(`keyManager`: KeyManager): EncryptorDecryptor {
            return  EncryptorDecryptorImpl()
    }

        /**
         * Utility function to create a StaticKeyManager to be used for the time
         * being until support lands for [trait implementation of an UniFFI
         * interface](https://mozilla.github.io/uniffi-rs/next/proc_macro/index.html#structs-implementing-traits)
         * in UniFFI. 
         */ fun `createStaticKeyManager`(`key`: kotlin.String): KeyManager {
            return  KeyManagerImpl()
    }


