// -*- mode: kotlin -*-

/*
 * AUTOGENERATED BY glean_parser v17.1.0. DO NOT EDIT. DO NOT COMMIT.
 */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
/* ktlint-disable no-blank-line-before-rbrace */
@file:Suppress("PackageNaming", "MaxLineLength")
package org.mozilla.appservices.logins.GleanMetrics

import mozilla.telemetry.glean.private.CommonMetricData // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.EventExtras // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.HistogramType // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.Lifetime // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.MemoryUnit // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.NoExtras // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.NoReasonCodes // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.ObjectSerialize // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.ReasonCode // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.TimeUnit // ktlint-disable import-ordering no-unused-imports
import mozilla.telemetry.glean.private.CounterMetricType // ktlint-disable import-ordering
import mozilla.telemetry.glean.private.EventMetricType // ktlint-disable import-ordering
import mozilla.telemetry.glean.private.LabeledMetricType // ktlint-disable import-ordering

internal object LoginsStore {
    /**
     * The encryption key was regenerated because it didn't match the encrypted data
     */
    @get:JvmName("keyRegeneratedCorrupt")
    val keyRegeneratedCorrupt: EventMetricType<NoExtras> by lazy { // generated from logins_store.key_regenerated_corrupt
        EventMetricType<NoExtras>(
            CommonMetricData(
                category = "logins_store",
                name = "key_regenerated_corrupt",
                sendInPings = listOf("events"),
                lifetime = Lifetime.PING,
                disabled = false
            ), allowedExtraKeys = listOf())
    }
    /**
     * The encryption key was regenerated because it was lost
     */
    @get:JvmName("keyRegeneratedLost")
    val keyRegeneratedLost: EventMetricType<NoExtras> by lazy { // generated from logins_store.key_regenerated_lost
        EventMetricType<NoExtras>(
            CommonMetricData(
                category = "logins_store",
                name = "key_regenerated_lost",
                sendInPings = listOf("events"),
                lifetime = Lifetime.PING,
                disabled = false
            ), allowedExtraKeys = listOf())
    }
    /**
     * The encryption key was regenerated for an unknown reason
     */
    @get:JvmName("keyRegeneratedOther")
    val keyRegeneratedOther: EventMetricType<NoExtras> by lazy { // generated from logins_store.key_regenerated_other
        EventMetricType<NoExtras>(
            CommonMetricData(
                category = "logins_store",
                name = "key_regenerated_other",
                sendInPings = listOf("events"),
                lifetime = Lifetime.PING,
                disabled = false
            ), allowedExtraKeys = listOf())
    }
    /**
     * The total number of read operations performed on the logins store. The count
     * only includes operations triggered by the application, not e.g. incidental
     * reads performed as part of a sync. It is intended to be used together with
     * `read_query_error_count` to measure the overall error rate of read operations
     * on the logins store.
     */
    @get:JvmName("readQueryCount")
    val readQueryCount: CounterMetricType by lazy { // generated from logins_store.read_query_count
        CounterMetricType(
            CommonMetricData(
                category = "logins_store",
                name = "read_query_count",
                sendInPings = listOf("metrics"),
                lifetime = Lifetime.PING,
                disabled = false
            ))
    }
    private val readQueryErrorCountLabel: CounterMetricType = // generated from logins_store.read_query_error_count
        CounterMetricType(
            CommonMetricData(
                category = "logins_store",
                name = "read_query_error_count",
                sendInPings = listOf("metrics"),
                lifetime = Lifetime.PING,
                disabled = false
            ))

    /**
     * The total number of errors encountered during read operations on the logins
        * store, labeled by type. It is intended to be used together with
        * `read_query_count` to measure the overall error rate of read operations on the
        * logins store.
     */
    val readQueryErrorCount: LabeledMetricType<CounterMetricType> by lazy { // generated from logins_store.read_query_error_count
        LabeledMetricType(
            category = "logins_store",
            name = "read_query_error_count",
            subMetric = readQueryErrorCountLabel,
            disabled = false,
            lifetime = Lifetime.PING,
            sendInPings = listOf("metrics"),
            labels = setOf("interrupted", "storage_error")
        )
    }
    /**
     * The total number of write operations performed on the logins store. The count
     * only includes operations triggered by the application, not e.g. incidental
     * writes performed as part of a sync. It is intended to be used together with
     * `write_query_error_count` to measure the overall error rate of write operations
     * on the logins store.
     */
    @get:JvmName("writeQueryCount")
    val writeQueryCount: CounterMetricType by lazy { // generated from logins_store.write_query_count
        CounterMetricType(
            CommonMetricData(
                category = "logins_store",
                name = "write_query_count",
                sendInPings = listOf("metrics"),
                lifetime = Lifetime.PING,
                disabled = false
            ))
    }
    private val writeQueryErrorCountLabel: CounterMetricType = // generated from logins_store.write_query_error_count
        CounterMetricType(
            CommonMetricData(
                category = "logins_store",
                name = "write_query_error_count",
                sendInPings = listOf("metrics"),
                lifetime = Lifetime.PING,
                disabled = false
            ))

    /**
     * The total number of errors encountered during write operations on the logins
        * store, labeled by type. It is intended to be used together with
        * `write_query_count` to measure the overall error rate of write operations on
        * the logins store.
     */
    val writeQueryErrorCount: LabeledMetricType<CounterMetricType> by lazy { // generated from logins_store.write_query_error_count
        LabeledMetricType(
            category = "logins_store",
            name = "write_query_error_count",
            subMetric = writeQueryErrorCountLabel,
            disabled = false,
            lifetime = Lifetime.PING,
            sendInPings = listOf("metrics"),
            labels = setOf("interrupted", "invalid_record", "no_such_record", "storage_error")
        )
    }
}
